/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleVersions {
    private static final Pattern GRADLE_JAR_NAME_PATTERN = Pattern.compile("gradle-core-(.*)\\.jar");
    @NotNull
    private final GradleProjectSettingsFinder mySettingsFinder;

    @NotNull
    public static GradleVersions getInstance() {
        return (GradleVersions)ServiceManager.getService(GradleVersions.class);
    }

    public GradleVersions(@NotNull GradleProjectSettingsFinder settingsFinder) {
        this.mySettingsFinder = settingsFinder;
    }

    @Nullable
    public GradleVersion getGradleVersion(@NotNull Project project) {
        GradleVersion revision;
        GradleVersion gradleVersion2;
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        if (syncState.isSyncNeeded() != ThreeState.YES && (gradleVersion2 = syncState.getSummary().getGradleVersion()) != null && (revision = GradleVersion.tryParse((String)GradleVersions.removeTimestampFromGradleVersion(gradleVersion2.toString()))) != null) {
            return revision;
        }
        GradleProjectSettings gradleSettings = this.mySettingsFinder.findGradleProjectSettings(project);
        if (gradleSettings != null) {
            String gradleHome;
            DistributionType distributionType = gradleSettings.getDistributionType();
            if (distributionType == DistributionType.DEFAULT_WRAPPED) {
                GradleWrapper gradleWrapper = GradleWrapper.find(project);
                if (gradleWrapper != null) {
                    try {
                        String wrapperVersion = gradleWrapper.getGradleVersion();
                        if (wrapperVersion != null) {
                            return GradleVersion.tryParse((String)GradleVersions.removeTimestampFromGradleVersion(wrapperVersion));
                        }
                    }
                    catch (IOException e) {
                        Logger.getInstance(this.getClass()).info("Failed to read Gradle version in wrapper", (Throwable)e);
                    }
                }
            } else if (distributionType == DistributionType.LOCAL && StringUtil.isNotEmpty((String)(gradleHome = gradleSettings.getGradleHome()))) {
                File gradleHomePath = new File(gradleHome);
                return this.getGradleVersion(gradleHomePath);
            }
        }
        return null;
    }

    @Nullable
    public GradleVersion getGradleVersion(@NotNull File gradleHomePath) {
        File libFolderPath = new File(gradleHomePath, "lib");
        if (libFolderPath.isDirectory()) {
            for (File child : FileUtil.notNullize((File[])libFolderPath.listFiles())) {
                GradleVersion version2 = GradleVersions.getGradleVersionFromJar(child);
                if (version2 == null) continue;
                return version2;
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static GradleVersion getGradleVersionFromJar(@NotNull File libraryJarFile) {
        String fileName = libraryJarFile.getName();
        Matcher matcher = GRADLE_JAR_NAME_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            String version2 = matcher.group(1);
            return GradleVersion.tryParse((String)GradleVersions.removeTimestampFromGradleVersion(version2));
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    public static String removeTimestampFromGradleVersion(@NotNull String gradleVersion2) {
        int dashIndex = gradleVersion2.indexOf(45);
        if (dashIndex != -1) {
            return gradleVersion2.substring(0, dashIndex);
        }
        return gradleVersion2;
    }

    public boolean isGradle4OrNewer(@NotNull Project project) {
        GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion(project);
        return gradleVersion2 != null && gradleVersion2.compareIgnoringQualifiers("4.0") >= 0;
    }
}

