/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.util.PropertiesFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleWrapper {
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*/gradle-([^-]+)(-[^\\/\\\\]+)?-(bin|all).zip");
    @NotNull
    private final File myPropertiesFilePath;
    @Nullable
    private final Project myProject;

    @Nullable
    public static GradleWrapper find(@NotNull Project project) {
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        File baseDir = new File(basePath);
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(baseDir);
        return propertiesFilePath.isFile() ? new GradleWrapper(propertiesFilePath, project) : null;
    }

    @NotNull
    public static GradleWrapper get(@NotNull File propertiesFilePath) {
        return new GradleWrapper(propertiesFilePath, null);
    }

    public static GradleWrapper create(@NotNull File projectPath) throws IOException {
        return GradleWrapper.create(projectPath, "5.4.1");
    }

    public static GradleWrapper create(@NotNull File projectPath, @NotNull String gradleVersion2) throws IOException {
        File wrapperFolderPath = new File(projectPath, SdkConstants.FD_GRADLE_WRAPPER);
        if (!wrapperFolderPath.isDirectory()) {
            File srcFolderPath = new File(TemplateManager.getTemplateRootFolder(), SdkConstants.FD_GRADLE_WRAPPER);
            if (!srcFolderPath.exists()) {
                File root;
                Iterator<File> iterator = TemplateManager.getExtraTemplateRootFolders().iterator();
                while (iterator.hasNext() && !(srcFolderPath = new File(root = iterator.next(), SdkConstants.FD_GRADLE_WRAPPER)).exists()) {
                    srcFolderPath = null;
                }
            }
            if (srcFolderPath == null) {
                return null;
            }
            FileUtil.copyDirContent((File)srcFolderPath, (File)projectPath);
        }
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(projectPath);
        GradleWrapper gradleWrapper = GradleWrapper.get(propertiesFilePath);
        gradleWrapper.updateDistributionUrl(gradleVersion2);
        return gradleWrapper;
    }

    private GradleWrapper(@NotNull File propertiesFilePath, @Nullable Project project) {
        this.myProject = project;
        this.myPropertiesFilePath = propertiesFilePath;
    }

    @NotNull
    public File getPropertiesFilePath() {
        return this.myPropertiesFilePath;
    }

    @Nullable
    public VirtualFile getPropertiesFile() {
        return VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
    }

    @NotNull
    public static File getDefaultPropertiesFilePath(@NotNull File projectPath) {
        return new File(projectPath, GRADLEW_PROPERTIES_PATH);
    }

    public boolean updateDistributionUrlAndDisplayFailure(@NotNull String gradleVersion2) {
        try {
            boolean updated = this.updateDistributionUrl(gradleVersion2);
            if (updated) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
                if (virtualFile != null) {
                    virtualFile.refresh(false, false);
                }
                return true;
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion2);
            msg = msg + e.getMessage();
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
        }
        return false;
    }

    public boolean updateDistributionUrl(@NotNull String gradleVersion2) throws IOException {
        Properties properties = this.getProperties();
        String distributionUrl = GradleWrapper.getDistributionUrl(gradleVersion2, false);
        String property2 = properties.getProperty("distributionUrl");
        if (property2 != null && (property2.equals(distributionUrl) || property2.equals(GradleWrapper.getDistributionUrl(gradleVersion2, true)))) {
            return false;
        }
        properties.setProperty("distributionUrl", distributionUrl);
        PropertiesFiles.savePropertiesToFile(properties, this.myPropertiesFilePath, null);
        return true;
    }

    public void updateDistributionUrl(@NotNull File gradleDistribution) throws IOException {
        String path = gradleDistribution.getPath();
        if (!FileUtilRt.extensionEquals((String)path, (String)"zip")) {
            throw new IllegalArgumentException("'" + path + "' should be a zip file");
        }
        Properties properties = this.getProperties();
        properties.setProperty("distributionUrl", gradleDistribution.toURI().toURL().toString());
        PropertiesFiles.savePropertiesToFile(properties, this.myPropertiesFilePath, null);
    }

    @NotNull
    public Properties getProperties() throws IOException {
        return PropertiesFiles.getProperties(this.myPropertiesFilePath);
    }

    @Nullable
    public String getGradleVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    public String getGradleFullVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1) + Strings.nullToEmpty((String)m.group(2));
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    static String getDistributionUrl(@NotNull String gradleVersion2, boolean binOnly) {
        String folderName = GradleWrapper.isSnapshot(gradleVersion2) ? "distributions-snapshots" : "distributions";
        String suffix = binOnly ? "bin" : "all";
        return String.format("https://services.gradle.org/%1$s/gradle-%2$s-%3$s.zip", folderName, gradleVersion2, suffix);
    }

    @VisibleForTesting
    static boolean isSnapshot(@NotNull String gradleVersion2) {
        return gradleVersion2.indexOf(45) != -1 && gradleVersion2.endsWith("+0000");
    }
}

