/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.Projects;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.util.PropertiesFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalProperties {
    @NotNull
    private final File myPropertiesFilePath;
    @NotNull
    private final File myProjectFolderPath;
    @NotNull
    private final Properties myProperties;
    @Nullable
    private File myNewAndroidSdkPath;
    private boolean myAndroidSdkPathModified;
    @Nullable
    private File myNewAndroidNdkPath;
    private boolean myAndroidNdkPathModified;
    @Nullable
    private File myNewAndroidCmakePath;
    private boolean myAndroidCmakePathModified;

    public LocalProperties(@NotNull Project project) throws IOException {
        this(Projects.getBaseDirPath((Project)project));
    }

    public LocalProperties(@NotNull File projectFolderPath) throws IOException {
        this.myProjectFolderPath = projectFolderPath;
        this.myPropertiesFilePath = new File(projectFolderPath, "local.properties");
        this.myProperties = PropertiesFiles.getProperties(this.myPropertiesFilePath);
    }

    @Nullable
    public File getAndroidSdkPath() {
        if (this.myAndroidSdkPathModified) {
            return this.myNewAndroidSdkPath;
        }
        return this.getAndroidSdkPathFromFile();
    }

    @Nullable
    public File getAndroidNdkPath() {
        if (this.myAndroidNdkPathModified) {
            return this.myNewAndroidNdkPath;
        }
        return this.getAndroidNdkPathFromFile();
    }

    @Nullable
    public File getAndroidCmakePath() {
        if (this.myAndroidCmakePathModified) {
            return this.myNewAndroidCmakePath;
        }
        return this.getAndroidCmakePathFromFile();
    }

    public void setAndroidSdkPath(@NotNull Sdk androidSdk) {
        String androidSdkPath = androidSdk.getHomePath();
        assert (androidSdkPath != null);
        this.setAndroidSdkPath(androidSdkPath);
    }

    public void setAndroidSdkPath(@NotNull String androidSdkPath) {
        this.setAndroidSdkPath(FilePaths.toSystemDependentPath((String)androidSdkPath));
    }

    public void setAndroidSdkPath(@NotNull File androidSdkPath) {
        this.myNewAndroidSdkPath = androidSdkPath;
        this.myAndroidSdkPathModified = true;
    }

    public void setAndroidNdkPath(@NotNull String androidNdkPath) {
        this.setAndroidNdkPath(FilePaths.toSystemDependentPath((String)androidNdkPath));
    }

    public void setAndroidNdkPath(@Nullable File androidNdkPath) {
        this.myNewAndroidNdkPath = androidNdkPath;
        this.myAndroidNdkPathModified = true;
    }

    public void setAndroidCmakePath(@Nullable File androidNdkPath) {
        this.myNewAndroidCmakePath = androidNdkPath;
        this.myAndroidCmakePathModified = true;
    }

    public boolean hasAndroidDirProperty() {
        String property2 = this.getProperty("android.dir");
        return !Strings.isNullOrEmpty((String)property2);
    }

    @Nullable
    public String getProperty(@NotNull String key) {
        return this.myProperties.getProperty(key);
    }

    public void save() throws IOException {
        this.setPathIfApplicable(this.myAndroidSdkPathModified, "sdk.dir", this.getAndroidSdkPathFromFile(), this.myNewAndroidSdkPath);
        this.setPathIfApplicable(this.myAndroidNdkPathModified, "ndk.dir", this.getAndroidNdkPathFromFile(), this.myNewAndroidNdkPath);
        this.setPathIfApplicable(this.myAndroidCmakePathModified, "cmake.dir", this.getAndroidCmakePathFromFile(), this.myNewAndroidCmakePath);
        if (this.myAndroidSdkPathModified || this.myAndroidNdkPathModified || this.myAndroidCmakePathModified) {
            PropertiesFiles.savePropertiesToFile(this.myProperties, this.myPropertiesFilePath, LocalProperties.getHeaderComment());
        }
        this.myNewAndroidNdkPath = null;
        this.myNewAndroidSdkPath = null;
        this.myNewAndroidCmakePath = null;
        this.myAndroidNdkPathModified = false;
        this.myAndroidSdkPathModified = false;
        this.myAndroidCmakePathModified = false;
    }

    private void setPathIfApplicable(boolean pathModified, @NotNull String propertyName, @Nullable File currentPath, @Nullable File newPath) {
        if (pathModified && !FileUtil.filesEqual((File)currentPath, (File)newPath)) {
            String path;
            String string = path = newPath != null ? newPath.getPath() : null;
            if (StringUtil.isNotEmpty((String)path)) {
                this.myProperties.setProperty(propertyName, path);
            } else {
                this.myProperties.remove(propertyName);
            }
        }
    }

    @Nullable
    private File getAndroidSdkPathFromFile() {
        return this.getPath("sdk.dir");
    }

    @Nullable
    private File getAndroidNdkPathFromFile() {
        return this.getPath("ndk.dir");
    }

    @Nullable
    private File getAndroidCmakePathFromFile() {
        return this.getPath("cmake.dir");
    }

    @Nullable
    private File getPath(String property2) {
        String path = this.getProperty(property2);
        if (StringUtil.isNotEmpty((String)path)) {
            String canonicalPath;
            File file;
            if (!FileUtil.isAbsolute((String)path) && !(file = new File(canonicalPath = FileUtil.toCanonicalPath((String)new File(this.myProjectFolderPath, FileUtil.toSystemDependentName((String)path)).getPath()))).isDirectory()) {
                return new File(path);
            }
            return FilePaths.toSystemDependentPath((String)path);
        }
        return null;
    }

    @NotNull
    private static String getHeaderComment() {
        Object[] lines = new String[]{"# This file must *NOT* be checked into Version Control Systems,", "# as it contains information specific to your local configuration.", "", "# Location of the SDK. This is only used by Gradle.", "# For customization when using a Version Control System, please read the", "# header note."};
        return Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
    }

    @NotNull
    public File getPropertiesFilePath() {
        return this.myPropertiesFilePath;
    }

    @VisibleForTesting
    @NotNull
    Properties properties() {
        return this.myProperties;
    }
}

