/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolutionDialog;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConflictResolution {
    private ConflictResolution() {
    }

    public static boolean solveSelectionConflict(@NotNull Conflict conflict) {
        return ConflictResolution.solveSelectionConflict(conflict, true);
    }

    private static boolean solveSelectionConflict(@NotNull Conflict conflict, boolean showConflictResolutionDialog) {
        NdkModuleModel ndkModel;
        AndroidFacet facet = AndroidFacet.getInstance(conflict.getSource());
        if (facet == null || !facet.requiresAndroidModel()) {
            return true;
        }
        AndroidModuleModel source = AndroidModuleModel.get(facet);
        if (source == null) {
            return false;
        }
        String newVariant = ConflictResolution.resolveNewVariant(conflict, showConflictResolutionDialog);
        if (StringUtil.isEmpty((String)newVariant)) {
            return false;
        }
        NdkFacet ndkFacet = NdkFacet.getInstance(conflict.getSource());
        NdkModuleModel ndkModuleModel = ndkModel = ndkFacet == null ? null : ndkFacet.getNdkModuleModel();
        if (ndkModel != null) {
            String newNdkVariant = ConflictResolution.resolveNewNdkVariant(ndkModel, newVariant);
            if (newNdkVariant == null) {
                return false;
            }
            ndkModel.setSelectedVariantName(newNdkVariant);
            ndkFacet.setNdkModuleModel(ndkModel);
        }
        source.setSelectedVariantName(newVariant);
        source.syncSelectedVariantAndTestArtifact(facet);
        return true;
    }

    @Nullable
    private static String resolveNewVariant(@NotNull Conflict conflict, boolean showConflictResolutionDialog) {
        Collection<String> variants = conflict.getVariants();
        if (variants.size() == 1) {
            return (String)ContainerUtil.getFirstItem(variants);
        }
        if (!showConflictResolutionDialog) {
            return null;
        }
        ConflictResolutionDialog dialog2 = new ConflictResolutionDialog(conflict);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2.getSelectedVariant();
    }

    @Nullable
    private static String resolveNewNdkVariant(@NotNull NdkModuleModel ndkModel, @NotNull String newVariant) {
        String userSelectedAbi = ndkModel.getAbiName(ndkModel.getSelectedVariant().getName());
        String ndkVariant = newVariant + "-" + userSelectedAbi;
        if (ndkModel.variantExists(ndkVariant)) {
            return ndkVariant;
        }
        String expectedPrefix = newVariant + "-";
        Optional<NdkVariant> variant = ndkModel.getVariants().stream().filter(it -> it.getName().startsWith(expectedPrefix)).findFirst();
        return variant.map(NdkVariant::getName).orElse(null);
    }
}

