/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.builder.model.level2.Library;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictSet {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ImmutableList<Conflict> mySelectionConflicts;
    @NotNull
    private final ImmutableList<Conflict> myStructureConflicts;

    @NotNull
    public static ConflictSet findConflicts(@NotNull Project project) {
        HashMap selectionConflicts = Maps.newHashMap();
        HashMap structureConflicts = Maps.newHashMap();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            String gradlePath;
            AndroidModuleModel currentAndroidModel = AndroidModuleModel.get(module);
            if (currentAndroidModel == null || currentAndroidModel.getAndroidProject().getProjectType() == 0 || (gradlePath = GradleUtil.getGradlePath(module)) == null) continue;
            String selectedVariant = currentAndroidModel.getSelectedVariant().getName();
            List dependentModules = (List)ApplicationManager.getApplication().runReadAction(() -> ModuleUtilCore.getAllDependentModules((Module)module));
            for (Module dependent : dependentModules) {
                String expectedVariant;
                AndroidModuleModel dependentAndroidModel = AndroidModuleModel.get(dependent);
                if (dependentAndroidModel == null || StringUtil.isEmpty((String)(expectedVariant = ConflictSet.getExpectedVariant(dependentAndroidModel, gradlePath)))) continue;
                ConflictSet.addConflict(structureConflicts, module, selectedVariant, dependent, expectedVariant);
                if (selectedVariant.equals(expectedVariant)) continue;
                ConflictSet.addConflict(selectionConflicts, module, selectedVariant, dependent, expectedVariant);
            }
        }
        ArrayList filteredStructureConflicts = Lists.newArrayList();
        for (Conflict conflict : structureConflicts.values()) {
            if (conflict.getVariants().size() <= 1) continue;
            filteredStructureConflicts.add(conflict);
        }
        return new ConflictSet(project, selectionConflicts.values(), filteredStructureConflicts);
    }

    private static void addConflict(@NotNull Map<String, Conflict> allConflicts, @NotNull Module source, @NotNull String selectedVariant, @NotNull Module affected, @NotNull String expectedVariant) {
        String causeName = source.getName();
        Conflict conflict = allConflicts.computeIfAbsent(causeName, k -> new Conflict(source, selectedVariant));
        conflict.addAffectedModule(affected, expectedVariant);
    }

    @Nullable
    private static String getExpectedVariant(@NotNull AndroidModuleModel dependentAndroidModel, @NotNull String dependencyGradlePath) {
        List<Library> dependencies = GradleUtil.getModuleDependencies(dependentAndroidModel.getSelectedVariant());
        for (Library dependency : dependencies) {
            if (!dependencyGradlePath.equals(dependency.getProjectPath())) continue;
            return dependency.getVariant();
        }
        return null;
    }

    ConflictSet(@NotNull Project project, @NotNull Collection<Conflict> selectionConflicts, @NotNull Collection<Conflict> structureConflicts) {
        this.myProject = project;
        this.mySelectionConflicts = ImmutableList.copyOf(selectionConflicts);
        this.myStructureConflicts = ImmutableList.copyOf(structureConflicts);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<Conflict> getSelectionConflicts() {
        return this.mySelectionConflicts;
    }

    @NotNull
    public List<Conflict> getStructureConflicts() {
        return this.myStructureConflicts;
    }

    public void showSelectionConflicts() {
        GradleSyncMessages messages = GradleSyncMessages.getInstance(this.myProject);
        String groupName = "Variant Selection Conflicts";
        messages.removeMessages(groupName);
        for (final Conflict conflict : this.mySelectionConflicts) {
            final Module source = conflict.getSource();
            String hyperlinkText = String.format("Select '%1$s' in \"Build Variants\" window", source.getName());
            NotificationHyperlink selectInBuildVariantsWindowHyperlink = new NotificationHyperlink("select.conflict.in.variants.window", hyperlinkText){

                @Override
                protected void execute(@NotNull Project project) {
                    BuildVariantView.getInstance(project).findAndSelect(source);
                }
            };
            NotificationHyperlink quickFixHyperlink = new NotificationHyperlink("fix.conflict", "Fix problem"){

                @Override
                protected void execute(@NotNull Project project) {
                    boolean solved = ConflictResolution.solveSelectionConflict(conflict);
                    if (solved) {
                        ConflictSet conflicts = ConflictSet.findConflicts(project);
                        conflicts.showSelectionConflicts();
                    }
                }
            };
            SyncMessage msg = new SyncMessage(groupName, MessageType.WARNING, conflict.toString());
            msg.add(selectInBuildVariantsWindowHyperlink);
            msg.add(quickFixHyperlink);
            messages.report(msg);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isDisposed()) {
                BuildVariantView.getInstance(this.myProject).updateContents((List<Conflict>)this.mySelectionConflicts);
            }
        });
    }
}

