/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.level2.Library;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncOptions;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidVariantChangeModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.NdkVariantChangeModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.BatchUpdatesUtil;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildVariantUpdater {
    @NotNull
    private final ModuleSetupContext.Factory myModuleSetupContextFactory;
    @NotNull
    private final IdeModifiableModelsProviderFactory myModifiableModelsProviderFactory;
    @NotNull
    private final AndroidVariantChangeModuleSetup myAndroidModuleSetupSteps;
    @NotNull
    private final NdkVariantChangeModuleSetup myNdkModuleSetupSteps;
    @NotNull
    private final List<BuildVariantView.BuildVariantSelectionChangeListener> mySelectionChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public static BuildVariantUpdater getInstance(@NotNull Project project) {
        return (BuildVariantUpdater)ServiceManager.getService((Project)project, BuildVariantUpdater.class);
    }

    BuildVariantUpdater() {
        this(new ModuleSetupContext.Factory(), new IdeModifiableModelsProviderFactory(), new AndroidVariantChangeModuleSetup(), new NdkVariantChangeModuleSetup());
    }

    @VisibleForTesting
    BuildVariantUpdater(@NotNull ModuleSetupContext.Factory moduleSetupContextFactory, @NotNull IdeModifiableModelsProviderFactory modifiableModelsProviderFactory, @NotNull AndroidVariantChangeModuleSetup androidModuleSetup, @NotNull NdkVariantChangeModuleSetup ndkModuleSetup) {
        this.myModuleSetupContextFactory = moduleSetupContextFactory;
        this.myModifiableModelsProviderFactory = modifiableModelsProviderFactory;
        this.myAndroidModuleSetupSteps = androidModuleSetup;
        this.myNdkModuleSetupSteps = ndkModuleSetup;
    }

    public void addSelectionChangeListener(@NotNull BuildVariantView.BuildVariantSelectionChangeListener listener2) {
        this.mySelectionChangeListeners.add(listener2);
    }

    public void removeSelectionChangeListener(@NotNull BuildVariantView.BuildVariantSelectionChangeListener listener2) {
        this.mySelectionChangeListeners.remove(listener2);
    }

    boolean updateSelectedBuildVariant(@NotNull Project project, @NotNull String moduleName, @NotNull String selectedBuildVariant) {
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module '%1$s'.", moduleName));
            return false;
        }
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(moduleToUpdate);
        if (ndkModuleModel == null) {
            return this.updateSelectedVariant(project, moduleName, selectedBuildVariant);
        }
        String newNdkBuildVariant = BuildVariantUpdater.resolveNewNdkVariant(ndkModuleModel, selectedBuildVariant, null);
        if (newNdkBuildVariant == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find suitable ABI for native module '%1$s'.", moduleName));
            return false;
        }
        return this.updateSelectedVariant(project, moduleName, newNdkBuildVariant);
    }

    boolean updateSelectedAbi(@NotNull Project project, @NotNull String moduleName, @NotNull String selectedAbiName) {
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find module '%1$s'.", moduleName));
            return false;
        }
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(moduleToUpdate);
        if (ndkModuleModel == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find native module model '%1$s'.", moduleName));
            return false;
        }
        String existingNdkBuildVariant = ndkModuleModel.getSelectedVariant().getName();
        String existingBuildVariant = ndkModuleModel.getVariantName(existingNdkBuildVariant);
        String newNdkBuildVariant = BuildVariantUpdater.resolveNewNdkVariant(ndkModuleModel, existingBuildVariant, selectedAbiName);
        if (newNdkBuildVariant == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find suitable ABI for native module '%1$s'.", moduleName));
            return false;
        }
        return this.updateSelectedVariant(project, moduleName, newNdkBuildVariant);
    }

    private boolean updateSelectedVariant(@NotNull Project project, @NotNull String moduleName, @NotNull String buildVariantName) {
        ArrayList<AndroidFacet> affectedAndroidFacets = new ArrayList<AndroidFacet>();
        ArrayList<NdkFacet> affectedNdkFacets = new ArrayList<NdkFacet>();
        boolean variantToUpdateExists = BuildVariantUpdater.findAndUpdateAffectedFacets(project, moduleName, buildVariantName, affectedAndroidFacets, affectedNdkFacets);
        if (affectedAndroidFacets.isEmpty() && affectedNdkFacets.isEmpty()) {
            return false;
        }
        Runnable invokeVariantSelectionChangeListeners = () -> {
            for (BuildVariantView.BuildVariantSelectionChangeListener listener2 : this.mySelectionChangeListeners) {
                listener2.selectionChanged();
            }
        };
        if (BuildVariantUpdater.hasBuildFilesChanged(project)) {
            BuildVariantUpdater.requestFullGradleSync(project, invokeVariantSelectionChangeListeners);
        } else if (!variantToUpdateExists) {
            BuildVariantUpdater.requestVariantOnlyGradleSync(project, moduleName, buildVariantName, invokeVariantSelectionChangeListeners);
        } else {
            this.setupCachedVariant(project, buildVariantName, affectedAndroidFacets, affectedNdkFacets, invokeVariantSelectionChangeListeners);
        }
        return true;
    }

    private static boolean findAndUpdateAffectedFacets(@NotNull Project project, @NotNull String moduleName, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        AndroidModuleModel androidModel;
        NdkModuleModel ndkModuleModel;
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module '%1$s'.", moduleName));
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && ndkFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowBuildVariantFailure(msg);
        }
        boolean ndkVariantExists = true;
        boolean androidVariantExists = true;
        String variantName = variantToSelect;
        String abiName = null;
        if (ndkFacet != null && (ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(ndkFacet)) != null) {
            String abiBeforeChange = ndkModuleModel.getAbiName(ndkModuleModel.getSelectedVariant().getName());
            ndkVariantExists = BuildVariantUpdater.updateAffectedFacetsForNdkModule(ndkFacet, ndkModuleModel, variantToSelect, affectedAndroidFacets, affectedNdkFacets);
            variantName = ndkModuleModel.getVariantName(variantToSelect);
            abiName = ndkModuleModel.getAbiName(variantToSelect);
        }
        if (androidFacet != null && (androidModel = BuildVariantUpdater.getAndroidModel(androidFacet)) != null) {
            androidVariantExists = BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, androidFacet, androidModel, variantName, abiName, affectedAndroidFacets, affectedNdkFacets);
        }
        return ndkVariantExists && androidVariantExists;
    }

    private static boolean updateAffectedFacetsForNdkModule(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModuleModel, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        if (variantToSelect.equals(ndkModuleModel.getSelectedVariant().getName())) {
            return true;
        }
        affectedNdkFacets.add(ndkFacet);
        ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT = variantToSelect;
        if (!ndkModuleModel.variantExists(variantToSelect)) {
            return false;
        }
        ndkModuleModel.setSelectedVariantName(variantToSelect);
        return true;
    }

    private static boolean updateAffectedFacetsForAndroidModule(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull AndroidModuleModel androidModel, @NotNull String variantToSelect, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        boolean isAbiChanged;
        boolean isVariantChanged = !variantToSelect.equals(androidModel.getSelectedVariant().getName());
        boolean bl = isAbiChanged = abiToSelect != null;
        if (!isVariantChanged && !isAbiChanged) {
            return true;
        }
        if (isVariantChanged) {
            affectedAndroidFacets.add(androidFacet);
            androidFacet.getProperties().SELECTED_BUILD_VARIANT = variantToSelect;
        }
        if (!androidModel.variantExists(variantToSelect)) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        BuildVariantUpdater.updateSelectedVariantsForDependencyModules(project, androidModel, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        return true;
    }

    private static void updateSelectedVariantsForDependencyModules(@NotNull Project project, @NotNull AndroidModuleModel androidModel, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        Module dependencyModule;
        for (Library library : androidModel.getSelectedMainCompileLevel2Dependencies().getModuleDependencies()) {
            if (!StringUtil.isNotEmpty((String)library.getVariant()) || !StringUtil.isNotEmpty((String)library.getProjectPath())) continue;
            dependencyModule = ProjectStructure.getInstance(project).getModuleFinder().findModuleFromLibrary(library);
            BuildVariantUpdater.updateDependencyModule(project, library.getProjectPath(), dependencyModule, library.getVariant(), abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
        for (String gradlePath : androidModel.getAndroidProject().getDynamicFeatures()) {
            if (!StringUtil.isNotEmpty((String)gradlePath)) continue;
            dependencyModule = ProjectStructure.getInstance(project).getModuleFinder().findModuleByGradlePath(gradlePath);
            BuildVariantUpdater.updateDependencyModule(project, gradlePath, dependencyModule, androidModel.getSelectedVariant().getName(), abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
    }

    private static void updateDependencyModule(@NotNull Project project, @NotNull String gradlePath, @Nullable Module dependencyModule, @NotNull String projectVariant, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        if (dependencyModule == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module with Gradle path '%1$s'.", gradlePath));
            return;
        }
        AndroidFacet dependencyFacet = AndroidFacet.getInstance(dependencyModule);
        if (dependencyFacet == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find 'Android' facet in module '%1$s'.", dependencyModule.getName()));
            return;
        }
        AndroidModuleModel dependencyModel = BuildVariantUpdater.getAndroidModel(dependencyFacet);
        if (dependencyModel != null) {
            String projectVariantWithAbi;
            NdkModuleModel dependencyNdkModel;
            NdkFacet dependencyNdkFacet = NdkFacet.getInstance(dependencyModule);
            NdkModuleModel ndkModuleModel = dependencyNdkModel = dependencyNdkFacet == null ? null : BuildVariantUpdater.getNdkModelIfNotJustDummy(dependencyNdkFacet);
            if (dependencyNdkModel != null && (projectVariantWithAbi = BuildVariantUpdater.resolveNewNdkVariant(dependencyNdkModel, projectVariant, abiToSelect)) != null) {
                BuildVariantUpdater.updateAffectedFacetsForNdkModule(dependencyNdkFacet, dependencyNdkModel, projectVariantWithAbi, affectedAndroidFacets, affectedNdkFacets);
            }
            BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, dependencyFacet, dependencyModel, projectVariant, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
    }

    @Nullable
    private static String resolveNewNdkVariant(@NotNull NdkModuleModel ndkModel, @NotNull String newVariant, @Nullable String userSelectedAbi) {
        if (userSelectedAbi != null) {
            String ndkVariant = BuildVariantUpdater.getNdkBuildVariantName(newVariant, userSelectedAbi);
            if (ndkModel.getNdkVariantNames().contains(ndkVariant)) {
                return ndkVariant;
            }
        }
        String existingAbi = ndkModel.getAbiName(ndkModel.getSelectedVariant().getName());
        String ndkVariant = BuildVariantUpdater.getNdkBuildVariantName(newVariant, existingAbi);
        if (ndkModel.getNdkVariantNames().contains(ndkVariant)) {
            return ndkVariant;
        }
        String expectedPrefix = newVariant + "-";
        Optional<String> variant = ndkModel.getNdkVariantNames().stream().filter(it -> it.startsWith(expectedPrefix)).findFirst();
        return variant.orElse(null);
    }

    private static boolean hasBuildFilesChanged(@NotNull Project project) {
        return GradleSyncState.getInstance(project).isSyncNeeded().equals((Object)ThreeState.YES);
    }

    private static void requestFullGradleSync(@NotNull Project project, @NotNull Runnable variantSelectionChangeListeners) {
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_FULL_SYNC, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
    }

    @NotNull
    private static GradleSyncListener getSyncListener(final @NotNull Runnable variantSelectionChangeListeners) {
        return new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                variantSelectionChangeListeners.run();
            }
        };
    }

    private static void requestVariantOnlyGradleSync(@NotNull Project project, @NotNull String moduleName, @NotNull String buildVariantName, @NotNull Runnable variantSelectionChangeListeners) {
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName);
        if (moduleToUpdate == null) {
            return;
        }
        GradleFacet gradleFacet = GradleFacet.getInstance(moduleToUpdate);
        if (gradleFacet == null) {
            return;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(moduleToUpdate);
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(moduleToUpdate);
        GradleModuleModel gradleModel = gradleFacet.getGradleModuleModel();
        if (androidModel != null && gradleModel != null) {
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_CHANGED_BY_USER);
            String variantName = buildVariantName;
            String abiName = null;
            if (ndkModuleModel != null) {
                variantName = ndkModuleModel.getVariantName(buildVariantName);
                abiName = ndkModuleModel.getAbiName(buildVariantName);
            }
            boolean isCompoundSyncEnabled = NewGradleSync.isCompoundSync(project);
            request.variantOnlySyncOptions = new VariantOnlySyncOptions(gradleModel.getRootFolderPath(), gradleModel.getGradlePath(), variantName, abiName, isCompoundSyncEnabled);
            request.generateSourcesOnSuccess = true;
            GradleSyncInvoker.getInstance().requestProjectSync(project, request, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
        }
    }

    private void setupCachedVariant(final @NotNull Project project, final @NotNull String buildVariantName, final @NotNull List<AndroidFacet> affectedAndroidFacets, final @NotNull List<NdkFacet> affectedNdkFacets, final @NotNull Runnable variantSelectionChangeListeners) {
        final Application application = ApplicationManager.getApplication();
        Task.Backgroundable task = new Task.Backgroundable(project, "Setting up Project", false){
            private double PROGRESS_SETUP_MODULES_START;
            private double PROGRESS_SETUP_MODULES_SIZE;
            private double PROGRESS_SETUP_PROJECT_START;
            private double PROGRESS_SETUP_PROJECT_SIZE;
            private double PROGRESS_COMMIT_START;
            private double PROGRESS_COMMIT_SIZE;
            private double PROGRESS_GENERATE_SOURCES_START;
            {
                super(x0, x1, x2);
                this.PROGRESS_SETUP_MODULES_START = 0.0;
                this.PROGRESS_SETUP_MODULES_SIZE = 0.2;
                this.PROGRESS_SETUP_PROJECT_START = this.PROGRESS_SETUP_MODULES_START + this.PROGRESS_SETUP_MODULES_SIZE;
                this.PROGRESS_SETUP_PROJECT_SIZE = 0.2;
                this.PROGRESS_COMMIT_START = this.PROGRESS_SETUP_PROJECT_START + this.PROGRESS_SETUP_PROJECT_SIZE;
                this.PROGRESS_COMMIT_SIZE = 0.4;
                this.PROGRESS_GENERATE_SOURCES_START = this.PROGRESS_COMMIT_START + this.PROGRESS_COMMIT_SIZE;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                BuildVariantUpdater.getLog().info("Starting setup of cached variant");
                List<IdeModifiableModelsProvider> modelsProviders = this.setUpModules(buildVariantName, affectedAndroidFacets, affectedNdkFacets, indicator);
                this.setUpProject(project, indicator);
                this.commitChanges(project, modelsProviders, indicator);
                this.generateSourcesIfNeeded(project, affectedAndroidFacets, indicator);
                if (application.isUnitTestMode()) {
                    variantSelectionChangeListeners.run();
                } else {
                    application.invokeLater(variantSelectionChangeListeners);
                }
                BuildVariantUpdater.getLog().info("Finished setup of cached variant");
            }

            private List<IdeModifiableModelsProvider> setUpModules(@NotNull String variant, @NotNull List<AndroidFacet> affectedAndroidFacets2, @NotNull List<NdkFacet> affectedNdkFacets2, @NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(false);
                indicator.setText("Setting up modules");
                indicator.setFraction(this.PROGRESS_SETUP_MODULES_START);
                ArrayList<IdeModifiableModelsProvider> modelsProviders = new ArrayList<IdeModifiableModelsProvider>();
                for (NdkFacet ndkFacet : affectedNdkFacets2) {
                    NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(ndkFacet);
                    if (ndkModuleModel == null) continue;
                    modelsProviders.add(BuildVariantUpdater.this.setUpModule(ndkFacet.getModule(), ndkModuleModel));
                }
                for (AndroidFacet androidFacet : affectedAndroidFacets2) {
                    AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(androidFacet);
                    if (androidModel == null) continue;
                    modelsProviders.add(BuildVariantUpdater.this.setUpModule(androidFacet.getModule(), androidModel));
                }
                return modelsProviders;
            }

            private void setUpProject(@NotNull Project project2, @NotNull ProgressIndicator indicator) {
                indicator.setText("Setting up project");
                indicator.setFraction(this.PROGRESS_SETUP_PROJECT_START);
                PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
                setupRequest.generateSourcesAfterSync = false;
                setupRequest.cleanProjectAfterSync = false;
                PostSyncProjectSetup.getInstance(project2).setUpProject(setupRequest, indicator, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void commitChanges(@NotNull Project project2, @NotNull List<IdeModifiableModelsProvider> providers, @NotNull ProgressIndicator indicator) {
                BatchUpdatesUtil.startBatchUpdate(project2);
                try {
                    this.doCommitChanges(project2, providers, indicator);
                }
                finally {
                    BatchUpdatesUtil.finishBatchUpdate(project2);
                }
            }

            private void doCommitChanges(@NotNull Project project2, @NotNull List<IdeModifiableModelsProvider> providers, @NotNull ProgressIndicator indicator) {
                indicator.setText("Committing changes");
                indicator.setFraction(this.PROGRESS_COMMIT_START);
                double step = this.PROGRESS_COMMIT_SIZE / (double)(providers.size() + 1);
                double progress = this.PROGRESS_COMMIT_START;
                for (IdeModifiableModelsProvider provider : providers) {
                    GradleProjects.executeProjectChanges(project2, () -> {
                        try {
                            provider.commit();
                        }
                        catch (Throwable t) {
                            provider.dispose();
                            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
                        }
                    });
                    indicator.setFraction(progress += step);
                }
            }

            private void generateSourcesIfNeeded(@NotNull Project project2, @NotNull List<AndroidFacet> affectedAndroidFacets2, @NotNull ProgressIndicator indicator) {
                if (!affectedAndroidFacets2.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
                    indicator.setFraction(this.PROGRESS_GENERATE_SOURCES_START);
                    GradleProjectBuilder.getInstance(project2).generateSources();
                }
            }
        };
        if (application.isUnitTestMode()) {
            task.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
        }
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private IdeModifiableModelsProvider setUpModule(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        IdeModifiableModelsProvider modelsProvider = this.myModifiableModelsProviderFactory.create(module.getProject());
        ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
        try {
            this.myAndroidModuleSetupSteps.setUpModule(context, androidModel);
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return modelsProvider;
    }

    private IdeModifiableModelsProvider setUpModule(@NotNull Module module, @NotNull NdkModuleModel ndkModuleModel) {
        IdeModifiableModelsProvider modelsProvider = this.myModifiableModelsProviderFactory.create(module.getProject());
        ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
        try {
            this.myNdkModuleSetupSteps.setUpModule(context, ndkModuleModel);
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return modelsProvider;
    }

    @Nullable
    private static AndroidModuleModel getAndroidModel(@NotNull AndroidFacet facet) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (androidModel == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModelIfNotJustDummy(@NotNull NdkFacet facet) {
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet);
        if (ndkModuleModel == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet.getModule().getName()));
            return null;
        }
        if (ndkModuleModel.getSelectedVariant().getName().equals("------")) {
            return null;
        }
        return ndkModuleModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModelIfNotJustDummy(@NotNull Module module) {
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
        if (ndkModuleModel == null) {
            return null;
        }
        if (ndkModuleModel.getSelectedVariant().getName().equals("------")) {
            return null;
        }
        return ndkModuleModel;
    }

    private static void logAndShowBuildVariantFailure(@NotNull String reason) {
        String prefix = "Unable to select build variant:\n";
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    private static void logAndShowAbiNameFailure(@NotNull String reason) {
        String prefix = "Unable to select ABI:\n";
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(BuildVariantUpdater.class);
    }

    @NotNull
    private static String getNdkBuildVariantName(@NotNull String buildVariantNameWithoutAbi, @NotNull String abiName) {
        return buildVariantNameWithoutAbi + "-" + abiName;
    }

    @VisibleForTesting
    static class IdeModifiableModelsProviderFactory {
        IdeModifiableModelsProviderFactory() {
        }

        @NotNull
        IdeModifiableModelsProvider create(@NotNull Project project) {
            return new IdeModifiableModelsProviderImpl(project);
        }
    }
}

