/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.gradle.variant.view.ModuleVariantsInfoGraph;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildVariantView {
    private static final Object[] TABLE_COLUMN_NAMES_WITHOUT_ABI = new Object[]{"Module", "Active Build Variant"};
    private static final Object[] TABLE_COLUMN_NAMES_WITH_ABI = new Object[]{"Module", "Active Build Variant", "Active ABI"};
    private static final int MODULE_COLUMN_INDEX = 0;
    private static final int VARIANT_COLUMN_INDEX = 1;
    private static final int ABI_COLUMN_INDEX = 2;
    private static final Color CONFLICT_CELL_BACKGROUND = MessageType.ERROR.getPopupBackground();
    private final Project myProject;
    private BuildVariantUpdater myUpdater;
    private JPanel myToolWindowPanel;
    private JBTable myVariantsTable;
    private JPanel myNotificationPanel;
    private final List<Conflict> myConflicts;
    private boolean previousModelHadAbis;

    @NotNull
    public static BuildVariantView getInstance(@NotNull Project project) {
        return (BuildVariantView)ServiceManager.getService((Project)project, BuildVariantView.class);
    }

    public BuildVariantView(@NotNull Project project) {
        this(project, BuildVariantUpdater.getInstance(project));
    }

    @VisibleForTesting
    public BuildVariantView(@NotNull Project project, @NotNull BuildVariantUpdater updater) {
        this.$$$setupUI$$$();
        this.myConflicts = new ArrayList<Conflict>();
        this.previousModelHadAbis = false;
        this.myProject = project;
        this.myUpdater = updater;
        this.myUpdater.addSelectionChangeListener(this::invokeListeners);
        ((JComponent)this.myVariantsTable.getParent().getParent()).setBorder((Border)JBUI.Borders.empty());
    }

    private void createUIComponents() {
        this.myVariantsTable = new BuildVariantTable();
        new TableSpeedSearch((JTable)this.myVariantsTable);
        this.myNotificationPanel = new NotificationPanel();
        this.myNotificationPanel.setVisible(false);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent((JComponent)this.myToolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content);
        this.updateContents();
    }

    public void updateContents() {
        GradleSyncState gradleSyncState = GradleSyncState.getInstance(this.myProject);
        if (gradleSyncState.isSyncInProgress() && !gradleSyncState.isSyncSkipped()) {
            this.projectImportStarted();
            return;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        TreeMap<Integer, BuildVariantItem[]> buildVariantsPerRow = new TreeMap<Integer, BuildVariantItem[]>();
        TreeMap<Integer, AbiItem[]> abisPerRow = new TreeMap<Integer, AbiItem[]>();
        int rowId = 0;
        for (Module module : this.getGradleModulesWithAndroidProjects()) {
            AbiItem[] abiItems;
            String abiName;
            String variantNameWithoutAbi;
            NdkModuleModel ndkModel;
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            NdkFacet ndkFacet = NdkFacet.getInstance(module);
            assert (androidFacet != null || ndkFacet != null);
            NdkModuleModel ndkModuleModel = ndkModel = ndkFacet == null ? null : BuildVariantView.getNdkModuleModelIfNotJustDummy(ndkFacet);
            if (ndkModel != null) {
                String variantNameWithAbi = ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT;
                variantNameWithoutAbi = ndkModel.getVariantName(variantNameWithAbi);
                abiName = ndkModel.getAbiName(variantNameWithAbi);
            } else {
                assert (androidFacet != null);
                variantNameWithoutAbi = androidFacet.getProperties().SELECTED_BUILD_VARIANT;
                abiName = "";
            }
            BuildVariantItem[] buildVariantItems = BuildVariantView.getBuildVariantItems(module);
            if (buildVariantItems.length > 0) {
                buildVariantsPerRow.put(rowId, buildVariantItems);
            }
            if ((abiItems = BuildVariantView.getAbiItems(module, variantNameWithoutAbi)).length > 0) {
                abisPerRow.put(rowId, abiItems);
            }
            Object[] row = new Object[]{module, variantNameWithoutAbi, abiName};
            rows.add(row);
            ++rowId;
        }
        Runnable setModelTask = () -> this.getVariantsTable().setModel(rows, buildVariantsPerRow, abisPerRow);
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            setModelTask.run();
        } else {
            application.invokeLater(setModelTask);
        }
    }

    public void projectImportStarted() {
        this.getVariantsTable().setLoading(true);
    }

    @NotNull
    private List<Module> getGradleModulesWithAndroidProjects() {
        ArrayList<Module> gradleModules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null && androidFacet.requiresAndroidModel() && ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel() != null) {
                gradleModules.add(module);
                continue;
            }
            NdkFacet ndkFacet = NdkFacet.getInstance(module);
            if (ndkFacet == null || BuildVariantView.getNdkModuleModelIfNotJustDummy(ndkFacet) == null) continue;
            gradleModules.add(module);
        }
        if (!gradleModules.isEmpty()) {
            gradleModules.sort(ModuleTypeComparator.INSTANCE);
            return gradleModules;
        }
        return Collections.emptyList();
    }

    @NotNull
    private BuildVariantTable getVariantsTable() {
        return (BuildVariantTable)this.myVariantsTable;
    }

    @NotNull
    private static BuildVariantItem[] getBuildVariantItems(@NotNull Module module) {
        Collection<String> variantNames = BuildVariantView.getVariantNames(module);
        Object[] items2 = new BuildVariantItem[variantNames.size()];
        int i2 = 0;
        for (String name : variantNames) {
            items2[i2++] = new BuildVariantItem(module.getName(), name);
        }
        Arrays.sort(items2);
        return items2;
    }

    @NotNull
    private static Collection<String> getVariantNames(@NotNull Module module) {
        NdkModuleModel ndkModuleModel;
        HashSet<String> buildVariantNames = new HashSet<String>();
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel != null) {
            buildVariantNames.addAll(androidModel.getVariantNames());
        }
        if ((ndkModuleModel = BuildVariantView.getNdkModuleModelIfNotJustDummy(module)) != null) {
            buildVariantNames.addAll(ndkModuleModel.getNdkVariantNames().stream().map(ndkVariantName -> ndkModuleModel.getVariantName((String)ndkVariantName)).collect(Collectors.toList()));
        }
        return buildVariantNames;
    }

    @NotNull
    private static AbiItem[] getAbiItems(@NotNull Module module, @NotNull String variantNameWithoutAbi) {
        Collection<String> variantNames = BuildVariantView.getAbiNames(module, variantNameWithoutAbi);
        Object[] items2 = new AbiItem[variantNames.size()];
        int i2 = 0;
        for (String name : variantNames) {
            items2[i2++] = new AbiItem(module.getName(), name);
        }
        Arrays.sort(items2);
        return items2;
    }

    @NotNull
    private static Collection<String> getAbiNames(@NotNull Module module, @NotNull String variantNameWithoutAbi) {
        NdkModuleModel ndkModuleModel = BuildVariantView.getNdkModuleModelIfNotJustDummy(module);
        if (ndkModuleModel == null) {
            return Collections.emptyList();
        }
        Collection<String> allNdkVariants = ndkModuleModel.getNdkVariantNames();
        return allNdkVariants.stream().filter(ndkVariant -> ndkVariant.startsWith(variantNameWithoutAbi)).map(ndkVariant -> ndkModuleModel.getAbiName((String)ndkVariant)).collect(Collectors.toList());
    }

    public void updateContents(@NotNull List<Conflict> conflicts) {
        this.myNotificationPanel.setVisible(!conflicts.isEmpty());
        ((NotificationPanel)this.myNotificationPanel).myCurrentConflictIndex = -1;
        this.myConflicts.clear();
        this.myConflicts.addAll(conflicts);
        this.updateContents();
    }

    public void findAndSelect(@NotNull Module module) {
        this.findAndSelect(module, 0);
    }

    public void findAndSelectVariantEditor(@NotNull Module module) {
        this.findAndSelect(module, 1);
    }

    private void findAndSelect(@NotNull Module module, int columnIndex) {
        int rowCount = this.myVariantsTable.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            if (!module.equals(this.myVariantsTable.getValueAt(row, 0))) continue;
            this.myVariantsTable.getSelectionModel().setSelectionInterval(row, row);
            this.myVariantsTable.getColumnModel().getSelectionModel().setSelectionInterval(columnIndex, columnIndex);
            TableUtil.scrollSelectionToVisible((JTable)this.myVariantsTable);
            this.myVariantsTable.requestFocusInWindow();
            break;
        }
    }

    private void invokeListeners() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            this.updateContents();
        } else {
            application.invokeLater(this::updateContents);
        }
    }

    @Nullable
    private static NdkModuleModel getNdkModuleModelIfNotJustDummy(@NotNull NdkFacet ndkFacet) {
        NdkModuleModel ndkModel = NdkModuleModel.get(ndkFacet);
        String variantNameWithAbi = ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT;
        if (variantNameWithAbi.equals("------")) {
            return null;
        }
        return ndkModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModuleModelIfNotJustDummy(@NotNull Module module) {
        NdkFacet ndkFacet = NdkFacet.getInstance(module);
        if (ndkFacet == null) {
            return null;
        }
        return BuildVariantView.getNdkModuleModelIfNotJustDummy(ndkFacet);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myToolWindowPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = this.myVariantsTable;
        jBTable.setCellSelectionEnabled(true);
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel2 = this.myNotificationPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myToolWindowPanel;
    }

    private static class ModuleTableCell
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private static final Border EMPTY_BORDER = JBUI.Borders.empty((int)1);
        @Nullable
        private Conflict myConflict;
        private JPanel myPanel;
        private JLabel myModuleNameLabel = new JLabel();
        private JPanel myButtonsPanel;
        private JButton myInfoButton;
        private JButton myFixButton;
        private Object myValue;

        ModuleTableCell() {
            this.myModuleNameLabel.setOpaque(false);
            this.myInfoButton = ModuleTableCell.createButton(AllIcons.General.BalloonInformation);
            this.myInfoButton.setToolTipText("More info");
            this.myInfoButton.addActionListener(e -> {
                if (this.myValue instanceof Module) {
                    Module module = (Module)this.myValue;
                    ModuleVariantsInfoGraph dialog2 = new ModuleVariantsInfoGraph(module);
                    dialog2.show();
                }
            });
            this.myFixButton = ModuleTableCell.createButton(AllIcons.Actions.QuickfixBulb);
            this.myFixButton.setToolTipText("Fix problem");
            this.myFixButton.addActionListener(e -> {
                if (this.myConflict != null) {
                    Project project = this.myConflict.getSource().getProject();
                    boolean solved = ConflictResolution.solveSelectionConflict(this.myConflict);
                    if (solved) {
                        ConflictSet conflicts = ConflictSet.findConflicts(project);
                        conflicts.showSelectionConflicts();
                    }
                }
                this.stopCellEditing();
            });
            this.myButtonsPanel = new JPanel();
            this.myButtonsPanel.setOpaque(false);
            this.myButtonsPanel.add(this.myInfoButton);
            this.myButtonsPanel.add(this.myFixButton);
            this.myPanel = new JPanel(new BorderLayout()){

                @Override
                public String getToolTipText(MouseEvent e) {
                    String toolTip = ModuleTableCell.getToolTipTextIfUnderX(myModuleNameLabel, e.getX());
                    if (toolTip != null) {
                        return toolTip;
                    }
                    int x = e.getX() - myButtonsPanel.getX();
                    toolTip = ModuleTableCell.getToolTipTextIfUnderX(myInfoButton, x);
                    if (toolTip != null) {
                        return toolTip;
                    }
                    toolTip = ModuleTableCell.getToolTipTextIfUnderX(myFixButton, x);
                    if (toolTip != null) {
                        return toolTip;
                    }
                    return super.getToolTipText(e);
                }
            };
            this.myPanel.add((Component)this.myModuleNameLabel, "Center");
            this.myPanel.add((Component)this.myButtonsPanel, "East");
        }

        @NotNull
        private static JButton createButton(@NotNull Icon icon2) {
            JButton button2 = new JButton(icon2);
            button2.setBorder(null);
            button2.setBorderPainted(false);
            button2.setContentAreaFilled(false);
            return button2;
        }

        @Nullable
        private static String getToolTipTextIfUnderX(@NotNull JComponent c, int x) {
            if (c.isVisible() && x >= c.getX() && x <= c.getX() + c.getWidth()) {
                return c.getToolTipText();
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
            this.setUpComponent(table2, value2, true, true, row);
            return this.myPanel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setUpComponent(table2, value2, isSelected, hasFocus, row);
            return this.myPanel;
        }

        private void setUpComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row) {
            Color background;
            Module module;
            this.myValue = value2;
            String moduleName = null;
            Icon moduleIcon = null;
            boolean isAndriodGradleModule = false;
            if (value2 instanceof Module && !(module = (Module)value2).isDisposed()) {
                moduleName = module.getName();
                moduleIcon = GradleUtil.getModuleIcon(module);
                isAndriodGradleModule = AndroidModuleModel.get(module) != null;
            }
            this.myModuleNameLabel.setText(moduleName == null ? "" : moduleName);
            this.myModuleNameLabel.setIcon(moduleIcon);
            Color color = background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
            if (isAndriodGradleModule) {
                this.myInfoButton.setVisible(true);
                this.myConflict = ((BuildVariantTable)((Object)table2)).findConflict(row);
                this.myModuleNameLabel.setToolTipText(this.myConflict != null ? this.myConflict.toString() : null);
                this.myFixButton.setVisible(this.myConflict != null);
                if (this.myConflict != null) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
            } else {
                this.myInfoButton.setVisible(false);
                this.myFixButton.setVisible(false);
            }
            this.myPanel.setBackground(background);
            Border border = hasFocus ? UIUtil.getTableFocusCellHighlightBorder() : EMPTY_BORDER;
            this.myPanel.setBorder(border);
        }

        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private static class AbisCellRenderer
    extends DefaultTableCellRenderer {
        private static final String abisCellHelpTooltipText = "For NDK modules, determines the ABI that will be used by the editor";

        private AbisCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel component = (JLabel)c;
                Color background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
                component.setBackground(background);
                component.setToolTipText(abisCellHelpTooltipText);
                component.setBorder(BorderFactory.createCompoundBorder(component.getBorder(), (Border)JBUI.Borders.empty((int)3, (int)2, (int)4, (int)2)));
                if (component.getText().isEmpty()) {
                    component.setText("\u2014");
                }
            }
            return c;
        }
    }

    private static class VariantsCellRenderer
    extends DefaultTableCellRenderer {
        private static final String variantsCellHelpTooltipText = "Determines the build variant that will be deployed to device and used by the editor";

        private VariantsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel component = (JLabel)c;
                Color background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
                Conflict conflictFound = ((BuildVariantTable)((Object)table2)).findConflict(row);
                if (conflictFound != null) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
                component.setBackground(background);
                String toolTip = conflictFound != null ? conflictFound.toString() : variantsCellHelpTooltipText;
                component.setToolTipText(toolTip);
                component.setBorder(BorderFactory.createCompoundBorder(component.getBorder(), (Border)JBUI.Borders.empty((int)3, (int)2, (int)4, (int)2)));
            }
            return c;
        }
    }

    private class BuildVariantTable
    extends JBTable {
        private boolean myLoading;
        private final ModuleTableCell myModuleCellEditor;
        private final Map<Integer, TableCellEditor> myVariantCellEditors;
        private final Map<Integer, TableCellEditor> myAbiCellEditors;
        private final ModuleTableCell myModuleCellRenderer;
        private final VariantsCellRenderer myVariantsCellRenderer;
        private final AbisCellRenderer myAbisCellRenderer;

        BuildVariantTable() {
            super((TableModel)new BuildVariantTableModel(Collections.emptyList(), BuildVariantView.this.previousModelHadAbis));
            this.myModuleCellEditor = new ModuleTableCell();
            this.myVariantCellEditors = new TreeMap<Integer, TableCellEditor>();
            this.myAbiCellEditors = new TreeMap<Integer, TableCellEditor>();
            this.myModuleCellRenderer = new ModuleTableCell();
            this.myVariantsCellRenderer = new VariantsCellRenderer();
            this.myAbisCellRenderer = new AbisCellRenderer();
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Component editorComponent;
                    int column = BuildVariantTable.this.getSelectedColumn();
                    int row = BuildVariantTable.this.getSelectedRow();
                    if ((column == 1 || column == 2) && row >= 0 && e.getKeyCode() == 113 && BuildVariantTable.this.editCellAt(row, column) && (editorComponent = BuildVariantTable.this.getEditorComponent()) instanceof ComboBox) {
                        editorComponent.requestFocusInWindow();
                        ((ComboBox)editorComponent).showPopup();
                    }
                }
            });
            this.setExpandableItemsEnabled(false);
        }

        @Nullable
        Conflict findConflict(int row) {
            for (Conflict conflict : BuildVariantView.this.myConflicts) {
                Object module = this.getValueAt(row, 0);
                if (!conflict.getSource().equals(module)) continue;
                return conflict;
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        void setLoading(boolean loading) {
            this.myLoading = loading;
            this.setPaintBusy(this.myLoading);
            this.clearContents();
            String text = this.myLoading ? "Loading..." : "Nothing to Show";
            this.getEmptyText().setText(text);
        }

        private void clearContents() {
            this.setModel(new BuildVariantTableModel(Collections.emptyList(), BuildVariantView.this.previousModelHadAbis));
            this.myVariantCellEditors.clear();
            this.myAbiCellEditors.clear();
        }

        void setModel(@NotNull List<Object[]> rows, @NotNull Map<Integer, BuildVariantItem[]> buildVariantsPerRow, @NotNull Map<Integer, AbiItem[]> abisPerRow) {
            this.setLoading(false);
            BuildVariantView.this.previousModelHadAbis = !abisPerRow.isEmpty();
            if (rows.isEmpty()) {
                this.setModel(new BuildVariantTableModel(rows, BuildVariantView.this.previousModelHadAbis));
                return;
            }
            boolean hasVariants = !buildVariantsPerRow.isEmpty();
            List<Object> content = hasVariants ? rows : Collections.emptyList();
            this.setModel(new BuildVariantTableModel(content, BuildVariantView.this.previousModelHadAbis));
            this.addBuildVariants(buildVariantsPerRow);
            this.addAbiNames(abisPerRow);
        }

        private void addBuildVariants(@NotNull Map<Integer, BuildVariantItem[]> buildVariantsPerRow) {
            for (Map.Entry<Integer, BuildVariantItem[]> entry : buildVariantsPerRow.entrySet()) {
                int row = entry.getKey();
                Object[] items2 = entry.getValue();
                BuildVariantItem selected = null;
                for (BuildVariantItem buildVariantItem : items2) {
                    if (!buildVariantItem.hasBuildVariantName(this.getValueAt(row, 1))) continue;
                    selected = buildVariantItem;
                    break;
                }
                ComboBox editor2 = new ComboBox(items2);
                if (selected != null) {
                    editor2.setSelectedItem(selected);
                }
                editor2.setBorder((Border)JBUI.Borders.empty());
                editor2.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        BuildVariantItem selectedVariant = (BuildVariantItem)e.getItem();
                        BuildVariantView.this.getVariantsTable().setLoading(true);
                        if (!BuildVariantView.this.myUpdater.updateSelectedBuildVariant(BuildVariantView.this.myProject, selectedVariant.myModuleName, selectedVariant.myBuildVariantName)) {
                            BuildVariantView.this.updateContents();
                        }
                    }
                });
                final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor2);
                editor2.addKeyListener((KeyListener)new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 27) {
                            defaultCellEditor.cancelCellEditing();
                        }
                    }
                });
                this.myVariantCellEditors.put(row, defaultCellEditor);
            }
        }

        private void addAbiNames(@NotNull Map<Integer, AbiItem[]> abisPerRow) {
            for (Map.Entry<Integer, AbiItem[]> entry : abisPerRow.entrySet()) {
                int row = entry.getKey();
                Object[] items2 = entry.getValue();
                AbiItem selected = null;
                for (AbiItem abiItem : items2) {
                    if (!abiItem.hasAbiName(this.getValueAt(row, 2))) continue;
                    selected = abiItem;
                    break;
                }
                ComboBox editor2 = new ComboBox(items2);
                if (selected != null) {
                    editor2.setSelectedItem(selected);
                }
                editor2.setBorder((Border)JBUI.Borders.empty());
                editor2.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        AbiItem selectedAbi = (AbiItem)e.getItem();
                        if (!BuildVariantView.this.myUpdater.updateSelectedAbi(BuildVariantView.this.myProject, selectedAbi.myModuleName, selectedAbi.myAbiName)) {
                            BuildVariantView.this.updateContents();
                        }
                    }
                });
                final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor2);
                editor2.addKeyListener((KeyListener)new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 27) {
                            defaultCellEditor.cancelCellEditing();
                        }
                    }
                });
                this.myAbiCellEditors.put(row, defaultCellEditor);
            }
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 0) {
                return this.myModuleCellRenderer;
            }
            if (column == 1) {
                return this.myVariantsCellRenderer;
            }
            return this.myAbisCellRenderer;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 1) {
                return this.myVariantCellEditors.getOrDefault(row, null);
            }
            if (column == 2) {
                return this.myAbiCellEditors.getOrDefault(row, null);
            }
            return this.myModuleCellEditor;
        }
    }

    private static class BuildVariantTableModel
    extends DefaultTableModel {
        BuildVariantTableModel(List<Object[]> rows, boolean hasAbis) {
            super((Object[][])rows.toArray((T[])new Object[rows.size()][hasAbis ? TABLE_COLUMN_NAMES_WITH_ABI.length : TABLE_COLUMN_NAMES_WITHOUT_ABI.length]), hasAbis ? TABLE_COLUMN_NAMES_WITH_ABI : TABLE_COLUMN_NAMES_WITHOUT_ABI);
        }
    }

    private static class AbiItem
    implements Comparable<AbiItem> {
        @NotNull
        final String myModuleName;
        @NotNull
        final String myAbiName;

        AbiItem(@NotNull String moduleName, @NotNull String abiName) {
            this.myModuleName = moduleName;
            this.myAbiName = abiName;
        }

        @Override
        public int compareTo(@Nullable AbiItem o) {
            return o != null ? Collator.getInstance().compare(this.myAbiName, o.myAbiName) : 1;
        }

        boolean hasAbiName(@Nullable Object name) {
            return this.myAbiName.equals(name);
        }

        public String toString() {
            return this.myAbiName;
        }
    }

    private static class BuildVariantItem
    implements Comparable<BuildVariantItem> {
        @NotNull
        final String myModuleName;
        @NotNull
        final String myBuildVariantName;

        BuildVariantItem(@NotNull String moduleName, @NotNull String buildVariantName) {
            this.myModuleName = moduleName;
            this.myBuildVariantName = buildVariantName;
        }

        @Override
        public int compareTo(@Nullable BuildVariantItem o) {
            return o != null ? Collator.getInstance().compare(this.myBuildVariantName, o.myBuildVariantName) : 1;
        }

        boolean hasBuildVariantName(@Nullable Object name) {
            return this.myBuildVariantName.equals(name);
        }

        public String toString() {
            return this.myBuildVariantName;
        }
    }

    private class NotificationPanel
    extends JPanel {
        int myCurrentConflictIndex;

        NotificationPanel() {
            super(new BorderLayout());
            this.myCurrentConflictIndex = -1;
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
            this.setBackground(color == null ? UIUtil.getToolTipBackground() : color);
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)15));
            this.setPreferredSize(new Dimension(-1, JBUI.scale((int)24)));
            JLabel textLabel = new JLabel("Variant selection conflicts found");
            textLabel.setOpaque(false);
            this.add((Component)textLabel, "Center");
            DefaultActionGroup group = new DefaultActionGroup();
            ActionManager actionManager = ActionManager.getInstance();
            AnAction nextConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    NotificationPanel.this.navigateConflicts(true);
                }
            };
            nextConflictAction.copyFrom(actionManager.getAction("NextOccurence"));
            group.add(nextConflictAction);
            AnAction prevConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    NotificationPanel.this.navigateConflicts(false);
                }
            };
            prevConflictAction.copyFrom(actionManager.getAction("PreviousOccurence"));
            group.add(prevConflictAction);
            ActionToolbar toolbar = actionManager.createActionToolbar("AndroidBuildVariantViewNotifications", (ActionGroup)group, true);
            toolbar.setReservePlaceAutoPopupIcon(false);
            toolbar.setMinimumButtonSize((Dimension)JBUI.size((int)23, (int)23));
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBorder(null);
            toolbarComponent.setOpaque(false);
            this.add((Component)toolbarComponent, "East");
        }

        private void navigateConflicts(boolean forward) {
            int conflictCount = BuildVariantView.this.myConflicts.size();
            if (conflictCount == 0) {
                return;
            }
            if (forward) {
                ++this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex >= conflictCount) {
                    this.myCurrentConflictIndex = 0;
                }
            } else {
                --this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex < 0) {
                    this.myCurrentConflictIndex = conflictCount - 1;
                }
            }
            Conflict conflict = (Conflict)BuildVariantView.this.myConflicts.get(this.myCurrentConflictIndex);
            BuildVariantView.this.findAndSelect(conflict.getSource());
        }
    }

    public static interface BuildVariantSelectionChangeListener {
        public void selectionChanged();
    }
}

