/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.instantapp.InstantAppSdks;
import com.android.tools.idea.instantapp.InstantAppUrlFinder;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantApps {
    @NotNull
    public static List<Module> findFeatureModules(@NotNull AndroidFacet facet) {
        return AndroidProjectInfo.getInstance(facet.getModule().getProject()).getAllModulesOfProjectType(5);
    }

    @Nullable
    public static Module findBaseFeature(@NotNull AndroidFacet facet) {
        return InstantApps.findBaseFeature(InstantApps.findFeatureModules(facet));
    }

    @Nullable
    public static Module findBaseFeature(@NotNull Project project) {
        return InstantApps.findBaseFeature(AndroidProjectInfo.getInstance(project).getAllModulesOfProjectType(5));
    }

    @Nullable
    public static String findMonolithicModuleName(@NotNull Project project) {
        List<Module> moduleList = AndroidProjectInfo.getInstance(project).getAllModulesOfProjectType(0);
        return moduleList.isEmpty() ? null : moduleList.get(0).getName();
    }

    @Nullable
    private static Module findBaseFeature(@NotNull List<Module> featureModules) {
        Module baseFeature = null;
        for (Module module : featureModules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null || !androidModel.getAndroidProject().isBaseSplit()) continue;
            baseFeature = module;
            break;
        }
        return baseFeature;
    }

    @NotNull
    public static String getDefaultInstantAppUrl(@NotNull AndroidFacet facet) {
        String defaultUrl = "";
        List<Module> featureModules = InstantApps.findFeatureModules(facet);
        for (Module module : featureModules) {
            String foundUrl = new InstantAppUrlFinder(module).getDefaultUrl();
            if (!StringUtil.isNotEmpty((String)foundUrl)) continue;
            defaultUrl = foundUrl;
            break;
        }
        return defaultUrl;
    }

    public static boolean isInstantAppSdkEnabled() {
        return InstantAppSdks.getInstance().isInstantAppSdkEnabled();
    }

    @NotNull
    public static File getInstantAppSdk() throws FileNotFoundException {
        File sdk = InstantAppSdks.getInstance().getOrInstallInstantAppSdk();
        return sdk;
    }

    public static long getCompatApiMinVersion() {
        return InstantAppSdks.getInstance().getCompatApiMinVersion();
    }

    public static boolean isInstantAppApplicationModule(@NotNull Module module) {
        AndroidModuleModel model2 = AndroidModuleModel.get(module);
        return model2 != null && model2.getAndroidProject().getProjectType() == 4;
    }

    public static boolean isPostO(IDevice device) {
        AndroidVersion version2 = device.getVersion();
        return version2.compareTo(25, "O") >= 0;
    }
}

