/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.javadoc;

import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.util.FileExtensions;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaDocRenderer {
    private static final int MASK_NORMAL = 0;
    private static final int MASK_FLAVOR_SELECTED = 1;
    private static final int MASK_ITEM_HIDDEN = 2;

    @Nullable
    public static String render(@NotNull Module module, @NotNull ResourceType type, @NotNull String name, boolean framework) {
        return AndroidJavaDocRenderer.render(module, null, type, name, framework);
    }

    @Nullable
    public static String render(@NotNull Module module, @Nullable Configuration configuration, @NotNull ResourceType type, @NotNull String name, boolean framework) {
        return AndroidJavaDocRenderer.render(module, configuration, ResourceUrl.create((ResourceType)type, (String)name, (boolean)framework));
    }

    @Nullable
    public static String render(@NotNull Module module, @NotNull ResourceUrl url) {
        return AndroidJavaDocRenderer.render(module, null, url);
    }

    @Nullable
    public static String render(@NotNull Module module, @Nullable Configuration configuration, @NotNull ResourceUrl url) {
        ResourceValueRenderer renderer = ResourceValueRenderer.create(url.type, module, configuration);
        boolean framework = url.isFramework();
        if (renderer == null || framework && renderer.getFrameworkResources() == null || !framework && renderer.getAppResources() == null) {
            return null;
        }
        String valueDoc = renderer.render(url);
        if (url.isTheme()) {
            String attrDoc = AndroidJavaDocRenderer.renderAttributeDoc(module, configuration, (url.isFramework() ? "android:" : "") + url.name);
            if (valueDoc == null) {
                return attrDoc;
            }
            return AndroidJavaDocRenderer.injectExternalDocumentation(attrDoc, valueDoc);
        }
        return valueDoc;
    }

    @NotNull
    private static String renderAttributeDoc(@NotNull Module module, @Nullable Configuration configuration, @NotNull String name) {
        AttributeDefinition def = ResolutionUtils.getAttributeDefinition(module, configuration, name);
        String doc = def == null ? null : def.getDescription(null);
        HtmlBuilder builder = new HtmlBuilder();
        builder.openHtmlBody();
        builder.beginBold();
        builder.add(name);
        builder.endBold();
        int api = ResolutionUtils.getOriginalApiLevel(name, module.getProject());
        if (api > 1) {
            builder.add(" (Added in API level ");
            builder.add(String.valueOf(api));
            builder.add(")");
        }
        builder.addHtml("<br/>");
        if (!StringUtil.isEmpty((String)doc)) {
            builder.addHtml(doc);
            builder.addHtml("<br/>");
        }
        builder.addHtml("<hr/>");
        builder.closeHtmlBody();
        return builder.getHtml();
    }

    @Nullable
    public static String injectExternalDocumentation(@Nullable String rendered, @Nullable String external) {
        if (rendered == null) {
            return external;
        }
        if (external == null) {
            return rendered;
        }
        int styleStart = external.indexOf("<style");
        int styleEnd = external.indexOf("</style>");
        if (styleStart != -1 && styleEnd != -1) {
            String style = external.substring(styleStart, styleEnd + "</style>".length());
            external = external.substring(0, styleStart) + external.substring(styleEnd + "</style>".length());
            int insert = rendered.indexOf("<body>");
            if (insert != -1) {
                int headEnd = rendered.lastIndexOf("</head>", insert);
                if (headEnd != -1) {
                    insert = headEnd;
                    rendered = rendered.substring(0, insert) + style + rendered.substring(insert);
                } else {
                    rendered = rendered.substring(0, insert) + "<head>" + style + "</head>" + rendered.substring(insert);
                }
            }
        }
        external = AndroidJavaDocRenderer.getTagContent(AndroidJavaDocRenderer.getTagContent(external, "body"), "html");
        int bodyEnd = StringUtil.indexOfIgnoreCase((String)rendered, (String)"</body>", (int)0);
        if (bodyEnd == -1) {
            bodyEnd = StringUtil.indexOfIgnoreCase((String)rendered, (String)"</html>", (int)0);
        }
        if (bodyEnd != -1) {
            return rendered.substring(0, bodyEnd) + external + rendered.substring(bodyEnd);
        }
        return rendered + external;
    }

    @NotNull
    private static String getTagContent(@NotNull String text, @NotNull String tag) {
        int start = StringUtil.indexOfIgnoreCase((String)text, (String)("<" + tag), (int)0);
        int end = StringUtil.indexOfIgnoreCase((String)text, (String)("</" + tag + ">"), (int)0);
        if (start != -1 && end != -1 && (start = StringUtil.indexOfIgnoreCase((String)text, (String)">", (int)start)) != -1) {
            return text.substring(start + 1, end);
        }
        return text;
    }

    private static boolean haveFlavors(List<ItemInfo> items2) {
        for (ItemInfo info : items2) {
            if (info.flavor == null) continue;
            return true;
        }
        return false;
    }

    private static void markHidden(List<ItemInfo> items2) {
        HashSet<String> hiddenQualifiers = new HashSet<String>();
        for (ItemInfo info : items2) {
            String folder = info.folder;
            if (hiddenQualifiers.contains(folder)) {
                info.displayMask |= 2;
            }
            hiddenQualifiers.add(folder);
        }
    }

    private static String renderFolderName(String name) {
        String prefix = "values";
        if (name.equals(prefix)) {
            return "Default";
        }
        if (name.startsWith(prefix + '-')) {
            return name.substring(prefix.length() + 1);
        }
        return name;
    }

    @NotNull
    private static ResourceReference urlToReference(ResourceUrl url) {
        return new ResourceReference(ResourceNamespace.fromBoolean((boolean)url.isFramework()), url.type, url.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Dimension getSize(@NotNull VirtualFile file) {
        try {
            ImageInputStream input = ImageIO.createImageInputStream(file.getInputStream());
            if (input != null) {
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        try {
                            reader.setInput(input);
                            Dimension dimension2 = new Dimension(reader.getWidth(0), reader.getHeight(0));
                            reader.dispose();
                            return dimension2;
                        }
                        catch (Throwable throwable) {
                            reader.dispose();
                            throw throwable;
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class ItemInfo
    implements Comparable<ItemInfo> {
        @Nullable
        public final ResourceValue value;
        @NotNull
        public final FolderConfiguration configuration;
        @Nullable
        public final String flavor;
        @NotNull
        public final String folder;
        public final int rank;
        public int displayMask;

        private ItemInfo(@Nullable ResourceValue value2, @NotNull FolderConfiguration configuration, @NotNull String folder, @Nullable String flavor, int rank, int initialMask) {
            this.value = value2;
            this.configuration = configuration;
            this.flavor = flavor;
            this.folder = folder;
            this.displayMask = initialMask;
            this.rank = rank;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemInfo itemInfo = (ItemInfo)o;
            if (this.rank != itemInfo.rank) {
                return false;
            }
            if (!this.configuration.equals((Object)itemInfo.configuration)) {
                return false;
            }
            if (this.flavor != null ? !this.flavor.equals(itemInfo.flavor) : itemInfo.flavor != null) {
                return false;
            }
            if (!this.folder.equals(itemInfo.folder)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(itemInfo.value) : itemInfo.value != null);
        }

        public int hashCode() {
            int result2 = this.value != null ? this.value.hashCode() : 0;
            result2 = 31 * result2 + this.configuration.hashCode();
            result2 = 31 * result2 + (this.flavor != null ? this.flavor.hashCode() : 0);
            result2 = 31 * result2 + this.folder.hashCode();
            result2 = 31 * result2 + this.rank;
            return result2;
        }

        @Override
        public int compareTo(@NotNull ItemInfo other) {
            if (this.rank != other.rank) {
                return this.rank - other.rank;
            }
            DensityQualifier density1 = this.configuration.getDensityQualifier();
            DensityQualifier density2 = other.configuration.getDensityQualifier();
            if (density1 != null && density2 != null) {
                Density density1Value = density1.getValue() == null ? Density.MEDIUM : density1.getValue();
                Density density2Value = density2.getValue() == null ? Density.MEDIUM : density2.getValue();
                int delta = density2Value.compareTo((Enum)density1Value);
                if (delta != 0) {
                    return delta;
                }
                if (density1Value == Density.MEDIUM && density1 != density2) {
                    return density2 == density2.getNullQualifier() ? 1 : 0;
                }
            }
            return this.configuration.compareTo(other.configuration);
        }
    }

    private static class ColorValueRenderer
    extends ResourceValueRenderer {
        private ColorValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            super(module, configuration);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value2) {
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (value2 != null) {
                value2 = resolver.resolveResValue(value2);
            }
            return value2;
        }

        private static float resolveAlpha(@NotNull ResourceItemResolver resolver, @Nullable String alphaValue) {
            float alpha = 1.0f;
            if (alphaValue != null) {
                try {
                    alpha = Float.parseFloat(ResourceHelper.resolveStringValue((RenderResources)resolver, alphaValue));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return alpha;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            ResourceItemResolver resolver = this.createResolver(item);
            resourceValue2 = ColorValueRenderer.resolveValue(resolver, resourceValue2);
            assert (resolver.getLookupChain() != null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>(resolver.getLookupChain());
            if (resourceValue2 != null) {
                this.renderColorToHtml(resolver, builder, resourceValue2, showResolution, 1.0f, 0);
            } else if (item.value != null) {
                ColorValueRenderer.renderError(builder, item.value.getValue());
            }
            if (showResolution) {
                this.displayChain(url, lookupChain, builder, true, false);
            }
        }

        private void renderColorToHtml(@NotNull ResourceItemResolver resolver, @NotNull HtmlBuilder builder, @NotNull ResourceValue resourceValue2, boolean showResolution, float alpha, int depth) {
            if (depth >= 50) {
                ColorValueRenderer.renderError(builder, "Resource indirection too deep; might be cyclical");
                return;
            }
            StateList stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resourceValue2, this.myModule.getProject());
            if (stateList != null) {
                List<StateListState> states = stateList.getStates();
                if (states.isEmpty()) {
                    ColorValueRenderer.renderError(builder, "Empty StateList");
                } else {
                    builder.addHtml("<table>");
                    for (StateListState state : states) {
                        builder.addHtml("<tr>");
                        builder.addHtml("<td>");
                        boolean oldSmall = this.mySmall;
                        this.mySmall = true;
                        float stateAlpha = ColorValueRenderer.resolveAlpha(resolver, state.getAlpha()) * alpha;
                        ResourceValue resolvedStateResource = resolver.findResValue(state.getValue(), false);
                        ArrayList<ResourceValue> lookupChain = null;
                        if (resolvedStateResource != null) {
                            resolvedStateResource = ColorValueRenderer.resolveValue(resolver, resolvedStateResource);
                            assert (resolver.getLookupChain() != null);
                            ArrayList<ResourceValue> arrayList = lookupChain = showResolution ? new ArrayList<ResourceValue>(resolver.getLookupChain()) : null;
                        }
                        if (resolvedStateResource != null) {
                            this.renderColorToHtml(resolver, builder, resolvedStateResource, showResolution, stateAlpha, depth + 1);
                        } else {
                            this.renderColorToHtml(builder, state.getValue(), stateAlpha);
                        }
                        this.mySmall = oldSmall;
                        builder.addHtml("</td>");
                        builder.addHtml("<td>");
                        builder.addHtml(state.getDescription());
                        builder.addHtml("</td>");
                        if (lookupChain != null) {
                            builder.addHtml("<td>");
                            ResourceUrl resUrl = ResourceUrl.parse((String)state.getValue());
                            assert (resUrl != null);
                            this.displayChain(resUrl, lookupChain, builder, true, false);
                            builder.addHtml("</td>");
                        }
                        builder.addHtml("</tr>");
                    }
                    builder.addHtml("</table>");
                }
            } else {
                this.renderColorToHtml(builder, resourceValue2.getValue(), alpha);
            }
        }

        private void renderColorToHtml(@NotNull HtmlBuilder builder, @Nullable String colorString, float alpha) {
            Color color = ResourceHelper.parseColor(colorString);
            if (color == null) {
                ColorValueRenderer.renderError(builder, colorString);
                return;
            }
            int combinedAlpha = (int)((float)color.getAlpha() * alpha);
            color = ColorUtil.toAlpha((Color)color, (int)ResourceHelper.clamp(combinedAlpha, 0, 255));
            this.renderColorToHtml(builder, color);
        }

        public void renderColorToHtml(@NotNull HtmlBuilder builder, @NotNull Color color) {
            Color displayColor = color;
            int width = 200;
            int height = 100;
            if (this.mySmall) {
                int divisor = 3;
                width /= divisor;
                height /= divisor;
            }
            if (color.getAlpha() != 255) {
                float alpha = (float)color.getAlpha() / 255.0f;
                Color backgroundColor = EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)DocumentationComponent.COLOR_KEY);
                if (backgroundColor != null) {
                    color = new Color((int)((float)backgroundColor.getRed() * (1.0f - alpha) + alpha * (float)color.getRed()), (int)((float)backgroundColor.getGreen() * (1.0f - alpha) + alpha * (float)color.getGreen()), (int)((float)backgroundColor.getBlue() * (1.0f - alpha) + alpha * (float)color.getBlue()));
                }
            }
            String colorString = String.format(Locale.US, "rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
            String foregroundColor = ColorUtil.isDark((Color)color) ? "white" : "black";
            String css = "background-color:" + colorString + ";width:" + width + "px;text-align:center;vertical-align:middle;";
            builder.addHtml("<table style=\"" + css + "\" border=\"0\"><tr height=\"" + height + "\">");
            builder.addHtml("<td align=\"center\" valign=\"middle\" height=\"" + height + "\" style=\"color:" + foregroundColor + "\">");
            builder.addHtml(ResourceHelper.colorToString(displayColor));
            builder.addHtml("</td></tr></table>");
        }
    }

    private static class DrawableValueRenderer
    extends ResourceValueRenderer {
        private DrawableValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            super(module, configuration);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value2) {
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (value2 != null) {
                value2 = resolver.resolveResValue(value2);
            }
            return value2;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            FolderConfiguration configuration = item.configuration;
            DensityQualifier densityQualifier = configuration.getDensityQualifier();
            if (!ResourceQualifier.isValid((ResourceQualifier)densityQualifier)) {
                densityQualifier = new DensityQualifier(Density.MEDIUM);
                configuration = FolderConfiguration.copyOf((FolderConfiguration)item.configuration);
                configuration.setDensityQualifier(densityQualifier);
            }
            ResourceItemResolver resolver = this.createResolver(item.value, configuration);
            resourceValue2 = DrawableValueRenderer.resolveValue(resolver, resourceValue2);
            assert (resolver.getLookupChain() != null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>(resolver.getLookupChain());
            if (resourceValue2 != null) {
                this.renderDrawableToHtml(resolver, builder, resourceValue2, showResolution, configuration, 0);
            } else if (item.value != null) {
                DrawableValueRenderer.renderError(builder, item.value.getValue());
            }
            if (showResolution) {
                this.displayChain(url, lookupChain, builder, true, false);
            }
        }

        private void renderDrawableToHtml(@NotNull ResourceItemResolver resolver, @NotNull HtmlBuilder builder, @NotNull ResourceValue resolvedValue, boolean showResolution, @NotNull FolderConfiguration configuration, int depth) {
            if (depth >= 50) {
                DrawableValueRenderer.renderError(builder, "Resource indirection too deep; might be cyclical");
                return;
            }
            StateList stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resolvedValue, this.myModule.getProject());
            if (stateList != null) {
                List<StateListState> states = stateList.getStates();
                if (states.isEmpty()) {
                    DrawableValueRenderer.renderError(builder, "Empty StateList");
                } else {
                    builder.addHtml("<table>");
                    for (StateListState state : states) {
                        builder.addHtml("<tr>");
                        builder.addHtml("<td>");
                        boolean oldSmall = this.mySmall;
                        this.mySmall = true;
                        ResourceValue resolvedStateResource = resolver.findResValue(state.getValue(), false);
                        ArrayList<ResourceValue> lookupChain = null;
                        if (resolvedStateResource != null) {
                            resolvedStateResource = DrawableValueRenderer.resolveValue(resolver, resolvedStateResource);
                            assert (resolver.getLookupChain() != null);
                            ArrayList<ResourceValue> arrayList = lookupChain = showResolution ? new ArrayList<ResourceValue>(resolver.getLookupChain()) : null;
                        }
                        if (resolvedStateResource != null) {
                            this.renderDrawableToHtml(resolver, builder, resolvedStateResource, showResolution, configuration, depth + 1);
                        } else {
                            DrawableValueRenderer.renderError(builder, state.getValue());
                        }
                        this.mySmall = oldSmall;
                        builder.addHtml("</td>");
                        builder.addHtml("<td>");
                        builder.addHtml(state.getDescription());
                        builder.addHtml("</td>");
                        if (lookupChain != null) {
                            builder.addHtml("<td>");
                            ResourceUrl resUrl = ResourceUrl.parse((String)state.getValue());
                            assert (resUrl != null);
                            this.displayChain(resUrl, lookupChain, builder, true, false);
                            builder.addHtml("</td>");
                        }
                        builder.addHtml("</tr>");
                    }
                    builder.addHtml("</table>");
                }
            } else {
                AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
                assert (facet != null);
                FolderConfiguration folderConfiguration = ResolutionUtils.getFolderConfiguration(facet, resolvedValue, configuration);
                DensityQualifier densityQualifier = folderConfiguration.getDensityQualifier();
                if (!ResourceQualifier.isValid((ResourceQualifier)densityQualifier)) {
                    densityQualifier = configuration.getDensityQualifier();
                    assert (ResourceQualifier.isValid((ResourceQualifier)densityQualifier));
                }
                String value2 = resolvedValue.getValue();
                assert (value2 != null);
                this.renderDrawableToHtml(builder, value2, densityQualifier.getValue(), resolvedValue);
            }
        }

        private void renderDrawableToHtml(@NotNull HtmlBuilder builder, @NotNull String result2, @NotNull Density density, @NotNull ResourceValue resolvedValue) {
            if (ResourceHelper.isFileResource(result2)) {
                VirtualFile file = FileExtensions.toVirtualFile(ResourceHelper.toFileResourcePathString(result2));
                if (file == null) {
                    DrawableValueRenderer.renderError(builder, result2);
                } else {
                    this.renderDrawableToHtml(builder, file, density, resolvedValue);
                }
            } else if (result2.startsWith("#")) {
                ColorValueRenderer colorRenderer = (ColorValueRenderer)ResourceValueRenderer.create(ResourceType.COLOR, this.myModule, this.myConfiguration);
                assert (colorRenderer != null);
                colorRenderer.setSmall(this.mySmall);
                colorRenderer.renderColorToHtml(builder, result2, 1.0f);
            } else {
                DrawableValueRenderer.renderError(builder, result2);
            }
        }

        private void renderDrawableToHtml(@NotNull HtmlBuilder builder, @NotNull VirtualFile virtualFile, @NotNull Density density, @NotNull ResourceValue resolvedValue) {
            String path = virtualFile.getPath();
            boolean isWebP = path.endsWith(".webp");
            if (SdkUtils.hasImageExtension((String)path) && !isWebP) {
                File file;
                if (virtualFile.getFileSystem().getProtocol().equals("file")) {
                    file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                } else {
                    try {
                        file = FileUtilRt.createTempFile((String)"render", (String)".png", (boolean)true);
                        try (InputStream input = virtualFile.getInputStream();
                             OutputStream output = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND, StandardOpenOption.WRITE);){
                            FileUtilRt.copy((InputStream)input, (OutputStream)output);
                        }
                    }
                    catch (IOException e) {
                        DrawableValueRenderer.renderError(builder, e.toString());
                        return;
                    }
                }
                URL fileUrl = DrawableValueRenderer.fileToUrl(file);
                if (fileUrl != null) {
                    builder.beginDiv("background-color:gray;padding:10px");
                    builder.addImage(fileUrl, path);
                    builder.endDiv();
                    Dimension size = AndroidJavaDocRenderer.getSize(virtualFile);
                    if (size != null) {
                        builder.addHtml(String.format(Locale.US, "%1$d&#xd7;%2$d px (%3$d&#xd7;%4$d dp @ %5$s)", size.width, size.height, DrawableValueRenderer.px2dp(size.width, density), DrawableValueRenderer.px2dp(size.height, density), density.getResourceValue()));
                    }
                }
            } else if (this.myConfiguration != null) {
                BufferedImage image;
                Dimension size;
                RenderTask renderTask = DrawableRendererEditor.configureRenderTask(this.myModule, this.myConfiguration);
                int width = 100;
                int height = 100;
                if (isWebP && (size = AndroidJavaDocRenderer.getSize(virtualFile)) != null) {
                    width = size.width;
                    height = size.height;
                }
                renderTask.setOverrideRenderSize(width, height);
                try {
                    image = renderTask.renderDrawable(resolvedValue).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    DrawableValueRenderer.renderError(builder, e.toString());
                    return;
                }
                if (image != null) {
                    try {
                        URL fileUrl;
                        File tempFile = FileUtilRt.createTempFile((String)"render", (String)".png", (boolean)true);
                        boolean ok = ImageIO.write((RenderedImage)image, "PNG", tempFile);
                        if (ok && (fileUrl = DrawableValueRenderer.fileToUrl(tempFile)) != null) {
                            builder.beginDiv("background-color:gray;padding:10px");
                            builder.addImage(fileUrl, null);
                            builder.endDiv();
                        }
                    }
                    catch (IOException e) {
                        DrawableValueRenderer.renderError(builder, e.toString());
                    }
                } else {
                    DrawableValueRenderer.renderError(builder, "Couldn't render " + virtualFile);
                }
            } else {
                DrawableValueRenderer.renderError(builder, path);
            }
        }

        @Nullable
        private static URL fileToUrl(@NotNull File file) {
            try {
                return SdkUtils.fileToUrl((File)file);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        private static int px2dp(int px, Density density) {
            return (int)((float)px * (float)Density.MEDIUM.getDpiValue() / (float)density.getDpiValue());
        }
    }

    private static class ArrayRenderer
    extends ResourceValueRenderer {
        private ArrayRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            super(module, configuration);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value2) {
            if (value2 != null) {
                assert (resolver.getLookupChain() != null);
                resolver.setLookupChainList(new ArrayList());
                return resolver.resolveResValue(value2);
            }
            return null;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            ResourceItemResolver resolver = this.createResolver(item);
            ResourceValue value2 = ArrayRenderer.resolveValue(resolver, resourceValue2);
            if (value2 instanceof ArrayResourceValue) {
                ArrayResourceValue arv = (ArrayResourceValue)value2;
                builder.add(Joiner.on((String)", ").skipNulls().join((Iterable)arv));
            } else if (value2 != null) {
                builder.add(value2.toString());
            }
            if (showResolution) {
                List lookupChain = resolver.getLookupChain();
                assert (lookupChain != null);
                if (lookupChain.size() > 1) {
                    this.displayChain(url, lookupChain, builder, true, false);
                }
            }
        }
    }

    private static class TextValueRenderer
    extends ResourceValueRenderer {
        private TextValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            super(module, configuration);
        }

        @Nullable
        private static String resolveStringValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue itemValue, @NotNull ResourceUrl url) {
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (itemValue != null) {
                String value2 = itemValue.getValue();
                if (value2 != null) {
                    ResourceUrl parsed = ResourceUrl.parse((String)value2);
                    if (parsed != null) {
                        ResourceValueImpl v = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                        v.setValue(url.toString());
                        ResourceValue resourceValue2 = resolver.resolveResValue((ResourceValue)v);
                        if (resourceValue2 != null && resourceValue2.getValue() != null) {
                            return resourceValue2.getValue();
                        }
                    }
                    return value2;
                }
                ResourceValueImpl v = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                v.setValue(url.toString());
                ResourceValue resourceValue3 = resolver.resolveResValue((ResourceValue)v);
                if (resourceValue3 != null && resourceValue3.getValue() != null) {
                    return resourceValue3.getValue();
                }
                if (resourceValue3 instanceof StyleResourceValue) {
                    return resourceValue3.getResourceUrl().toString();
                }
                return url.toString();
            }
            return null;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            ResourceItemResolver resolver = this.createResolver(item);
            String value2 = TextValueRenderer.resolveStringValue(resolver, resourceValue2, url);
            List lookupChain = resolver.getLookupChain();
            if (value2 != null) {
                boolean found = false;
                if (url.isTheme()) {
                    if (value2.startsWith("#")) {
                        Color color = ResourceHelper.parseColor(value2);
                        if (color != null) {
                            found = true;
                            ResourceValueRenderer renderer = ResourceValueRenderer.create(ResourceType.COLOR, this.myModule, this.myConfiguration);
                            assert (renderer != null);
                            ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                            resolved.setValue(value2);
                            renderer.renderToHtml(builder, item, url, false, (ResourceValue)resolved);
                            builder.newline();
                        }
                    } else if (value2.endsWith(".png") && ResourceHelper.isFileResource(value2)) {
                        found = true;
                        ResourceValueRenderer renderer = ResourceValueRenderer.create(ResourceType.DRAWABLE, this.myModule, this.myConfiguration);
                        assert (renderer != null);
                        ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                        resolved.setValue(value2);
                        renderer.renderToHtml(builder, item, url, false, (ResourceValue)resolved);
                        builder.newline();
                    }
                    if (!found) {
                        assert (lookupChain != null);
                        int i2 = lookupChain.size();
                        while (--i2 >= 0) {
                            ResourceValueRenderer renderer;
                            ResourceUrl resourceUrl;
                            String value22;
                            ResourceValue rv = (ResourceValue)lookupChain.get(i2);
                            if (rv == null || (value22 = rv.getValue()) == null || (resourceUrl = ResourceUrl.parse((String)value22, (boolean)rv.isFramework())) == null || resourceUrl.isTheme() || (renderer = TextValueRenderer.create(resourceUrl.type, this.myModule, this.myConfiguration)) == null || renderer.getClass() == this.getClass()) continue;
                            found = true;
                            ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(resourceUrl), null);
                            resolved.setValue(value2);
                            renderer.renderToHtml(builder, item, resourceUrl, false, (ResourceValue)resolved);
                            builder.newline();
                            break;
                        }
                    }
                }
                if (!(found || showResolution && lookupChain != null && !lookupChain.isEmpty())) {
                    builder.add(value2);
                }
            } else if (item.value != null && item.value.getValue() != null) {
                builder.add(item.value.getValue());
            }
            if (showResolution) {
                ResourceValue rv;
                assert (lookupChain != null);
                this.displayChain(url, lookupChain, builder, true, true);
                if (!lookupChain.isEmpty() && (rv = (ResourceValue)lookupChain.get(lookupChain.size() - 1)) instanceof StyleResourceValue) {
                    StyleResourceValue srv = (StyleResourceValue)rv;
                    this.displayStyleValues(builder, item, resolver, srv);
                }
            }
        }

        private void displayStyleValues(HtmlBuilder builder, ItemInfo item, ResourceItemResolver resolver, StyleResourceValue styleValue) {
            List lookupChain = resolver.getLookupChain();
            builder.addHtml("<hr>");
            builder.addBold(styleValue.getName()).add(":").newline();
            HashSet<String> masked = new HashSet<String>();
            while (styleValue != null) {
                ImmutableList values = Ordering.usingToString().immutableSortedCopy((Iterable)styleValue.getDefinedItems());
                for (StyleItemResourceValue itemResourceValue : values) {
                    StyleItemResourceValue v;
                    String name = itemResourceValue.getAttrName();
                    if (!masked.add(name)) continue;
                    String value2 = null;
                    ResourceReference attr = itemResourceValue.getAttr();
                    if (attr != null && (v = styleValue.getItem(attr)) != null) {
                        value2 = v.getValue();
                    }
                    builder.addNbsps(4);
                    if (attr != null && attr.getNamespace() == ResourceNamespace.ANDROID) {
                        builder.add("android:");
                    }
                    builder.addBold(name).add(" = ").add(value2 == null ? "null" : value2);
                    if (value2 != null) {
                        ResourceUrl url = ResourceUrl.parse((String)value2, (boolean)styleValue.isFramework());
                        if (url != null) {
                            ResourceValueRenderer renderer;
                            ResourceUrl resolvedUrl = url;
                            int count = 0;
                            while (resolvedUrl != null) {
                                ResourceValue resourceValue2;
                                if (lookupChain != null) {
                                    lookupChain.clear();
                                }
                                if (resolvedUrl.isTheme()) {
                                    ResourceReference ref = new ResourceReference(ResourceNamespace.fromBoolean((boolean)resolvedUrl.isFramework()), ResourceType.ATTR, resolvedUrl.name);
                                    resourceValue2 = resolver.findItemInTheme(ref);
                                } else {
                                    resourceValue2 = resolver.findResValue(resolvedUrl.toString(), resolvedUrl.isFramework());
                                }
                                if (resourceValue2 == null || resourceValue2.getValue() == null) break;
                                url = resolvedUrl;
                                value2 = resourceValue2.getValue();
                                resolvedUrl = ResourceUrl.parse((String)value2, (boolean)resolvedUrl.isFramework());
                                if (count++ != 50) continue;
                                break;
                            }
                            if ((renderer = TextValueRenderer.create(url.type, this.myModule, this.myConfiguration)) != null && renderer.getClass() != this.getClass()) {
                                builder.newline();
                                renderer.setSmall(true);
                                ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), value2);
                                renderer.renderToHtml(builder, item, url, false, (ResourceValue)resolved);
                                continue;
                            }
                            builder.add(" => ");
                            int index = value2.indexOf("exploded-aar");
                            if (index != -1) {
                                value2 = value2.substring(index + "exploded-aar".length() + 1);
                            }
                            builder.add(value2);
                            builder.newline();
                            continue;
                        }
                        builder.newline();
                        continue;
                    }
                    builder.newline();
                }
                if ((styleValue = resolver.getParent(styleValue)) == null) continue;
                builder.newline();
                builder.add("Inherits from: ").add(styleValue.getResourceUrl().toString()).add(":").newline();
            }
        }
    }

    private static abstract class ResourceValueRenderer
    implements ResourceItemResolver.ResourceProvider {
        protected final Module myModule;
        protected final Configuration myConfiguration;
        protected LocalResourceRepository myAppResources;
        protected ResourceResolver myResourceResolver;
        protected boolean mySmall;
        protected ResourceRepository myFrameworkResources;

        protected ResourceValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            this.myModule = module;
            this.myConfiguration = configuration;
        }

        protected ResourceValueRenderer(Module module) {
            this(module, null);
        }

        public void setSmall(boolean small) {
            this.mySmall = small;
        }

        public abstract void renderToHtml(@NotNull HtmlBuilder var1, @NotNull ItemInfo var2, @NotNull ResourceUrl var3, boolean var4, @Nullable ResourceValue var5);

        @Nullable
        public static ResourceValueRenderer create(@NotNull ResourceType type, @NotNull Module module, @Nullable Configuration configuration) {
            switch (type) {
                case ATTR: 
                case STRING: 
                case DIMEN: 
                case INTEGER: 
                case BOOL: 
                case STYLE: {
                    return new TextValueRenderer(module, configuration);
                }
                case ARRAY: {
                    return new ArrayRenderer(module, configuration);
                }
                case MIPMAP: 
                case DRAWABLE: {
                    return new DrawableValueRenderer(module, configuration);
                }
                case COLOR: {
                    return new ColorValueRenderer(module, configuration);
                }
            }
            return null;
        }

        @Nullable
        public String render(@NotNull ResourceUrl url) {
            List<ItemInfo> items2 = this.gatherItems(url);
            if (items2 != null) {
                Collections.sort(items2);
                return this.renderKeyValues(items2, url);
            }
            return null;
        }

        @Nullable
        private List<ItemInfo> gatherItems(@NotNull ResourceUrl url) {
            ResourceType type = url.type;
            String resourceName = url.name;
            boolean framework = url.isFramework();
            if (framework) {
                ArrayList<ItemInfo> results = new ArrayList<ItemInfo>();
                this.addItemsFromFramework(null, 0, 0, type, resourceName, results);
                return results;
            }
            AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
            if (facet == null) {
                return null;
            }
            ArrayList<ItemInfo> results = new ArrayList<ItemInfo>();
            LocalResourceRepository resources = this.getAppResources();
            List<AndroidFacet> dependencies = AndroidUtils.getAllAndroidDependencies(this.myModule, true);
            boolean hasGradleModel = false;
            int rank = 0;
            for (AndroidFacet reachableFacet : Iterables.concat((Iterable)ImmutableList.of((Object)((Object)facet)), dependencies)) {
                AndroidModuleModel androidModel = AndroidModuleModel.get(reachableFacet);
                if (androidModel == null) continue;
                hasGradleModel = true;
                String facetModuleName = reachableFacet.getModule().getName();
                assert (reachableFacet.requiresAndroidModel());
                IdeAndroidProject androidProject = androidModel.getAndroidProject();
                IdeVariant selectedVariant = androidModel.getSelectedVariant();
                HashSet<SourceProvider> selectedProviders = new HashSet<SourceProvider>();
                BuildTypeContainer buildType = androidModel.findBuildType(selectedVariant.getBuildType());
                assert (buildType != null);
                SourceProvider sourceProvider = buildType.getSourceProvider();
                String buildTypeName = selectedVariant.getName();
                ResourceValueRenderer.addItemsFromSourceSet(buildTypeName + " (" + facetModuleName + ")", 1, rank++, sourceProvider, type, resourceName, results, reachableFacet);
                selectedProviders.add(sourceProvider);
                List productFlavors = selectedVariant.getProductFlavors();
                for (int i2 = productFlavors.size() - 1; i2 >= 0; --i2) {
                    String flavorName = (String)productFlavors.get(i2);
                    ProductFlavorContainer productFlavor = androidModel.findProductFlavor(flavorName);
                    assert (productFlavor != null);
                    SourceProvider provider = productFlavor.getSourceProvider();
                    ResourceValueRenderer.addItemsFromSourceSet(flavorName + " (" + facetModuleName + ")", 1, rank++, provider, type, resourceName, results, reachableFacet);
                    selectedProviders.add(provider);
                }
                SourceProvider main = androidProject.getDefaultConfig().getSourceProvider();
                ResourceValueRenderer.addItemsFromSourceSet("main (" + facetModuleName + ")", 1, rank++, main, type, resourceName, results, reachableFacet);
                selectedProviders.add(main);
                Collection buildTypes = androidProject.getBuildTypes();
                for (BuildTypeContainer container : buildTypes) {
                    SourceProvider provider = container.getSourceProvider();
                    if (selectedProviders.contains(provider)) continue;
                    ResourceValueRenderer.addItemsFromSourceSet(container.getBuildType().getName() + " (" + facetModuleName + ")", 0, rank++, provider, type, resourceName, results, reachableFacet);
                    selectedProviders.add(provider);
                }
                Collection flavors = androidProject.getProductFlavors();
                for (ProductFlavorContainer container : flavors) {
                    SourceProvider provider = container.getSourceProvider();
                    if (selectedProviders.contains(provider)) continue;
                    ResourceValueRenderer.addItemsFromSourceSet(container.getProductFlavor().getName() + " (" + facetModuleName + ")", 0, rank++, provider, type, resourceName, results, reachableFacet);
                    selectedProviders.add(provider);
                }
            }
            if (resources != null) {
                if (hasGradleModel) {
                    for (AarResourceRepository dependency : ResourceRepositoryManager.getInstance(facet).getLibraryResources()) {
                        ResourceValueRenderer.addItemsFromRepository(dependency.getDisplayName(), 0, rank++, (ResourceRepository)dependency, false, type, resourceName, results);
                    }
                } else {
                    ResourceValueRenderer.addItemsFromRepository(null, 0, 0, (ResourceRepository)resources, false, type, resourceName, results);
                }
            }
            return results;
        }

        private static void addItemsFromSourceSet(@Nullable String flavor, int mask, int rank, @NotNull SourceProvider sourceProvider, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results, @NotNull AndroidFacet facet) {
            Collection resDirectories = sourceProvider.getResDirectories();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File dir : resDirectories) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(dir);
                if (virtualFile == null) continue;
                ResourceFolderRepository resources = ResourceFolderRegistry.getInstance(facet.getModule().getProject()).get(facet, virtualFile);
                ResourceValueRenderer.addItemsFromRepository(flavor, mask, rank, (ResourceRepository)resources, false, type, name, results);
            }
        }

        private void addItemsFromFramework(@Nullable String flavor, int mask, int rank, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results) {
            ResourceRepository frameworkResources = this.getFrameworkResources();
            if (frameworkResources == null) {
                return;
            }
            ResourceValueRenderer.addItemsFromRepository(flavor, mask, rank, frameworkResources, true, type, name, results);
        }

        private static void addItemsFromRepository(@Nullable String flavor, int mask, int rank, @NotNull ResourceRepository resources, boolean isFramework, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results) {
            ResourceNamespace namespace = isFramework ? ResourceNamespace.ANDROID : ResourceNamespace.TODO();
            List items2 = resources.getResources(namespace, type, name);
            for (ResourceItem item : items2) {
                String folderName = null;
                PathString source = item.getSource();
                if (source != null) {
                    folderName = source.getParentFileName();
                }
                if (folderName == null) {
                    folderName = "?";
                }
                String folder = AndroidJavaDocRenderer.renderFolderName(folderName);
                ResourceValue value2 = item.getResourceValue();
                ItemInfo info = new ItemInfo(value2, item.getConfiguration(), folder, flavor, rank, mask);
                results.add(info);
            }
        }

        @Nullable
        private String renderKeyValues(@NotNull List<ItemInfo> items2, @NotNull ResourceUrl url) {
            if (items2.isEmpty()) {
                return null;
            }
            AndroidJavaDocRenderer.markHidden(items2);
            HtmlBuilder builder = new HtmlBuilder();
            builder.openHtmlBody();
            if (items2.size() == 1) {
                this.renderToHtml(builder, items2.get(0), url, true, items2.get((int)0).value);
            } else {
                builder.beginTable("valign=\"top\"");
                boolean haveFlavors = AndroidJavaDocRenderer.haveFlavors(items2);
                if (haveFlavors) {
                    builder.addTableRow(true, new String[]{"Flavor/Library", "Configuration", "Value"});
                } else {
                    builder.addTableRow(true, new String[]{"Configuration", "Value"});
                }
                String prevFlavor = null;
                boolean showResolution = true;
                for (ItemInfo info : items2) {
                    String style;
                    String folder = info.folder;
                    String flavor = StringUtil.notNullize((String)info.flavor);
                    if (flavor.equals(prevFlavor)) {
                        flavor = "";
                    } else {
                        prevFlavor = flavor;
                    }
                    builder.addHtml("<tr>");
                    if (haveFlavors) {
                        style = (info.displayMask & 1) != 0 ? "b" : null;
                        this.addTableCell(builder, style, flavor, null, null, false);
                    }
                    this.addTableCell(builder, null, folder, null, null, false);
                    style = (info.displayMask & 2) != 0 ? "s" : null;
                    this.addTableCell(builder, style, null, info, url, showResolution);
                    showResolution = false;
                    builder.addHtml("</tr>");
                }
                builder.endTable();
            }
            builder.closeHtmlBody();
            return builder.getHtml();
        }

        private void addTableCell(@NotNull HtmlBuilder builder, @Nullable String attribute, @Nullable String text, @Nullable ItemInfo info, @Nullable ResourceUrl url, boolean showResolution) {
            builder.addHtml("<td valign=\"top\">");
            if (attribute != null) {
                builder.addHtml("<").addHtml(attribute).addHtml(">");
            }
            if (text != null) {
                builder.add(text);
            } else {
                assert (info != null);
                assert (url != null);
                this.renderToHtml(builder, info, url, showResolution, info.value);
            }
            if (attribute != null) {
                builder.addHtml("</").addHtml(attribute).addHtml(">");
            }
            builder.addHtml("</td>");
        }

        @NotNull
        protected ResourceItemResolver createResolver(@NotNull ItemInfo item) {
            return this.createResolver(item.value, item.configuration);
        }

        @NotNull
        protected ResourceItemResolver createResolver(@Nullable ResourceValue value2, @NotNull FolderConfiguration configuration) {
            ResourceItemResolver resolver = new ResourceItemResolver(configuration, (ResourceItemResolver.ResourceProvider)this, null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>();
            lookupChain.add(value2);
            resolver.setLookupChainList(lookupChain);
            return resolver;
        }

        protected void displayChain(@NotNull ResourceUrl url, @NotNull List<ResourceValue> lookupChain, @NotNull HtmlBuilder builder, boolean newlineBefore, boolean newlineAfter) {
            if (!lookupChain.isEmpty()) {
                if (newlineBefore) {
                    builder.newline();
                }
                String text = ResourceItemResolver.getDisplayString((String)url.toString(), lookupChain);
                builder.add(text);
                builder.newline();
                if (newlineAfter) {
                    builder.newline();
                }
            }
        }

        @Nullable
        public ResourceRepository getFrameworkResources() {
            ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myModule);
            return repositoryManager == null ? null : repositoryManager.getFrameworkResources(false);
        }

        @Nullable
        public LocalResourceRepository getAppResources() {
            if (this.myAppResources == null) {
                this.myAppResources = ResourceRepositoryManager.getAppResources(this.myModule);
            }
            return this.myAppResources;
        }

        @Nullable
        public ResourceResolver getResolver(boolean createIfNecessary) {
            if (this.myResourceResolver == null && createIfNecessary) {
                VirtualFile layout2;
                AndroidFacet facet;
                if (this.myConfiguration != null) {
                    this.myResourceResolver = this.myConfiguration.getResourceResolver();
                    if (this.myResourceResolver != null) {
                        return this.myResourceResolver;
                    }
                }
                if ((facet = AndroidFacet.getInstance(this.myModule)) != null && (layout2 = ResourceHelper.pickAnyLayoutFile(facet)) != null) {
                    Configuration configuration = ConfigurationManager.getOrCreateInstance(this.myModule).getConfiguration(layout2);
                    this.myResourceResolver = configuration.getResourceResolver();
                }
            }
            return this.myResourceResolver;
        }

        public static void renderError(@NotNull HtmlBuilder builder, @Nullable String error) {
            builder.beginColor((Color)JBColor.RED);
            builder.addBold(error == null ? "Error" : error);
            builder.endColor();
        }
    }
}

