/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.completion;

import com.android.ide.common.resources.DataBindingResourceType;
import com.android.tools.idea.databinding.BrUtil;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.analytics.api.DataBindingTracker;
import com.android.tools.idea.lang.databinding.DataBindingLangUtil;
import com.android.tools.idea.lang.databinding.completion.DataBindingCompletionContributor;
import com.android.tools.idea.lang.databinding.config.DbFile;
import com.android.tools.idea.lang.databinding.model.ModelClassResolvable;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.model.PsiModelField;
import com.android.tools.idea.lang.databinding.model.PsiModelMethod;
import com.android.tools.idea.lang.databinding.psi.PsiDbExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbFunctionRefExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbRefExpr;
import com.android.tools.idea.res.DataBindingLayoutInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DataBindingEvent;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightFieldBuilder;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u0017H\u0002R$\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/lang/databinding/completion/DataBindingCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "onCompletionHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "onCompletionHandler$annotations", "getOnCompletionHandler", "()Lcom/intellij/codeInsight/completion/InsertHandler;", "autoCompleteUnqualifiedFunctions", "", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "autoCompleteVariablesAndUnqualifiedFunctions", "file", "Lcom/android/tools/idea/lang/databinding/config/DbFile;", "getFile", "element", "Lcom/intellij/psi/PsiElement;", "populateFieldReferenceCompletions", "", "referenceExpression", "onlyValidCompletions", "", "populateMethodReferenceCompletions", "completeBrackets", "intellij.android.lang-databinding"})
public class DataBindingCompletionContributor
extends CompletionContributor {
    @Nullable
    private final InsertHandler<LookupElement> onCompletionHandler = onCompletionHandler.1.INSTANCE;

    @VisibleForTesting
    public static /* synthetic */ void onCompletionHandler$annotations() {
    }

    @Nullable
    public InsertHandler<LookupElement> getOnCompletionHandler() {
        return this.onCompletionHandler;
    }

    private final DbFile getFile(PsiElement element) {
        PsiElement element2 = element;
        while (!(element2 instanceof DbFile)) {
            if (element2.getParent() != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        return (DbFile)element2;
    }

    private final void autoCompleteVariablesAndUnqualifiedFunctions(DbFile file, CompletionResultSet result2) {
        this.autoCompleteUnqualifiedFunctions(result2);
        DataBindingLayoutInfo dataBindingLayoutInfo = DataBindingLangUtil.getDataBindingLayoutInfo((PsiElement)file);
        if (dataBindingLayoutInfo == null) {
            return;
        }
        DataBindingLayoutInfo dataBindingLayoutInfo2 = dataBindingLayoutInfo;
        for (PsiDataBindingResourceItem psiClassArray2 : dataBindingLayoutInfo2.getItems(DataBindingResourceType.VARIABLE).values()) {
            String name = psiClassArray2.component1();
            XmlTag xmlTag = psiClassArray2.component3();
            LookupElementBuilder elementBuilder = LookupElementBuilder.create((Object)xmlTag, (String)DataBindingUtil.convertToJavaFieldName(name)).withInsertHandler(this.getOnCompletionHandler());
            result2.addElement((LookupElement)elementBuilder);
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)file.getProject()).findPackage("java.lang");
        if (psiPackage == null) {
            Intrinsics.throwNpe();
        }
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)file);
        if (androidFacet == null) {
            Intrinsics.throwNpe();
        }
        PsiClass[] psiClassArray = psiPackage.getClasses(ModulesScope.moduleWithLibrariesScope((Module)androidFacet.getModule()));
        PsiClass[] iterator = psiClassArray;
        int n = iterator.length;
        for (int j = 0; j < n; ++j) {
            PsiClass element$iv;
            PsiClass it = element$iv = iterator[j];
            boolean bl = false;
            result2.addElement((LookupElement)JavaLookupElementBuilder.forClass((PsiClass)it, (String)it.getName(), (boolean)true).withInsertHandler(this.getOnCompletionHandler()));
        }
    }

    private final void autoCompleteUnqualifiedFunctions(CompletionResultSet result2) {
        result2.addElement((LookupElement)LookupElementBuilder.create((String)"safeUnbox").withInsertHandler(this.getOnCompletionHandler()));
    }

    private final List<LookupElement> populateFieldReferenceCompletions(PsiElement referenceExpression, boolean onlyValidCompletions) {
        PsiReference[] childReferences;
        List completionSuggestionsList = new ArrayList();
        PsiReference[] psiReferenceArray = childReferences = referenceExpression.getReferences();
        int n = psiReferenceArray.length;
        for (int j = 0; j < n; ++j) {
            PsiReference reference2;
            PsiReference psiReference = reference2 = psiReferenceArray[j];
            if (psiReference == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.lang.databinding.model.ModelClassResolvable");
            }
            ModelClassResolvable ref = (ModelClassResolvable)psiReference;
            PsiModelClass psiModelClass = ref.getResolvedType();
            if (psiModelClass == null || (psiModelClass = psiModelClass.getUnwrapped()) == null) {
                continue;
            }
            PsiModelClass resolvedType = psiModelClass;
            for (PsiModelField psiModelField : resolvedType.getAllFields()) {
                if (onlyValidCompletions && (!psiModelField.isPublic() || ref.isStatic() != psiModelField.isStatic())) continue;
                LookupElementBuilder lookupBuilder = JavaLookupElementBuilder.forField((PsiField)psiModelField.getPsiField(), (String)psiModelField.getPsiField().getName(), (PsiClass)resolvedType.getPsiClass()).withTypeText(PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)psiModelField.getPsiField()), (int)2, (PsiSubstitutor)PsiSubstitutor.EMPTY)).withInsertHandler(this.getOnCompletionHandler());
                completionSuggestionsList.add(lookupBuilder);
            }
        }
        return completionSuggestionsList;
    }

    private final List<LookupElement> populateMethodReferenceCompletions(PsiElement referenceExpression, boolean onlyValidCompletions, boolean completeBrackets) {
        PsiReference[] childReferences;
        List completionSuggestionsList = new ArrayList();
        for (PsiReference reference2 : childReferences = referenceExpression.getReferences()) {
            if (!(reference2 instanceof ModelClassResolvable)) continue;
            ModelClassResolvable ref = (ModelClassResolvable)reference2;
            PsiModelClass psiModelClass = ref.getResolvedType();
            if (psiModelClass == null || (psiModelClass = psiModelClass.getUnwrapped()) == null) {
                continue;
            }
            PsiModelClass resolvedType = psiModelClass;
            for (PsiModelMethod psiModelMethod : resolvedType.getAllMethods()) {
                PsiMethod psiMethod = psiModelMethod.getPsiMethod();
                if (psiMethod.isConstructor() || onlyValidCompletions && (ref.isStatic() != psiModelMethod.isStatic() || !psiModelMethod.isPublic())) continue;
                String name = psiModelMethod.getName();
                if (completeBrackets) {
                    int substringIndex;
                    int n = BrUtil.isGetter(psiMethod) ? 3 : (substringIndex = BrUtil.isBooleanGetter(psiMethod) ? 2 : -1);
                    if (substringIndex == -1) {
                        name = name + "()";
                    } else {
                        String string;
                        String string2 = string = psiModelMethod.getName();
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(substringIndex);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        name = StringsKt.decapitalize((String)string3);
                        if (psiMethod.getReturnType() != null) {
                            PsiType psiType = psiMethod.getReturnType();
                            if (psiType == null) {
                                Intrinsics.throwNpe();
                            }
                            LightFieldBuilder lightField = new LightFieldBuilder(name, psiType, psiMethod.getNavigationElement());
                            lightField.setContainingClass(psiMethod.getContainingClass());
                            LookupElementBuilder lookupBuilder = JavaLookupElementBuilder.forField((PsiField)((PsiField)lightField), (String)lightField.getName(), (PsiClass)resolvedType.getPsiClass()).withTypeText(PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)lightField), (int)2, (PsiSubstitutor)PsiSubstitutor.EMPTY)).withInsertHandler(this.getOnCompletionHandler()).withIcon(PlatformIcons.FIELD_ICON);
                            completionSuggestionsList.add(lookupBuilder);
                            continue;
                        }
                    }
                }
                LookupElementBuilder lookupBuilder = JavaLookupElementBuilder.forMethod((PsiMethod)psiMethod, (String)name, (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiClass)resolvedType.getPsiClass()).withInsertHandler(this.getOnCompletionHandler());
                completionSuggestionsList.add(lookupBuilder);
            }
        }
        return completionSuggestionsList;
    }

    static /* synthetic */ List populateMethodReferenceCompletions$default(DataBindingCompletionContributor dataBindingCompletionContributor, PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: populateMethodReferenceCompletions");
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return dataBindingCompletionContributor.populateMethodReferenceCompletions(psiElement, bl, bl2);
    }

    public DataBindingCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                boolean onlyValidCompletions = parameters2.getInvocationCount() <= 1;
                Project project = parameters2.getEditor().getProject();
                if (project == null) {
                    Intrinsics.throwNpe();
                }
                DataBindingTracker tracker = DataBindingTracker.Companion.getInstance(project);
                PsiElement psiElement = parameters2.getOriginalPosition();
                if (psiElement == null) {
                    psiElement = parameters2.getPosition();
                }
                PsiElement position = psiElement;
                PsiElement parent = position.getParent();
                PsiReference[] psiReferenceArray = parent.getReferences();
                if (psiReferenceArray.length == 0) {
                    PsiElement grandParent = parent.getParent();
                    if (grandParent instanceof PsiDbRefExpr) {
                        PsiDbExpr ownerExpr = ((PsiDbRefExpr)grandParent).getExpr();
                        if (ownerExpr == null) {
                            this.autoCompleteVariablesAndUnqualifiedFunctions(this.getFile(grandParent), result2);
                            return;
                        }
                        result2.addAllElements((Iterable)this.populateFieldReferenceCompletions(ownerExpr, onlyValidCompletions));
                        result2.addAllElements((Iterable)DataBindingCompletionContributor.populateMethodReferenceCompletions$default(this, ownerExpr, onlyValidCompletions, false, 4, null));
                        tracker.trackDataBindingCompletion(DataBindingEvent.EventType.DATA_BINDING_COMPLETION_SUGGESTED, DataBindingEvent.DataBindingContext.DATA_BINDING_CONTEXT_LAMBDA);
                    } else if (grandParent instanceof PsiDbFunctionRefExpr) {
                        result2.addAllElements((Iterable)this.populateMethodReferenceCompletions(((PsiDbFunctionRefExpr)grandParent).getExpr(), onlyValidCompletions, false));
                        tracker.trackDataBindingCompletion(DataBindingEvent.EventType.DATA_BINDING_COMPLETION_SUGGESTED, DataBindingEvent.DataBindingContext.DATA_BINDING_CONTEXT_METHOD_REFERENCE);
                    }
                } else {
                    result2.addAllElements((Iterable)this.populateFieldReferenceCompletions(parent, onlyValidCompletions));
                    result2.addAllElements((Iterable)DataBindingCompletionContributor.populateMethodReferenceCompletions$default(this, parent, onlyValidCompletions, false, 4, null));
                    tracker.trackDataBindingCompletion(DataBindingEvent.EventType.DATA_BINDING_COMPLETION_SUGGESTED, DataBindingEvent.DataBindingContext.UNKNOWN_CONTEXT);
                }
            }
        });
    }
}

