/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.config;

import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.lang.databinding.config.DbLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class DbLanguageInjector
implements LanguageInjector {
    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (!(host instanceof XmlAttributeValue) || !(host.getContainingFile() instanceof XmlFile)) {
            return;
        }
        if (!((XmlFile)host.getContainingFile()).getRootTag().getName().equals("layout")) {
            return;
        }
        String valueText = ((XmlAttributeValue)host).getValue();
        if (!DataBindingUtil.isBindingExpression(valueText)) {
            return;
        }
        String prefix = valueText.startsWith("@={") ? "@={" : "@{";
        String unescapedValue = host.getText();
        int startIndex = unescapedValue.indexOf(prefix.charAt(0)) + prefix.length();
        int endIndex = valueText.endsWith("}") ? unescapedValue.lastIndexOf(125) : (host.getNode().getLastChildNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER ? host.getLastChild().getStartOffsetInParent() : unescapedValue.length());
        if (endIndex == startIndex) {
            return;
        }
        injectionPlacesRegistrar.addPlace((Language)DbLanguage.INSTANCE, TextRange.from((int)startIndex, (int)(endIndex - startIndex)), null, null);
    }
}

