/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.proguard;

import com.android.tools.idea.lang.proguard.grammar.ProguardLexer;
import com.android.tools.idea.lang.proguard.psi.ProguardTypes;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ProguardSyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final TextAttributesKey[] EMPTY_KEY = new TextAttributesKey[0];
    private static final TextAttributesKey COMMENT = TextAttributesKey.createTextAttributesKey((String)"COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    private static final TextAttributesKey[] COMMENTS_KEY = new TextAttributesKey[]{COMMENT};
    private static final TextAttributesKey BAD_CHAR = TextAttributesKey.createTextAttributesKey((String)"BAD_CHAR", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
    private static final TextAttributesKey[] BAD_CHARS_KEY = new TextAttributesKey[]{BAD_CHAR};
    private static final TextAttributesKey OPERATOR = TextAttributesKey.createTextAttributesKey((String)"OPERATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    private static final TextAttributesKey[] OPERATOR_KEY = new TextAttributesKey[]{OPERATOR};
    private static final TextAttributesKey FLAG_NAME = TextAttributesKey.createTextAttributesKey((String)"FLAG_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    private static final TextAttributesKey[] FLAG_NAME_KEY = new TextAttributesKey[]{FLAG_NAME};
    private static final TextAttributesKey FLAG_ARG = TextAttributesKey.createTextAttributesKey((String)"FLAG_ARG", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
    private static final TextAttributesKey[] FLAG_ARG_KEY = new TextAttributesKey[]{FLAG_ARG};
    private static final TextAttributesKey CLASS_SPEC = TextAttributesKey.createTextAttributesKey((String)"CLASS_SPEC", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    private static final TextAttributesKey[] CLASS_SPEC_KEY = new TextAttributesKey[]{CLASS_SPEC};

    @NotNull
    public Lexer getHighlightingLexer() {
        return new ProguardLexer();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType.equals(ProguardTypes.LINE_CMT)) {
            return COMMENTS_KEY;
        }
        if (tokenType.equals(TokenType.BAD_CHARACTER)) {
            return BAD_CHARS_KEY;
        }
        if (tokenType.equals(ProguardTypes.JAVA_DECL)) {
            return CLASS_SPEC_KEY;
        }
        if (tokenType.equals(ProguardTypes.CLOSE_BRACE) || tokenType.equals(ProguardTypes.OPEN_BRACE)) {
            return OPERATOR_KEY;
        }
        if (tokenType.equals(ProguardTypes.FLAG_NAME)) {
            return FLAG_NAME_KEY;
        }
        if (tokenType.equals(ProguardTypes.FLAG_ARG)) {
            return FLAG_ARG_KEY;
        }
        return EMPTY_KEY;
    }
}

