/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.adtui.actions.ZoomInAction;
import com.android.tools.adtui.actions.ZoomLabelAction;
import com.android.tools.adtui.actions.ZoomOutAction;
import com.android.tools.adtui.actions.ZoomToFitAction;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.SkiaParser;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.InspectorView;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.android.tools.idea.layoutinspector.ui.DeviceViewContentPanel;
import com.android.tools.idea.layoutinspector.ui.DeviceViewPanel;
import com.android.tools.idea.layoutinspector.ui.DeviceViewPanel$WhenMappings;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.android.tools.profiler.proto.Common;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0089\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u001e\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0002:;B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020\u000eH\u0016J\b\u0010(\u001a\u00020\u000eH\u0016J\b\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u0002002\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002J\u0010\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u000209H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006<"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel;", "Ljavax/swing/JPanel;", "Lcom/android/tools/adtui/Zoomable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "(Lcom/android/tools/idea/layoutinspector/LayoutInspector;)V", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "contentPanel", "Lcom/android/tools/idea/layoutinspector/ui/DeviceViewContentPanel;", "getContentPanel", "()Lcom/android/tools/idea/layoutinspector/ui/DeviceViewContentPanel;", "drawBorders", "", "myProcessSelectionAction", "Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel$SelectProcessAction;", "scale", "", "getScale", "()D", "setScale", "(D)V", "screenScalingFactor", "", "getScreenScalingFactor", "()F", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "showBordersCheckBox", "com/android/tools/idea/layoutinspector/ui/DeviceViewPanel$showBordersCheckBox$1", "Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel$showBordersCheckBox$1;", "viewMode", "Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel$ViewMode;", "getViewMode", "()Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel$ViewMode;", "setViewMode", "(Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel$ViewMode;)V", "canZoomIn", "canZoomOut", "canZoomToFit", "createToolbar", "Ljavax/swing/JComponent;", "getData", "", "dataId", "", "handleSkiaPictureEvent", "", "event", "Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$LayoutInspectorEvent;", "modelChanged", "old", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "new", "zoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "SelectProcessAction", "ViewMode", "intellij.android.layout-inspector"})
public final class DeviceViewPanel
extends JPanel
implements Zoomable,
DataProvider {
    private final InspectorClient client;
    @NotNull
    private ViewMode viewMode;
    private double scale;
    private final float screenScalingFactor = 1.0f;
    private boolean drawBorders;
    private final showBordersCheckBox.1 showBordersCheckBox;
    private final SelectProcessAction myProcessSelectionAction;
    @NotNull
    private final DeviceViewContentPanel contentPanel;
    private final JBScrollPane scrollPane;
    private final LayoutInspector layoutInspector;

    @NotNull
    public final ViewMode getViewMode() {
        return this.viewMode;
    }

    public final void setViewMode(@NotNull ViewMode viewMode) {
        this.viewMode = viewMode;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public float getScreenScalingFactor() {
        return this.screenScalingFactor;
    }

    @NotNull
    public final DeviceViewContentPanel getContentPanel() {
        return this.contentPanel;
    }

    public boolean zoom(@NotNull ZoomType type) {
        Point point;
        Point $receiver = point = this.scrollPane.getViewport().getViewPosition();
        boolean bl = false;
        $receiver.translate(this.scrollPane.getViewport().getWidth() / 2, this.scrollPane.getViewport().getHeight() / 2);
        Point position = point;
        position.x = (int)((double)position.x / this.getScale());
        position.y = (int)((double)position.y / this.getScale());
        switch (DeviceViewPanel$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.setScale(0.5);
                break;
            }
            case 4: {
                this.setScale(1.0);
                break;
            }
            case 5: {
                DeviceViewPanel deviceViewPanel = this;
                deviceViewPanel.setScale(deviceViewPanel.getScale() + 0.1);
                break;
            }
            case 6: {
                DeviceViewPanel deviceViewPanel = this;
                deviceViewPanel.setScale(deviceViewPanel.getScale() - 0.1);
            }
        }
        this.contentPanel.setScale$intellij_android_layout_inspector(this.getScale());
        this.scrollPane.getViewport().revalidate();
        position.x = (int)((double)position.x * this.getScale());
        position.y = (int)((double)position.y * this.getScale());
        position.translate(-this.scrollPane.getViewport().getWidth() / 2, -this.scrollPane.getViewport().getHeight() / 2);
        this.scrollPane.getViewport().setViewPosition(position);
        return true;
    }

    public boolean canZoomIn() {
        return true;
    }

    public boolean canZoomOut() {
        return true;
    }

    public boolean canZoomToFit() {
        return true;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (ZoomableKt.ZOOMABLE_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    private final JComponent createToolbar() {
        AdtPrimaryPanel panel2 = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)StudioColorsKt.getBorder());
        if (matteBorder == null) {
            Intrinsics.throwNpe();
        }
        panel2.setBorder((Border)matteBorder);
        AdtPrimaryPanel leftPanel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        DefaultActionGroup leftGroup = new DefaultActionGroup();
        leftGroup.add((AnAction)this.myProcessSelectionAction);
        leftGroup.add((AnAction)this.showBordersCheckBox);
        leftPanel.add((Component)ActionManager.getInstance().createActionToolbar("DynamicLayoutInspectorLeft", (ActionGroup)leftGroup, true).getComponent(), (Object)"Center");
        panel2.add((Component)leftPanel, (Object)"Center");
        DefaultActionGroup rightGroup = new DefaultActionGroup();
        rightGroup.add(new AnAction(this, "reset"){
            final /* synthetic */ DeviceViewPanel this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.this$0.setViewMode(this.this$0.getViewMode().getNext());
                this.this$0.getContentPanel().setViewMode$intellij_android_layout_inspector(this.this$0.getViewMode());
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setIcon(this.this$0.getViewMode().getIcon());
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
        rightGroup.add((AnAction)ZoomOutAction.INSTANCE);
        rightGroup.add((AnAction)ZoomLabelAction.INSTANCE);
        rightGroup.add((AnAction)ZoomInAction.INSTANCE);
        rightGroup.add((AnAction)ZoomToFitAction.INSTANCE);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DynamicLayoutInspectorRight", (ActionGroup)rightGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        panel2.add((Component)toolbar.getComponent(), (Object)"East");
        return (JComponent)panel2;
    }

    private final void modelChanged(InspectorModel old, InspectorModel inspectorModel) {
        this.scrollPane.getViewport().revalidate();
        this.repaint();
    }

    private final void handleSkiaPictureEvent(LayoutInspectorProto.LayoutInspectorEvent event) {
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(this, event, application){
            final /* synthetic */ DeviceViewPanel this$0;
            final /* synthetic */ LayoutInspectorProto.LayoutInspectorEvent $event;
            final /* synthetic */ Application $application;

            public final void run() {
                block1: {
                    byte[] bytes = DeviceViewPanel.access$getClient$p(this.this$0).getPayload(this.$event.getPayloadId());
                    Object object = bytes;
                    byte[] byArray = object;
                    if (!(!(byArray.length == 0))) break block1;
                    InspectorView inspectorView = new SkiaParser().getViewTree(bytes);
                    if (inspectorView != null) {
                        Object it = object = (Object)inspectorView;
                        boolean bl = false;
                        DeviceViewPanel.access$getLayoutInspector$p(this.this$0).getLayoutInspectorModel().update((InspectorView)it);
                        this.$application.invokeLater(new Runnable(this){
                            final /* synthetic */ handleSkiaPictureEvent.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                DeviceViewPanel.access$getScrollPane$p(this.this$0.this$0).getViewport().revalidate();
                                this.this$0.this$0.repaint();
                            }
                        });
                    }
                }
            }
            {
                this.this$0 = deviceViewPanel;
                this.$event = layoutInspectorEvent;
                this.$application = application;
            }
        });
    }

    public DeviceViewPanel(@NotNull LayoutInspector layoutInspector) {
        super(new BorderLayout());
        this.layoutInspector = layoutInspector;
        this.client = this.layoutInspector.getClient();
        this.viewMode = ViewMode.XY;
        this.scale = 0.5;
        this.screenScalingFactor = 1.0f;
        this.drawBorders = true;
        this.showBordersCheckBox = new CheckboxAction(this, "Show borders"){
            final /* synthetic */ DeviceViewPanel this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                return DeviceViewPanel.access$getDrawBorders$p(this.this$0);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                DeviceViewPanel.access$setDrawBorders$p(this.this$0, state);
                this.this$0.repaint();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        this.myProcessSelectionAction = new SelectProcessAction(this.client);
        this.contentPanel = new DeviceViewContentPanel(this.layoutInspector, this.getScale(), this.viewMode);
        this.scrollPane = new JBScrollPane((Component)this.contentPanel);
        this.client.register(Common.Event.EventGroupIds.SKIA_PICTURE, (Function1<? super LayoutInspectorProto.LayoutInspectorEvent, Unit>)((Function1)new Function1<LayoutInspectorProto.LayoutInspectorEvent, Unit>(){

            public final void invoke(@NotNull LayoutInspectorProto.LayoutInspectorEvent it) {
                this.handleSkiaPictureEvent(it);
            }
        }));
        this.layoutInspector.getModelChangeListeners().add(new Function2<InspectorModel, InspectorModel, Unit>(this){

            public final void invoke(@NotNull InspectorModel p1, @NotNull InspectorModel p2) {
                ((DeviceViewPanel)this.receiver).modelChanged(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(DeviceViewPanel.class);
            }

            public final String getName() {
                return "modelChanged";
            }

            public final String getSignature() {
                return "modelChanged(Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/android/tools/idea/layoutinspector/model/InspectorModel;)V";
            }
        });
        this.add((Component)this.createToolbar(), "North");
        this.add((Component)this.scrollPane, "Center");
    }

    public static final /* synthetic */ InspectorClient access$getClient$p(DeviceViewPanel $this) {
        return $this.client;
    }

    public static final /* synthetic */ LayoutInspector access$getLayoutInspector$p(DeviceViewPanel $this) {
        return $this.layoutInspector;
    }

    public static final /* synthetic */ JBScrollPane access$getScrollPane$p(DeviceViewPanel $this) {
        return $this.scrollPane;
    }

    public static final /* synthetic */ boolean access$getDrawBorders$p(DeviceViewPanel $this) {
        return $this.drawBorders;
    }

    public static final /* synthetic */ void access$setDrawBorders$p(DeviceViewPanel $this, boolean bl) {
        $this.drawBorders = bl;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel$ViewMode;", "", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;ILjavax/swing/Icon;)V", "getIcon", "()Ljavax/swing/Icon;", "next", "getNext", "()Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel$ViewMode;", "FIXED", "X_ONLY", "XY", "intellij.android.layout-inspector"})
    public static final class ViewMode
    extends Enum<ViewMode> {
        public static final /* enum */ ViewMode FIXED;
        public static final /* enum */ ViewMode X_ONLY;
        public static final /* enum */ ViewMode XY;
        private static final /* synthetic */ ViewMode[] $VALUES;
        @NotNull
        private final Icon icon;

        static {
            ViewMode[] viewModeArray = new ViewMode[3];
            ViewMode[] viewModeArray2 = viewModeArray;
            viewModeArray[0] = FIXED = new ViewMode(StudioIcons.LayoutEditor.Extras.ROOT_INLINE);
            viewModeArray[1] = X_ONLY = new ViewMode(StudioIcons.DeviceConfiguration.SCREEN_WIDTH);
            viewModeArray[2] = XY = new ViewMode(StudioIcons.DeviceConfiguration.SMALLEST_SCREEN_SIZE);
            $VALUES = viewModeArray;
        }

        @NotNull
        public final ViewMode getNext() {
            int n = this.ordinal() + 1;
            ViewMode[] viewModeArray = ViewMode.values();
            ViewMode[] viewModeArray2 = ViewMode.values();
            return viewModeArray[n % viewModeArray2.length];
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        private ViewMode(Icon icon2) {
            this.icon = icon2;
        }

        public static ViewMode[] values() {
            return (ViewMode[])$VALUES.clone();
        }

        public static ViewMode valueOf(String string) {
            return Enum.valueOf(ViewMode.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel$SelectProcessAction;", "Lcom/android/tools/adtui/actions/DropDownAction;", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "(Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;)V", "getClient", "()Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "buildDeviceName", "", "device", "Lcom/android/tools/profiler/proto/Common$Device;", "updateActions", "", "intellij.android.layout-inspector"})
    private static final class SelectProcessAction
    extends DropDownAction {
        @NotNull
        private final InspectorClient client;

        protected boolean updateActions() {
            this.removeAll();
            Map<Common.Stream, List<Common.Process>> processesMap = this.client.loadProcesses();
            if (processesMap.isEmpty()) {
                AnAction noDeviceAction2 = new AnAction("No devices detected"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                    }
                };
                noDeviceAction2.getTemplatePresentation().setEnabled(false);
                this.add(noDeviceAction2);
            } else {
                for (Common.Stream stream : processesMap.keySet()) {
                    DropDownAction deviceAction = new DropDownAction(this.buildDeviceName(stream.getDevice()), null, null);
                    List<Common.Process> processes = processesMap.get(stream);
                    if (processes == null || processes.isEmpty()) {
                        AnAction noProcessAction2 = new AnAction("No debuggable processes detected"){

                            public void actionPerformed(@NotNull AnActionEvent e) {
                            }
                        };
                        noProcessAction2.getTemplatePresentation().setEnabled(false);
                        deviceAction.add(noProcessAction2);
                    } else {
                        for (Common.Process process : processes) {
                            AnAction processAction2 = new AnAction(this, stream, process, process.getName() + " (" + process.getPid() + ')'){
                                final /* synthetic */ SelectProcessAction this$0;
                                final /* synthetic */ Common.Stream $stream;
                                final /* synthetic */ Common.Process $process;

                                public void actionPerformed(@NotNull AnActionEvent event) {
                                    this.this$0.getClient().attach(this.$stream, this.$process);
                                }
                                {
                                    this.this$0 = $outer;
                                    this.$stream = $captured_local_variable$1;
                                    this.$process = $captured_local_variable$2;
                                    super($super_call_param$3);
                                }
                            };
                            deviceAction.add(processAction2);
                        }
                    }
                    this.add((AnAction)deviceAction);
                }
            }
            return true;
        }

        private final String buildDeviceName(Common.Device device) {
            StringBuilder deviceNameBuilder = new StringBuilder();
            String manufacturer = device.getManufacturer();
            String model2 = device.getModel();
            String serial = device.getSerial();
            Object object = StringCompanionObject.INSTANCE;
            String string = "-%s";
            Object[] objectArray = new Object[]{serial};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String suffix = string2;
            if (StringsKt.endsWith$default((String)model2, (String)suffix, (boolean)false, (int)2, null)) {
                object = model2;
                int n = 0;
                int n2 = model2.length() - suffix.length();
                Object object2 = object;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)object2).substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                model2 = string3;
            }
            if (!StringUtil.isEmpty((String)manufacturer)) {
                deviceNameBuilder.append(manufacturer);
                deviceNameBuilder.append(" ");
            }
            deviceNameBuilder.append(model2);
            return deviceNameBuilder.toString();
        }

        @NotNull
        public final InspectorClient getClient() {
            return this.client;
        }

        public SelectProcessAction(@NotNull InspectorClient client) {
            super("Select Process", "Select a process to connect to.", AllIcons.General.Add);
            this.client = client;
        }
    }
}

