/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.InspectorView;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\nH\u0002J\u0018\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001bJP\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\n2\u001e\u00100\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u000701H\u0002J\b\u00102\u001a\u00020+H\u0007J\u0006\u00103\u001a\u00020+J\u0016\u00104\u001a\u00020+2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001bR<\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00070\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u001b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\u001b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\"\u0010\f\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 \u00a8\u00067"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanelModel;", "", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "(Lcom/android/tools/idea/layoutinspector/model/InspectorModel;)V", "hitRects", "", "Lkotlin/Triple;", "Ljava/awt/Shape;", "Ljava/awt/geom/AffineTransform;", "Lcom/android/tools/idea/layoutinspector/model/InspectorView;", "hitRects$annotations", "()V", "getHitRects$intellij_android_layout_inspector", "()Ljava/util/List;", "setHitRects$intellij_android_layout_inspector", "(Ljava/util/List;)V", "maxDepth", "", "maxHeight", "getMaxHeight$intellij_android_layout_inspector", "()I", "maxWidth", "getMaxWidth$intellij_android_layout_inspector", "rootDimension", "Ljava/awt/Dimension;", "xOff", "", "xOff$annotations", "getXOff$intellij_android_layout_inspector", "()D", "setXOff$intellij_android_layout_inspector", "(D)V", "yOff", "yOff$annotations", "getYOff$intellij_android_layout_inspector", "setYOff$intellij_android_layout_inspector", "findMaxDepth", "view", "findTopRect", "x", "y", "rebuildOneRect", "", "transform", "magnitude", "depth", "angle", "newHitRects", "", "refresh", "resetRotation", "rotate", "xRotation", "yRotation", "intellij.android.layout-inspector"})
public final class DeviceViewPanelModel {
    private double xOff;
    private double yOff;
    private Dimension rootDimension;
    private int maxDepth;
    @NotNull
    private List<? extends Triple<? extends Shape, ? extends AffineTransform, InspectorView>> hitRects;
    private final InspectorModel model;

    @VisibleForTesting
    public static /* synthetic */ void xOff$annotations() {
    }

    public final double getXOff$intellij_android_layout_inspector() {
        return this.xOff;
    }

    public final void setXOff$intellij_android_layout_inspector(double d) {
        this.xOff = d;
    }

    @VisibleForTesting
    public static /* synthetic */ void yOff$annotations() {
    }

    public final double getYOff$intellij_android_layout_inspector() {
        return this.yOff;
    }

    public final void setYOff$intellij_android_layout_inspector(double d) {
        this.yOff = d;
    }

    public final int getMaxWidth$intellij_android_layout_inspector() {
        float f = this.maxDepth * 150;
        float f2 = this.rootDimension.width;
        return (int)Math.hypot(f, f2);
    }

    public final int getMaxHeight$intellij_android_layout_inspector() {
        float f = this.maxDepth * 150;
        float f2 = this.rootDimension.height;
        return (int)Math.hypot(f, f2);
    }

    @VisibleForTesting
    public static /* synthetic */ void hitRects$annotations() {
    }

    @NotNull
    public final List<Triple<Shape, AffineTransform, InspectorView>> getHitRects$intellij_android_layout_inspector() {
        return this.hitRects;
    }

    public final void setHitRects$intellij_android_layout_inspector(@NotNull List<? extends Triple<? extends Shape, ? extends AffineTransform, InspectorView>> list) {
        this.hitRects = list;
    }

    @Nullable
    public final InspectorView findTopRect(double x, double y) {
        Triple<? extends Shape, ? extends AffineTransform, InspectorView> triple;
        block1: {
            List<? extends Triple<? extends Shape, ? extends AffineTransform, InspectorView>> list;
            List<? extends Triple<? extends Shape, ? extends AffineTransform, InspectorView>> list2 = list = this.hitRects;
            ListIterator<? extends Triple<? extends Shape, ? extends AffineTransform, InspectorView>> listIterator = list2.listIterator(list2.size());
            while (listIterator.hasPrevious()) {
                Triple<? extends Shape, ? extends AffineTransform, InspectorView> triple2;
                Triple<? extends Shape, ? extends AffineTransform, InspectorView> it = triple2 = listIterator.previous();
                boolean bl = false;
                if (!((Shape)it.getFirst()).contains(x, y)) continue;
                triple = triple2;
                break block1;
            }
            triple = null;
        }
        Triple triple3 = (Triple)triple;
        return triple3 != null ? (InspectorView)triple3.getThird() : null;
    }

    public final void rotate(double xRotation, double yRotation) {
        this.xOff = RangesKt.coerceIn((double)(this.xOff + xRotation), (double)-1.0, (double)1.0);
        this.yOff = RangesKt.coerceIn((double)(this.yOff + yRotation), (double)-1.0, (double)1.0);
        this.refresh();
    }

    @VisibleForTesting
    public final void refresh() {
        double d;
        this.rootDimension = new Dimension(this.model.getRoot().getWidth(), this.model.getRoot().getHeight());
        List newHitRects = new ArrayList();
        AffineTransform transform2 = new AffineTransform();
        transform2.translate((double)(-this.model.getRoot().getWidth()) / 2.0, (double)(-this.model.getRoot().getHeight()) / 2.0);
        double d2 = 1.0;
        double d3 = this.xOff;
        double d4 = this.yOff;
        d3 = Math.hypot(d3, d4);
        double magnitude = Math.min(d2, d3);
        d3 = this.xOff;
        if (Math.abs(d3) < 1.0E-5) {
            d = 1.5707963267948966;
        } else {
            d3 = this.yOff / this.xOff;
            d = Math.atan(d3);
        }
        double angle = d;
        transform2.translate((double)this.rootDimension.width / 2.0, (double)this.rootDimension.height / 2.0);
        transform2.rotate(angle);
        this.maxDepth = this.findMaxDepth(this.model.getRoot());
        this.rebuildOneRect(transform2, magnitude, 0, angle, this.model.getRoot(), newHitRects);
        this.hitRects = CollectionsKt.toList((Iterable)newHitRects);
    }

    /*
     * WARNING - void declaration
     */
    private final int findMaxDepth(InspectorView view) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = view.getChildren().values();
        int n = 1;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            InspectorView inspectorView = (InspectorView)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n2 = this.findMaxDepth((InspectorView)it);
            collection.add(n2);
        }
        collection = (List)destination$iv$iv;
        Integer n3 = (Integer)CollectionsKt.max((Iterable)collection);
        return n + (n3 != null ? n3 : 0);
    }

    private final void rebuildOneRect(AffineTransform transform2, double magnitude, int depth, double angle, InspectorView view, List<Triple<Shape, AffineTransform, InspectorView>> newHitRects) {
        AffineTransform viewTransform = new AffineTransform(transform2);
        int sign = this.xOff < 0.0 ? -1 : 1;
        viewTransform.translate(magnitude * (double)(depth - this.maxDepth / 2) * (double)150 * (double)sign, 0.0);
        double d = 1.0 - magnitude * magnitude;
        AffineTransform affineTransform = viewTransform;
        double d2 = Math.sqrt(d);
        affineTransform.scale(d2, 1.0);
        viewTransform.rotate(-angle);
        viewTransform.translate((double)(-this.rootDimension.width) / 2.0, (double)(-this.rootDimension.height) / 2.0);
        Shape rect = viewTransform.createTransformedShape(new Rectangle(view.getX(), view.getY(), view.getWidth(), view.getHeight()));
        newHitRects.add((Triple<Shape, AffineTransform, InspectorView>)new Triple((Object)rect, (Object)viewTransform, (Object)view));
        Iterable $receiver$iv = view.getChildren().values();
        for (Object element$iv : $receiver$iv) {
            InspectorView it = (InspectorView)element$iv;
            boolean bl = false;
            this.rebuildOneRect(transform2, magnitude, depth + 1, angle, it, newHitRects);
        }
    }

    public final void resetRotation() {
        this.xOff = 0.0;
        this.yOff = 0.0;
    }

    public DeviceViewPanelModel(@NotNull InspectorModel model2) {
        List list;
        this.model = model2;
        this.rootDimension = new Dimension();
        DeviceViewPanelModel deviceViewPanelModel = this;
        deviceViewPanelModel.hitRects = list = CollectionsKt.emptyList();
        this.refresh();
    }
}

