/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.lint.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.checks.ApiDetector;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Locale;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTargetApiQuickFix
implements AndroidLintQuickFix {
    private final boolean myRequiresApi;
    private int myApi;
    private PsiElement myElement;
    private Class<? extends PsiModifierListOwner> myFilter;

    public AddTargetApiQuickFix(int api, boolean requiresApi, PsiElement element, @Nullable Class<? extends PsiModifierListOwner> filter2) {
        this.myApi = api;
        this.myRequiresApi = requiresApi;
        this.myElement = element;
        this.myFilter = filter2;
    }

    private String getAnnotationValue(boolean fullyQualified) {
        return AddTargetVersionCheckQuickFix.getVersionField(this.myApi, fullyQualified);
    }

    @Override
    @NotNull
    public String getName() {
        String key = this.getAnnotationValue(false);
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiFile.class);
        if (file instanceof XmlFile) {
            return "Suppress With tools:targetApi Attribute";
        }
        if (this.myRequiresApi) {
            return AndroidBundle.message("android.lint.fix.add.requires.api", key);
        }
        return AndroidBundle.message("android.lint.fix.add.target.api", key);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class, (boolean)false) != null || PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false) != null;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        PsiModifierListOwner container = this.myFilter != null ? (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, this.myFilter) : (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (container == null) {
            XmlFile file;
            XmlTag element = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            if (element != null && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element, XmlFile.class, (boolean)false)) != null) {
                AndroidResourceUtil.ensureNamespaceImported(file, "http://schemas.android.com/tools", null);
                String codeName = SdkVersionInfo.getBuildCode((int)this.myApi);
                codeName = codeName == null ? Integer.toString(this.myApi) : codeName.toLowerCase(Locale.US);
                element.setAttribute("targetApi", "http://schemas.android.com/tools", codeName);
            }
            return;
        }
        while (container != null && container instanceof PsiAnonymousClass) {
            container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        }
        if (container == null) {
            return;
        }
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList != null) {
            String annotationText;
            String fqcn;
            Project project = startElement.getProject();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            if (this.myRequiresApi) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)startElement);
                fqcn = DependencyManagementUtil.mapAndroidxName(module, ApiDetector.REQUIRES_API_ANNOTATION);
                annotationText = "@" + fqcn + "(api=" + this.getAnnotationValue(true) + ")";
            } else {
                fqcn = "android.annotation.TargetApi";
                annotationText = "@" + fqcn + "(" + this.getAnnotationValue(true) + ")";
            }
            PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText(annotationText, (PsiElement)container);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])new String[]{"android.annotation.TargetApi"});
            if (annotation != null && annotation.isPhysical()) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                AddAnnotationFix fix = new AddAnnotationFix(fqcn, container, attributes, new String[0]);
                fix.invoke(project, null, container.getContainingFile());
            }
        }
    }
}

