/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.checks.ObjectAnimatorDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintAnimatorKeepInspection
extends AndroidLintInspectionBase {
    public AndroidLintAnimatorKeepInspection() {
        super(AndroidBundle.message("android.lint.inspections.animator.keep", new Object[0]), ObjectAnimatorDetector.MISSING_KEEP);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        PsiMethod method = (PsiMethod)LintFix.getData((LintFix)fixData, PsiMethod.class);
        if (method == null || !method.equals(PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class, (boolean)false))) {
            return super.getQuickFixes(startElement, endElement, message2, fixData);
        }
        return new AndroidLintQuickFix[]{new AndroidLintQuickFix(){

            @Override
            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                PsiModifierListOwner container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class);
                if (container == null) {
                    return;
                }
                PsiModifierList modifierList = container.getModifierList();
                if (modifierList != null) {
                    PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])new String[]{ObjectAnimatorDetector.KEEP_ANNOTATION.oldName()});
                    if (annotation == null) {
                        annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])new String[]{ObjectAnimatorDetector.KEEP_ANNOTATION.newName()});
                    }
                    if (annotation == null) {
                        Project project = startElement.getProject();
                        String annotationName = DependencyManagementUtil.mapAndroidxName(ModuleUtilCore.findModuleForPsiElement((PsiElement)startElement), ObjectAnimatorDetector.KEEP_ANNOTATION);
                        new AddAnnotationFix(annotationName, container, new String[0]).invoke(project, null, container.getContainingFile());
                    }
                }
            }

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                return true;
            }

            @Override
            @NotNull
            public String getName() {
                return "Annotate with @Keep";
            }
        }};
    }
}

