/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.webp.ConvertToWebpAction;
import com.android.tools.lint.checks.IconDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintConvertToWebpInspection
extends AndroidLintInspectionBase {
    public AndroidLintConvertToWebpInspection() {
        super(AndroidBundle.message("android.lint.inspections.convert.to.webp", new Object[0]), IconDetector.WEBP_ELIGIBLE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2) {
        return new AndroidLintQuickFix[]{new DefaultLintQuickFix("Convert images to WebP..."){

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                return AndroidFacet.getInstance(startElement) != null;
            }

            @Override
            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                AndroidFacet facet = AndroidFacet.getInstance(startElement);
                if (facet != null) {
                    AndroidModuleInfo info = AndroidModuleInfo.getInstance(facet);
                    int minSdkVersion2 = info.getMinSdkVersion().getApiLevel();
                    List<VirtualFile> folders = ResourceFolderManager.getInstance(facet).getFolders();
                    ConvertToWebpAction action2 = new ConvertToWebpAction();
                    action2.perform(startElement.getProject(), minSdkVersion2, folders.toArray(VirtualFile.EMPTY_ARRAY));
                }
            }
        }};
    }
}

