/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.support.AndroidxName;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.lint.checks.ExifInterfaceDetector;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintExifInterfaceInspection
extends AndroidLintInspectionBase {
    private static final AndroidxName NEW_EXIT_INTERFACE = AndroidxName.of((String)"android.support.media.", (String)"ExifInterface");

    public AndroidLintExifInterfaceInspection() {
        super(AndroidBundle.message("android.lint.inspections.exif.interface", new Object[0]), ExifInterfaceDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2) {
        return new AndroidLintQuickFix[]{new ReplaceExifFix()};
    }

    private static class ReplaceExifFix
    extends DefaultLintQuickFix {
        public ReplaceExifFix() {
            super("Update all references in this file");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            final Module module = AndroidPsiUtils.getModuleSafely(startElement);
            if (module != null) {
                LocalHistoryAction action2 = LocalHistory.getInstance().startAction(this.getName());
                final Project project = module.getProject();
                PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(NEW_EXIT_INTERFACE.newName(), GlobalSearchScope.allScope((Project)project));
                if (cls == null) {
                    cls = JavaPsiFacade.getInstance((Project)project).findClass(NEW_EXIT_INTERFACE.oldName(), GlobalSearchScope.allScope((Project)project));
                }
                if (cls != null) {
                    ReplaceExifFix.replaceReferences(this.getName(), startElement, cls, false);
                    return;
                }
                final String libraryCoordinate = ReplaceExifFix.getExifLibraryCoordinate();
                final boolean useAndroidx = libraryCoordinate != null && libraryCoordinate.startsWith(GoogleMavenArtifactId.ANDROIDX_EXIF_INTERFACE.getMavenGroupId());
                GradleBuildModel buildModel = GradleBuildModel.get(module);
                try {
                    if (buildModel == null) {
                        ReplaceExifFix.replaceReferences(this.getName(), startElement, null, useAndroidx);
                    } else {
                        new WriteCommandAction(module.getProject(), this.getName(), new PsiFile[0]){

                            protected void run(@NotNull Result result2) {
                                if (libraryCoordinate != null) {
                                    ModuleRootModificationUtil.updateModel((Module)module, model2 -> {
                                        GradleBuildModel buildModel = GradleBuildModel.get(module);
                                        if (buildModel != null) {
                                            String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                                            buildModel.dependencies().addArtifact(name, libraryCoordinate);
                                            buildModel.applyChanges();
                                        }
                                    });
                                }
                                this.syncAndReplaceReferences(project, startElement, useAndroidx);
                            }
                        }.execute();
                    }
                }
                finally {
                    action2.finish();
                }
            }
        }

        private void syncAndReplaceReferences(final @NotNull Project project, final @NotNull PsiElement startElement, final boolean useAndroidx) {
            assert (ApplicationManager.getApplication().isDispatchThread());
            ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, false);
            Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

                public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult syncResult) {
                    if (syncResult != null && syncResult.isSuccessful()) {
                        DumbService.getInstance((Project)project).runWhenSmart(() -> ReplaceExifFix.replaceReferences(this.getName(), startElement, null, useAndroidx));
                    }
                }

                public void onFailure(@Nullable Throwable t) {
                    throw new RuntimeException(t);
                }
            });
        }

        private static String getExifLibraryCoordinate() {
            GradleVersion version2;
            RepositoryUrlManager manager = RepositoryUrlManager.get();
            String libraryCoordinate = manager.getArtifactStringCoordinate(GoogleMavenArtifactId.ANDROIDX_EXIF_INTERFACE, true);
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
            libraryCoordinate = manager.getArtifactStringCoordinate(GoogleMavenArtifactId.EXIF_INTERFACE, true);
            if (libraryCoordinate == null) {
                return null;
            }
            GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)libraryCoordinate);
            if (coordinate != null && (version2 = GradleVersion.tryParse((String)coordinate.getRevision())) != null && !version2.isAtLeast(25, 1, 0)) {
                libraryCoordinate = coordinate.getGroupId() + ':' + coordinate.getArtifactId() + ":25.1.0";
            }
            return libraryCoordinate;
        }

        private static void replaceReferences(@NotNull String actionName, final @NotNull PsiElement element, final @Nullable PsiClass cls, final boolean useAndroidx) {
            new WriteCommandAction(element.getProject(), actionName, new PsiFile[0]){

                protected void run(@NotNull Result result2) {
                    Project project = element.getProject();
                    final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    PsiFile file = element.getContainingFile();
                    file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                        public void visitReferenceElement(PsiJavaCodeReferenceElement expression) {
                            if ("ExifInterface".equals(expression.getReferenceName()) && expression.isQualified()) {
                                PsiElement context = expression.getParent();
                                if (expression instanceof PsiReferenceExpression) {
                                    if (cls != null) {
                                        PsiReferenceExpression replacement = factory.createReferenceExpression(cls);
                                        expression.replace((PsiElement)replacement);
                                        return;
                                    }
                                } else {
                                    expression.replace((PsiElement)factory.createReferenceFromText(useAndroidx ? NEW_EXIT_INTERFACE.newName() : NEW_EXIT_INTERFACE.oldName(), context));
                                    return;
                                }
                            }
                            super.visitReferenceElement(expression);
                        }
                    });
                }
            }.execute();
        }
    }
}

