/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.lint.checks.CallSuperDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintMissingSuperCallInspection
extends AndroidLintInspectionBase {
    public AndroidLintMissingSuperCallInspection() {
        super(AndroidBundle.message("android.lint.inspections.missing.super.call", new Object[0]), CallSuperDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        return new AndroidLintQuickFix[]{new DefaultLintQuickFix("Add super call", true){

            @Override
            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class);
                assert (method != null);
                Project project = startElement.getProject();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                PsiStatement superStatement = factory.createStatementFromText(this.buildSuperStatement(method), null);
                PsiCodeBlock body = method.getBody();
                if (body != null) {
                    PsiStatement[] statements = body.getStatements();
                    if (statements.length > 0) {
                        body.addBefore((PsiElement)superStatement, (PsiElement)statements[0]);
                    } else {
                        PsiWhiteSpace whiteSpace = (PsiWhiteSpace)PsiTreeUtil.getChildOfType((PsiElement)method.getBody(), PsiWhiteSpace.class);
                        if (whiteSpace != null && whiteSpace.getText().startsWith("\n\n")) {
                            method.getBody().replace((PsiElement)factory.createCodeBlock());
                            body = method.getBody();
                        }
                        body.add((PsiElement)superStatement);
                    }
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)body);
                    CodeStyleManager.getInstance((Project)project).reformat((PsiElement)body);
                }
            }

            @NotNull
            private String buildSuperStatement(PsiMethod method) {
                PsiClass containingClass;
                StringBuilder methodCallText = new StringBuilder();
                PsiMethod[] superMethods = method.findSuperMethods();
                if (superMethods.length > 0 && (containingClass = superMethods[0].getContainingClass()) != null && containingClass.isInterface()) {
                    methodCallText.append(containingClass.getQualifiedName()).append('.');
                }
                methodCallText.append("super.").append(method.getName()).append('(');
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                for (int i2 = 0; i2 < parameters2.length; ++i2) {
                    methodCallText.append(parameters2[i2].getName());
                    if (i2 + 1 == parameters2.length) continue;
                    methodCallText.append(",");
                }
                methodCallText.append(");");
                return methodCallText.toString();
            }

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                PsiMethod type = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class);
                return startElement.getLanguage() == JavaLanguage.INSTANCE && type != null && !type.isConstructor();
            }
        }};
    }
}

