/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.RenameXmlTagQuickFix;
import com.android.tools.lint.checks.NetworkSecurityConfigDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.RenameAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintNetworkSecurityConfigInspection
extends AndroidLintInspectionBase {
    public AndroidLintNetworkSecurityConfigInspection() {
        super(AndroidBundle.message("android.lint.inspections.network.security.config", new Object[0]), NetworkSecurityConfigDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        if (NetworkSecurityConfigDetector.isAttributeSpellingError((String)message2)) {
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            XmlAttribute currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false);
            assert (parentTag != null);
            assert (currentAttr != null);
            List suggestions = NetworkSecurityConfigDetector.getAttributeSpellingSuggestions((String)currentAttr.getName(), (String)parentTag.getName());
            AndroidLintQuickFix[] attrFixes = new AndroidLintQuickFix[suggestions.size()];
            for (int i2 = 0; i2 < attrFixes.length; ++i2) {
                attrFixes[i2] = new RenameAttributeQuickFix(null, (String)suggestions.get(i2));
            }
            return attrFixes;
        }
        if (NetworkSecurityConfigDetector.isTagSpellingError((String)message2)) {
            XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            assert (currentTag != null);
            XmlTag parentTag = currentTag.getParentTag();
            assert (parentTag != null);
            List suggestions = NetworkSecurityConfigDetector.getTagSpellingSuggestions((String)currentTag.getName(), (String)parentTag.getName());
            AndroidLintQuickFix[] elementQuickFixes = new AndroidLintQuickFix[suggestions.size()];
            for (int i3 = 0; i3 < elementQuickFixes.length; ++i3) {
                elementQuickFixes[i3] = new RenameXmlTagQuickFix((String)suggestions.get(i3));
            }
            return elementQuickFixes;
        }
        return super.getQuickFixes(startElement, endElement, message2, fixData);
    }
}

