/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.refactoring.UnusedResourcesQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintUnusedResourcesInspection
extends AndroidLintInspectionBase {
    public AndroidLintUnusedResourcesInspection() {
        super(AndroidBundle.message("android.lint.inspections.unused.resources", new Object[0]), UnusedResourceDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        String resource = (String)LintFix.getData((LintFix)fixData, String.class);
        if (resource != null) {
            String resourceUrl = "@" + resource.substring(2).replace('.', '/');
            return new AndroidLintQuickFix[]{new UnusedResourcesQuickFix(null), new UnusedResourcesQuickFix(resource), new SetAttributeQuickFix("Add a tools:keep attribute to mark as implicitly used", null, "keep", "http://schemas.android.com/tools", resourceUrl){

                public boolean startInWriteAction() {
                    return false;
                }

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    WriteCommandAction.runWriteCommandAction((Project)startElement.getProject(), (String)this.getName(), null, () -> super.apply(startElement, endElement, context), (PsiFile[])new PsiFile[]{startElement.getContainingFile()});
                }
            }};
        }
        return new AndroidLintQuickFix[]{new UnusedResourcesQuickFix(null)};
    }
}

