/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.lint.checks.WearStandaloneAppDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintWearStandaloneAppFlagInspection
extends AndroidLintInspectionBase {
    public AndroidLintWearStandaloneAppFlagInspection() {
        super(AndroidBundle.message("android.lint.inspections.wear.standalone.app.flag", new Object[0]), WearStandaloneAppDetector.WEAR_STANDALONE_APP_ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        Integer id = (Integer)LintFix.getData((LintFix)fixData, Integer.class);
        if (id != null && id == 2) {
            return new AndroidLintQuickFix[]{new DefaultLintQuickFix("Add meta-data element for 'com.google.android.wearable.standalone'", true){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
                    if (parent == null || !"application".equals(parent.getName())) {
                        return;
                    }
                    XmlTag nodeMetadata = parent.createChildTag("meta-data", null, null, false);
                    XmlTag[] currentMetadataTags = parent.findSubTags("meta-data");
                    XmlTag addAfter = currentMetadataTags.length > 0 ? currentMetadataTags[currentMetadataTags.length - 1] : null;
                    nodeMetadata = addAfter != null ? (XmlTag)parent.addAfter((PsiElement)nodeMetadata, (PsiElement)addAfter) : parent.addSubTag(nodeMetadata, true);
                    if (nodeMetadata != null) {
                        nodeMetadata.setAttribute("name", "http://schemas.android.com/apk/res/android", "com.google.android.wearable.standalone");
                        nodeMetadata.setAttribute("value", "http://schemas.android.com/apk/res/android", "true");
                    }
                }

                @Override
                public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                    XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
                    return parent != null && "application".equals(parent.getName());
                }
            }};
        }
        return super.getQuickFixes(startElement, endElement, message2, fixData);
    }
}

