/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.LintOptions;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.manifmerger.Actions;
import com.android.repository.Revision;
import com.android.repository.api.RemotePackage;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.diagnostics.crash.GenericStudioReport;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.lint.DomPsiParser;
import com.android.tools.idea.lint.LintIdeGradleVisitor;
import com.android.tools.idea.lint.LintIdeIssueRegistry;
import com.android.tools.idea.lint.LintIdeUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.IdeDeprecatedSdkRegistry;
import com.android.tools.idea.templates.IdeGoogleMavenRepository;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.android.tools.lint.helpers.DefaultUastParser;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.State;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

public class LintIdeClient
extends LintClient
implements Disposable {
    protected static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.LintIdeClient");
    protected com.intellij.openapi.project.Project myProject;
    @Nullable
    protected Map<Project, Module> myModuleMap;
    private AndroidSdkHandler sdk = null;
    @Nullable
    private static volatile String ourSystemPath;
    private static final String MERGED_MANIFEST_INFO = "lint-merged-manifest-info";

    public LintIdeClient(com.intellij.openapi.project.Project project) {
        super("studio");
        this.myProject = project;
    }

    public static LintIdeClient forBatch(@NotNull com.intellij.openapi.project.Project project, @NotNull Map<Issue, Map<File, List<ProblemData>>> problemMap, @NotNull AnalysisScope scope, @NotNull Set<Issue> issues) {
        return new BatchLintClient(project, problemMap, scope, issues);
    }

    @Nullable
    public static ApiLookup getApiLookup(@NotNull com.intellij.openapi.project.Project project) {
        return ApiLookup.get((LintClient)new LintIdeClient(project));
    }

    public void runReadAction(Runnable runnable) {
        ApplicationManager.getApplication().runReadAction(runnable);
    }

    public <T> T runReadAction(Computable<T> computable) {
        return (T)ApplicationManager.getApplication().runReadAction(computable);
    }

    public static LintIdeClient forEditor(@NotNull State state) {
        return new EditorLintClient(state);
    }

    public com.intellij.openapi.project.Project getIdeProject() {
        return this.myProject;
    }

    @Nullable
    protected Module findModuleForLintProject(@NotNull com.intellij.openapi.project.Project project, @NotNull Project lintProject) {
        Module module;
        if (this.myModuleMap != null && (module = this.myModuleMap.get(lintProject)) != null) {
            return module;
        }
        File dir = lintProject.getDir();
        VirtualFile vDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
        return vDir != null ? ModuleUtilCore.findModuleForFile((VirtualFile)vDir, (com.intellij.openapi.project.Project)project) : null;
    }

    void setModuleMap(@Nullable Map<Project, Module> moduleMap) {
        this.myModuleMap = moduleMap;
    }

    public Configuration getConfiguration(Project project, @Nullable LintDriver driver) {
        AndroidProject model2;
        if (project.isGradleProject() && project.isAndroidProject() && !project.isLibrary() && (model2 = project.getGradleProjectModel()) != null) {
            try {
                LintOptions lintOptions = model2.getLintOptions();
                final Map overrides = lintOptions.getSeverityOverrides();
                if (overrides != null && !overrides.isEmpty()) {
                    return new DefaultConfiguration(this, project, null){

                        public Severity getSeverity(Issue issue2) {
                            Integer severity = (Integer)overrides.get(issue2.getId());
                            if (severity != null) {
                                switch (severity) {
                                    case 1: {
                                        return Severity.FATAL;
                                    }
                                    case 2: {
                                        return Severity.ERROR;
                                    }
                                    case 3: {
                                        return Severity.WARNING;
                                    }
                                    case 4: {
                                        return Severity.INFORMATIONAL;
                                    }
                                    case 6: {
                                        return issue2.getDefaultSeverity();
                                    }
                                }
                                return Severity.IGNORE;
                            }
                            Set<Issue> issues = LintIdeClient.this.getIssues();
                            boolean known = issues.contains(issue2);
                            if (!known) {
                                if (issue2 == IssueRegistry.BASELINE || issue2 == IssueRegistry.CANCELLED) {
                                    return Severity.IGNORE;
                                }
                                LintIdeIssueRegistry builtin = new LintIdeIssueRegistry();
                                if (builtin.isIssueId(issue2.getId())) {
                                    return Severity.IGNORE;
                                }
                            }
                            return super.getSeverity(issue2);
                        }
                    };
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return new DefaultConfiguration(this, project, null){

            public boolean isEnabled(Issue issue2) {
                Set<Issue> issues = LintIdeClient.this.getIssues();
                boolean known = issues.contains(issue2);
                if (!known) {
                    if (issue2 == IssueRegistry.BASELINE || issue2 == IssueRegistry.CANCELLED) {
                        return true;
                    }
                    LintIdeIssueRegistry builtin = new LintIdeIssueRegistry();
                    return !builtin.isIssueId(issue2.getId());
                }
                return super.isEnabled(issue2);
            }
        };
    }

    public void report(Context context, Issue issue2, Severity severity, Location location, String message2, TextFormat format, @Nullable LintFix extraData) {
        assert (false) : message2;
    }

    protected Set<Issue> getIssues() {
        return Collections.emptySet();
    }

    @Nullable
    protected Module getModule() {
        return null;
    }

    protected void reportSecondary(Context context, Issue issue2, Severity severity, Location location, String message2, TextFormat format, @Nullable LintFix extraData) {
        Location secondary = location.getSecondary();
        if (secondary != null && secondary.getVisible()) {
            String secondaryMessage = secondary.getMessage();
            if (secondaryMessage != null) {
                message2 = secondary.isSelfExplanatory() ? secondaryMessage : message2 + " (" + secondaryMessage + ")";
            }
            this.report(context, issue2, severity, secondary, message2, format, extraData);
        }
    }

    public void log(Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
        if (severity == Severity.ERROR || severity == Severity.FATAL) {
            if (format != null) {
                LOG.error(String.format(format, args), exception);
            } else if (exception != null) {
                LOG.error(exception);
            }
        } else if (severity == Severity.WARNING) {
            if (format != null) {
                LOG.warn(String.format(format, args), exception);
            } else if (exception != null) {
                LOG.warn(exception);
            }
        } else if (format != null) {
            LOG.info(String.format(format, args), exception);
        } else if (exception != null) {
            LOG.info(exception);
        }
    }

    @NotNull
    public XmlParser getXmlParser() {
        return new DomPsiParser(this);
    }

    @NotNull
    public UastParser getUastParser(@Nullable Project project) {
        return new DefaultUastParser(project, this.myProject){

            protected DefaultJavaEvaluator createEvaluator(@Nullable Project project, com.intellij.openapi.project.Project p) {
                return new DefaultJavaEvaluator(p, project){

                    @Nullable
                    public PsiPackage getPackage(PsiElement node) {
                        PsiDirectory dir;
                        PsiFile containingFile = node.getContainingFile();
                        if (containingFile != null && (dir = containingFile.getParent()) != null) {
                            return JavaDirectoryService.getInstance().getPackage(dir);
                        }
                        return null;
                    }
                };
            }
        };
    }

    @NotNull
    public GradleVisitor getGradleVisitor() {
        return new LintIdeGradleVisitor();
    }

    @Nullable
    public GradleVersion getHighestKnownVersion(GradleCoordinate coordinate, @Nullable Predicate<GradleVersion> filter2) {
        GradleCoordinate found;
        AndroidSdkHandler sdkHandler = this.getSdk();
        if (sdkHandler == null) {
            return null;
        }
        StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler, filter2, (com.android.repository.api.ProgressIndicator)logger);
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getVersion();
        }
        return null;
    }

    public List<File> getJavaClassFolders(Project project) {
        return Collections.emptyList();
    }

    public List<File> getJavaLibraries(Project project, boolean includeProvided) {
        return Collections.emptyList();
    }

    public List<File> getTestLibraries(Project project) {
        return Collections.emptyList();
    }

    public String readFile(File file) {
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile == null) {
            LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
            return "";
        }
        return (String)this.runReadAction(() -> {
            PsiFile psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)this.myProject).findFile(vFile);
            if (psiFile == null) {
                LOG.info("Cannot find file " + file.getPath() + " in the PSI");
                return null;
            }
            return psiFile.getText();
        });
    }

    @NotNull
    public byte[] readBytes(@NotNull PathString resourcePath) throws IOException {
        return FileResourceReader.readBytes(resourcePath);
    }

    public void dispose() {
        this.myProject = null;
        this.myModuleMap = null;
    }

    @Nullable
    public File getSdkHome() {
        File home;
        String path;
        Sdk moduleSdk;
        Module module = this.getModule();
        if (module != null && (moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && moduleSdk.getSdkType() instanceof AndroidSdkType && (path = moduleSdk.getHomePath()) != null && (home = new File(path)).exists()) {
            return home;
        }
        File sdkHome = super.getSdkHome();
        if (sdkHome != null) {
            return sdkHome;
        }
        for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
            File home2;
            String path2;
            Sdk moduleSdk2 = ModuleRootManager.getInstance((Module)m).getSdk();
            if (moduleSdk2 == null || !(moduleSdk2.getSdkType() instanceof AndroidSdkType) || (path2 = moduleSdk2.getHomePath()) == null || !(home2 = new File(path2)).exists()) continue;
            return home2;
        }
        return IdeSdks.getInstance().getAndroidSdkPath();
    }

    @Nullable
    public AndroidSdkHandler getSdk() {
        if (this.sdk == null) {
            Module module = this.getModule();
            AndroidSdkHandler localSdk = LintIdeClient.getLocalSdk(module);
            if (localSdk != null) {
                this.sdk = localSdk;
            } else {
                for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
                    localSdk = LintIdeClient.getLocalSdk(m);
                    if (localSdk == null) continue;
                    this.sdk = localSdk;
                    break;
                }
                if (localSdk == null) {
                    this.sdk = super.getSdk();
                }
            }
        }
        return this.sdk;
    }

    @Nullable
    private static AndroidSdkHandler getLocalSdk(@Nullable Module module) {
        AndroidSdkData sdkData;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (sdkData = AndroidSdkData.getSdkData(facet)) != null) {
            return sdkData.getSdkHandler();
        }
        return null;
    }

    @Nullable
    public Revision getBuildToolsRevision(Project project) {
        GradleVersion version2;
        AndroidModuleModel model2;
        Module module;
        if (project.isGradleProject() && (module = this.getModule()) != null && (model2 = AndroidModuleModel.get(module)) != null && (version2 = model2.getModelVersion()) != null && version2.isAtLeast(2, 1, 0)) {
            String buildToolsVersion2 = model2.getAndroidProject().getBuildToolsVersion();
            AndroidSdkHandler sdk = this.getSdk();
            if (sdk != null) {
                try {
                    Revision revision = Revision.parseRevision((String)buildToolsVersion2);
                    BuildToolInfo buildToolInfo = sdk.getBuildToolInfo(revision, this.getRepositoryLogger());
                    if (buildToolInfo != null) {
                        return buildToolInfo.getRevision();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return super.getBuildToolsRevision(project);
    }

    @Nullable
    public String getClientDisplayRevision() {
        return ApplicationInfoEx.getInstanceEx().getFullVersion();
    }

    @Nullable
    public String getClientRevision() {
        return ApplicationInfoEx.getInstanceEx().getStrictVersion();
    }

    public boolean isGradleProject(@NotNull Project project) {
        Module module = this.getModule();
        if (module != null) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            return facet != null && facet.requiresAndroidModel();
        }
        return AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel();
    }

    @Nullable
    public File getCacheDir(@Nullable String name, boolean create2) {
        if ("maven.google".equals(name)) {
            return IdeGoogleMavenRepository.INSTANCE.getCacheDir();
        }
        if ("sdk-registry.xml".equals(name)) {
            return IdeDeprecatedSdkRegistry.INSTANCE.getCacheDir();
        }
        String path = ourSystemPath != null ? ourSystemPath : (ourSystemPath = PathUtil.getCanonicalPath((String)PathManager.getSystemPath()));
        String relative = "lint";
        if (name != null) {
            relative = relative + File.separator + name;
        }
        File lint = new File(path, relative);
        if (create2 && !lint.exists()) {
            lint.mkdirs();
        }
        return lint;
    }

    public boolean isProjectDirectory(File dir) {
        return new File(dir, ".idea").exists();
    }

    @Nullable
    public org.w3c.dom.Document getMergedManifest(Project project) {
        MergedManifestSnapshot mergedManifest;
        org.w3c.dom.Document document;
        AndroidFacet facet;
        Module module = this.findModuleForLintProject(this.myProject, project);
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (document = (mergedManifest = MergedManifestManager.getSnapshot(facet)).getDocument()) != null) {
            Element root = document.getDocumentElement();
            if (root != null && !this.isMergeManifestNode(root)) {
                this.resolveMergeManifestSources(document, project.getDir());
                document.setUserData(MERGED_MANIFEST_INFO, mergedManifest, null);
            }
            return document;
        }
        return null;
    }

    @Nullable
    public Pair<File, ? extends Node> findManifestSourceNode(Node mergedNode) {
        Map sourceNodeCache = this.getSourceNodeCache();
        Pair source = (Pair)sourceNodeCache.get(mergedNode);
        if (source != null) {
            if (source == NOT_FOUND) {
                return null;
            }
            return source;
        }
        org.w3c.dom.Document doc = mergedNode.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        MergedManifestSnapshot mergedManifest = (MergedManifestSnapshot)doc.getUserData(MERGED_MANIFEST_INFO);
        if (mergedManifest == null) {
            return null;
        }
        source = NOT_FOUND;
        List<? extends Actions.Record> records = ManifestUtils.getRecords(mergedManifest, mergedNode);
        for (Actions.Record record : records) {
            Node sourceNode;
            if (record.getActionType() != Actions.ActionType.ADDED && record.getActionType() != Actions.ActionType.MERGED || (sourceNode = ManifestUtils.getSourceNode(mergedManifest.getModule(), record)) == null) continue;
            File file = record.getActionLocation().getFile().getSourceFile();
            source = Pair.of((Object)file, (Object)sourceNode);
            break;
        }
        sourceNodeCache.put(mergedNode, source);
        return source != NOT_FOUND ? source : null;
    }

    @NotNull
    public Set<Desugaring> getDesugaring(@NotNull Project project) {
        Module module = this.getModule();
        if (module == null) {
            return Desugaring.DEFAULT;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return Desugaring.DEFAULT;
        }
        AndroidModel model2 = AndroidModel.get(module);
        if (model2 == null) {
            return Desugaring.DEFAULT;
        }
        return model2.getDesugaring();
    }

    @Nullable
    public String getRelativePath(@Nullable File baseFile, @Nullable File file) {
        return FileUtilRt.getRelativePath((File)baseFile, (File)file);
    }

    public boolean checkForSuppressComments() {
        return false;
    }

    public boolean supportsProjectResources() {
        return true;
    }

    @Nullable
    public ResourceRepository getResourceRepository(@NotNull Project project, boolean includeModuleDependencies, boolean includeLibraries) {
        AndroidFacet facet;
        Module module = this.findModuleForLintProject(this.myProject, project);
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            if (includeLibraries) {
                return ResourceRepositoryManager.getAppResources(facet);
            }
            if (includeModuleDependencies) {
                return ResourceRepositoryManager.getProjectResources(facet);
            }
            return ResourceRepositoryManager.getModuleResources(facet);
        }
        return null;
    }

    @Nullable
    public URLConnection openConnection(URL url) throws IOException {
        return HttpConfigurable.getInstance().openConnection(url.toExternalForm());
    }

    @Nullable
    public URLConnection openConnection(URL url, int timeout) throws IOException {
        URLConnection connection = HttpConfigurable.getInstance().openConnection(url.toExternalForm());
        if (timeout > 0) {
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
        }
        return connection;
    }

    @NotNull
    public ClassLoader createUrlClassLoader(URL[] urls, ClassLoader parent) {
        return UrlClassLoader.build().parent(parent).urls(urls).get();
    }

    public Location.Handle createResourceItemHandle(ResourceItem item) {
        XmlTag tag = LocalResourceRepository.getItemTag(this.myProject, item);
        if (tag != null) {
            PathString source = item.getSource();
            assert (source != null) : item;
            File file = source.toFile();
            assert (file != null) : item;
            return new LocationHandle(file, (XmlElement)tag);
        }
        return super.createResourceItemHandle(item);
    }

    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        ResourceRepositoryManager repoManager;
        ResourceVisibilityLookup.Provider provider;
        AndroidFacet facet;
        Module module = this.getModule();
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (provider = (repoManager = ResourceRepositoryManager.getInstance(facet)).getResourceVisibilityProvider()) != null) {
            return provider;
        }
        return super.getResourceVisibilityProvider();
    }

    @Nullable
    public XmlPullParser createXmlPullParser(@NotNull PathString resourcePath) throws IOException {
        return FileResourceReader.createXmlPullParser(resourcePath);
    }

    private static class LocationHandle
    implements Location.Handle,
    Computable<Location> {
        private final File myFile;
        private final XmlElement myNode;
        private Object myClientData;

        public LocationHandle(File file, XmlElement node) {
            this.myFile = file;
            this.myNode = node;
        }

        public Location resolve() {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (Location)ApplicationManager.getApplication().runReadAction((Computable)this);
            }
            TextRange textRange = this.myNode.getTextRange();
            if (this.myNode instanceof XmlTag) {
                String tag = ((XmlTag)this.myNode).getName();
                int index = this.myNode.getText().indexOf(tag);
                if (index != -1) {
                    int start = textRange.getStartOffset() + index;
                    textRange = new TextRange(start, start + tag.length());
                }
            }
            DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
            DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
            return Location.create((File)this.myFile, (Position)start, (Position)end);
        }

        public Location compute() {
            return this.resolve();
        }

        public void setClientData(@Nullable Object clientData) {
            this.myClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.myClientData;
        }
    }

    private static class BatchLintClient
    extends LintIdeClient {
        private final Map<Issue, Map<File, List<ProblemData>>> myProblemMap;
        private final AnalysisScope myScope;
        private final Set<Issue> myIssues;

        public BatchLintClient(@NotNull com.intellij.openapi.project.Project project, @NotNull Map<Issue, Map<File, List<ProblemData>>> problemMap, @NotNull AnalysisScope scope, @NotNull Set<Issue> issues) {
            super(project);
            this.myProblemMap = problemMap;
            this.myScope = scope;
            this.myIssues = issues;
        }

        @Override
        @Nullable
        protected Module getModule() {
            return null;
        }

        @Override
        protected Set<Issue> getIssues() {
            return this.myIssues;
        }

        @Override
        public void report(Context context, Issue issue2, Severity severity, Location location, String message2, TextFormat format, @Nullable LintFix quickfixData) {
            boolean inScope;
            Module module;
            VirtualFile vFile = null;
            File file = null;
            if (location != null) {
                file = location.getFile();
                vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            } else if (context.getProject() != null && (module = this.findModuleForLintProject(this.myProject, context.getProject())) != null) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                VirtualFile virtualFile = vFile = facet != null ? AndroidRootUtil.getPrimaryManifestFile(facet) : null;
                if (vFile != null) {
                    file = new File(vFile.getPath());
                }
            }
            boolean bl = inScope = vFile != null && this.myScope.contains(vFile);
            if (!inScope && vFile != null && vFile.isDirectory()) {
                Module module2;
                if (this.myScope.getScopeType() == 1) {
                    inScope = true;
                } else if ((this.myScope.getScopeType() == 4 || this.myScope.getScopeType() == 7) && (module2 = this.findModuleForLintProject(this.myProject, context.getProject())) != null && this.myScope.containsModule(module2)) {
                    inScope = true;
                }
            }
            if (inScope) {
                List<ProblemData> problemList;
                file = new File(PathUtil.getCanonicalPath((String)file.getPath()));
                HashMap file2ProblemList = this.myProblemMap.get(issue2);
                if (file2ProblemList == null) {
                    file2ProblemList = new HashMap();
                    this.myProblemMap.put(issue2, (Map<File, List<ProblemData>>)file2ProblemList);
                }
                if ((problemList = file2ProblemList.get(file)) == null) {
                    problemList = new ArrayList<ProblemData>();
                    file2ProblemList.put(file, problemList);
                }
                TextRange textRange = TextRange.EMPTY_RANGE;
                if (location != null) {
                    Position start = location.getStart();
                    Position end = location.getEnd();
                    if (start != null && end != null && start.getOffset() <= end.getOffset()) {
                        textRange = new TextRange(start.getOffset(), end.getOffset());
                    }
                }
                Severity configuredSeverity = severity != issue2.getDefaultSeverity() ? severity : null;
                message2 = format.convertTo(message2, TextFormat.RAW);
                problemList.add(new ProblemData(issue2, message2, textRange, configuredSeverity, quickfixData));
                if (location != null && location.getSecondary() != null) {
                    this.reportSecondary(context, issue2, severity, location, message2, format, quickfixData);
                }
            }
            AndroidLintInspectionBase.getInspectionShortNameByIssue(this.myProject, issue2);
        }

        public List<File> getJavaSourceFolders(Project project) {
            Module module = this.findModuleForLintProject(this.myProject, project);
            if (module == null) {
                return Collections.emptyList();
            }
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            ArrayList<File> result2 = new ArrayList<File>(sourceRoots.length);
            for (VirtualFile root : sourceRoots) {
                result2.add(new File(root.getPath()));
            }
            return result2;
        }

        public List<File> getResourceFolders(Project project) {
            AndroidFacet facet;
            Module module = this.findModuleForLintProject(this.myProject, project);
            if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
                return LintIdeUtils.getResourceDirectories(facet);
            }
            return super.getResourceFolders(project);
        }
    }

    private static class EditorLintClient
    extends LintIdeClient {
        private final State myState;

        public EditorLintClient(@NotNull State state) {
            super(state.getModule().getProject());
            this.myState = state;
        }

        @Override
        @Nullable
        protected Module getModule() {
            return this.myState.getModule();
        }

        @Override
        protected Set<Issue> getIssues() {
            return this.myState.getIssues();
        }

        @Override
        public void runReadAction(Runnable runnable) {
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                application.runReadAction(runnable);
                return;
            }
            class ProgressIndicatorWithCancellationInfo
            extends AbstractProgressIndicatorExBase {
                final Thread readActionThread;
                volatile StackTraceElement[] cancelStackDump;
                volatile long cancelStartTimeMs = -1L;

                ProgressIndicatorWithCancellationInfo(Thread readActionThread) {
                    this.readActionThread = readActionThread;
                }

                public void cancel() {
                    if (!this.isCanceled()) {
                        this.cancelStartTimeMs = System.currentTimeMillis();
                        this.cancelStackDump = this.readActionThread.getStackTrace();
                    }
                    super.cancel();
                }
            }
            ProgressIndicatorWithCancellationInfo progressIndicator = new ProgressIndicatorWithCancellationInfo(Thread.currentThread());
            long actionStartTimeMs = System.currentTimeMillis();
            boolean successful = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable, (ProgressIndicator)progressIndicator);
            if (!successful) {
                LOG.info("Android Lint read action canceled due to pending write action");
                StackTraceElement[] stackDumpRaw = progressIndicator.cancelStackDump;
                if (stackDumpRaw != null) {
                    long currTimeMs = System.currentTimeMillis();
                    long cancelTimeMs = currTimeMs - progressIndicator.cancelStartTimeMs;
                    long actionTimeMs = currTimeMs - actionStartTimeMs;
                    if (cancelTimeMs > 200L || actionTimeMs > 1000L) {
                        StringBuilder sb = new StringBuilder();
                        for (StackTraceElement e : stackDumpRaw) {
                            sb.append(e.toString());
                            sb.append("\n");
                        }
                        String stackDump = sb.toString();
                        StudioCrashReporter.getInstance().submit(new GenericStudioReport.Builder("LintReadActionDelay").addDataNoPii("summary", "Android Lint either took too long to run a read action (" + actionTimeMs + "ms),\nor took too long to cancel and yield to a pending write action (" + cancelTimeMs + "ms)").addDataNoPii("timeToCancelMs", String.valueOf(cancelTimeMs)).addDataNoPii("readActionTimeMs", String.valueOf(actionTimeMs)).addDataNoPii("stackDump", stackDump).build());
                    }
                }
                throw new ProcessCanceledException();
            }
        }

        @Override
        public <T> T runReadAction(Computable<T> computable) {
            Ref res = new Ref();
            this.runReadAction(() -> res.set(computable.compute()));
            return (T)res.get();
        }

        @Override
        public void report(Context context, Issue issue2, Severity severity, Location location, String message2, TextFormat format, @Nullable LintFix quickfixData) {
            Location secondary;
            File file = location.getFile();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (this.myState.getMainFile().equals(vFile)) {
                Position start = location.getStart();
                Position end = location.getEnd();
                TextRange textRange = start != null && end != null && start.getOffset() <= end.getOffset() ? new TextRange(start.getOffset(), end.getOffset()) : TextRange.EMPTY_RANGE;
                Severity configuredSeverity = severity != issue2.getDefaultSeverity() ? severity : null;
                message2 = format.convertTo(message2, TextFormat.RAW);
                this.myState.getProblems().add(new ProblemData(issue2, message2, textRange, configuredSeverity, quickfixData));
            }
            if ((secondary = location.getSecondary()) != null && this.myState.getMainFile().equals(LocalFileSystem.getInstance().findFileByIoFile(secondary.getFile()))) {
                this.reportSecondary(context, issue2, severity, location, message2, format, quickfixData);
            }
        }

        @Override
        @NotNull
        public String readFile(File file) {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) {
                try {
                    return Files.toString((File)file, (Charset)Charsets.UTF_8);
                }
                catch (IOException ioe) {
                    LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
                    return "";
                }
            }
            String content = this.getFileContent(vFile);
            if (content == null) {
                LOG.info("Cannot find file " + file.getPath() + " in the PSI");
                return "";
            }
            return content;
        }

        @Nullable
        private String getFileContent(VirtualFile vFile) {
            if (Comparing.equal((Object)this.myState.getMainFile(), (Object)vFile)) {
                return this.myState.getMainFileContent();
            }
            return (String)this.runReadAction(() -> {
                Module module = this.myState.getModule();
                com.intellij.openapi.project.Project project = module.getProject();
                PsiFile psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)project).findFile(vFile);
                if (psiFile == null) {
                    return null;
                }
                Document document = PsiDocumentManager.getInstance((com.intellij.openapi.project.Project)project).getDocument(psiFile);
                if (document != null) {
                    DocumentListener listener2 = new DocumentListener(){

                        public void documentChanged(@NotNull DocumentEvent event) {
                            myState.markDirty();
                        }
                    };
                    document.addDocumentListener(listener2, (Disposable)this);
                }
                return psiFile.getText();
            });
        }

        public List<File> getJavaSourceFolders(Project project) {
            Module module = this.myState.getModule();
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            ArrayList<File> result2 = new ArrayList<File>(sourceRoots.length);
            for (VirtualFile root : sourceRoots) {
                result2.add(new File(root.getPath()));
            }
            return result2;
        }

        public List<File> getResourceFolders(Project project) {
            Module module = this.myState.getModule();
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null) {
                return LintIdeUtils.getResourceDirectories(facet);
            }
            return super.getResourceFolders(project);
        }
    }
}

