/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.LintIdeUtils;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class LintIdeGradleVisitor
extends GradleVisitor {
    private static String getClosureName(GrClosableBlock closure) {
        GrReferenceExpression invokedExpression;
        GrMethodCall parent;
        if (closure.getParent() instanceof GrMethodCall && (parent = (GrMethodCall)closure.getParent()).getInvokedExpression() instanceof GrReferenceExpression && (invokedExpression = (GrReferenceExpression)parent.getInvokedExpression()).getDotToken() == null) {
            return invokedExpression.getReferenceName();
        }
        return null;
    }

    public void visitBuildScript(final @NotNull GradleContext context, final @NotNull List<? extends GradleScanner> detectors) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = LintIdeUtils.getPsiFile((Context)context);
                if (!(psiFile instanceof GroovyFile)) {
                    return;
                }
                GroovyFile groovyFile = (GroovyFile)psiFile;
                groovyFile.accept((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

                    public void visitClosure(@NotNull GrClosableBlock closure) {
                        GrClosableBlock block;
                        String parentName = LintIdeGradleVisitor.getClosureName(closure);
                        String parentParentName = null;
                        if (parentName != null && (block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)closure, GrClosableBlock.class, (boolean)true)) != null) {
                            parentParentName = LintIdeGradleVisitor.getClosureName(block);
                        }
                        if (parentName != null) {
                            for (PsiElement element : closure.getChildren()) {
                                GrExpression rValue;
                                GrReferenceExpression propertyRef;
                                String property2;
                                GrAssignmentExpression assignment;
                                GrExpression lValue;
                                String value2;
                                if (element instanceof GrApplicationStatement) {
                                    GrReferenceExpression propertyRef2;
                                    String property3;
                                    GrApplicationStatement call = (GrApplicationStatement)element;
                                    GrExpression propertyExpression = call.getInvokedExpression();
                                    GrCommandArgumentList argumentList = call.getArgumentList();
                                    if (!(propertyExpression instanceof GrReferenceExpression) || (property3 = (propertyRef2 = (GrReferenceExpression)propertyExpression).getReferenceName()) == null || argumentList == null) continue;
                                    value2 = argumentList.getText();
                                    for (GradleScanner detector : detectors) {
                                        detector.checkDslPropertyAssignment(context, property3, value2, parentName, parentParentName, (Object)propertyRef2, (Object)argumentList, (Object)call);
                                    }
                                    continue;
                                }
                                if (!(element instanceof GrAssignmentExpression) || !((lValue = (assignment = (GrAssignmentExpression)element).getLValue()) instanceof GrReferenceExpression) || (property2 = (propertyRef = (GrReferenceExpression)lValue).getReferenceName()) == null || (rValue = assignment.getRValue()) == null) continue;
                                value2 = rValue.getText();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, property2, value2, parentName, parentParentName, (Object)lValue, (Object)rValue, (Object)assignment);
                                }
                                if (parentName.equals("ext") || !property2.equals("minSdkVersion") && !property2.equals("targetSdkVersion")) continue;
                                int lValueEnd = lValue.getTextRange().getEndOffset();
                                int rValueStart = rValue.getTextRange().getStartOffset();
                                assert (lValueEnd <= rValueStart);
                                DefaultPosition startPosition = new DefaultPosition(-1, -1, lValueEnd);
                                DefaultPosition endPosition = new DefaultPosition(-1, -1, rValueStart);
                                Location location = Location.create((File)context.file, (Position)startPosition, (Position)endPosition);
                                String message2 = String.format("Do not use assignment with the %1$s property (remove the '=')", property2);
                                context.report(GradleDetector.IDE_SUPPORT, location, message2, null);
                            }
                        }
                        super.visitClosure(closure);
                    }

                    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                        GrClosableBlock block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)applicationStatement, GrClosableBlock.class, (boolean)true);
                        String parentName = block != null ? LintIdeGradleVisitor.getClosureName(block) : null;
                        String statementName = applicationStatement.getInvokedExpression().getText();
                        GrCommandArgumentList argumentList = applicationStatement.getArgumentList();
                        HashMap namedArguments = Maps.newHashMap();
                        ArrayList unnamedArguments = Lists.newArrayList();
                        for (GroovyPsiElement groovyPsiElement : argumentList.getAllArguments()) {
                            if (groovyPsiElement instanceof GrNamedArgument) {
                                Object value2;
                                GrNamedArgument namedArgument = (GrNamedArgument)groovyPsiElement;
                                GrExpression expression = namedArgument.getExpression();
                                if (!(expression instanceof GrLiteral) || (value2 = ((GrLiteral)expression).getValue()) == null) continue;
                                namedArguments.put(namedArgument.getLabelName(), value2.toString());
                            } else if (groovyPsiElement instanceof GrExpression) {
                                unnamedArguments.add(groovyPsiElement.getText());
                            }
                            for (GradleScanner detector : detectors) {
                                detector.checkMethodCall(context, statementName, parentName, (Map)namedArguments, (List)unnamedArguments, (Object)applicationStatement);
                            }
                        }
                        super.visitApplicationStatement(applicationStatement);
                    }
                });
            }
        });
    }

    public int getStartOffset(@NotNull GradleContext context, @NotNull Object cookie) {
        int startOffset = super.getStartOffset(context, cookie);
        if (startOffset != -1) {
            return startOffset;
        }
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        return textRange.getStartOffset();
    }

    public Object getPropertyPairCookie(Object cookie) {
        PsiElement element = (PsiElement)cookie;
        return element.getParent();
    }

    public Object getPropertyKeyCookie(Object cookie) {
        PsiElement element = (PsiElement)cookie;
        PsiElement parent = element.getParent();
        if (parent instanceof GrApplicationStatement) {
            GrApplicationStatement call = (GrApplicationStatement)parent;
            return call.getInvokedExpression();
        }
        if (parent instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)parent;
            return assignment.getLValue();
        }
        return super.getPropertyKeyCookie(cookie);
    }

    @NotNull
    public Location createLocation(@NotNull GradleContext context, @NotNull Object cookie) {
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        int start = textRange.getStartOffset();
        int end = textRange.getEndOffset();
        return Location.create((File)context.file, (Position)new DefaultPosition(-1, -1, start), (Position)new DefaultPosition(-1, -1, end)).withSource((Object)element);
    }
}

