/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.GradleModelConverterUtil;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.projectmodel.ProjectType;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class LintIdeProject
extends Project {
    public static final boolean SUPPORT_CLASS_FILES = false;
    protected AndroidVersion myMinSdkVersion;
    protected AndroidVersion myTargetSdkVersion;

    LintIdeProject(LintClient client, File dir, File referenceDir) {
        super(client, dir, referenceDir);
    }

    public static List<Project> create(LintIdeClient client, @Nullable List<VirtualFile> files2, Module ... modules) {
        ArrayList projects = Lists.newArrayList();
        HashMap projectMap = Maps.newHashMap();
        HashMap moduleMap = Maps.newHashMap();
        HashMap libraryMap = Maps.newHashMap();
        if (files2 != null && !files2.isEmpty()) {
            files2 = Lists.newArrayList(files2);
        }
        for (Module module : modules) {
            LintIdeProject.addProjects(client, module, files2, moduleMap, libraryMap, projectMap, projects);
        }
        client.setModuleMap(projectMap);
        if (projects.size() > 1) {
            HashSet roots = new HashSet(projects);
            for (Project project : projects) {
                roots.removeAll(project.getAllLibraries());
            }
            return Lists.newArrayList(roots);
        }
        return projects;
    }

    public static Pair<Project, Project> createForSingleFile(LintIdeClient client, @Nullable VirtualFile file, Module module) {
        LintModuleProject project = LintIdeProject.createModuleProject(client, module);
        LintModuleProject main = null;
        HashMap projectMap = Maps.newHashMap();
        if (project != null) {
            Module androidModule;
            project.setDirectLibraries(Collections.emptyList());
            if (file != null) {
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
            }
            projectMap.put(project, module);
            if (!project.isAndroidProject() && (androidModule = LintIdeProject.findAndroidModule(module)) != null && (main = LintIdeProject.createModuleProject(client, androidModule)) != null) {
                projectMap.put(main, androidModule);
                main.setDirectLibraries(Collections.singletonList(project));
            }
        }
        client.setModuleMap(projectMap);
        return Pair.create((Object)((Object)project), main);
    }

    @Nullable
    private static Module findAndroidModule(Module module) {
        if (module.isDisposed()) {
            return null;
        }
        Graph graph = (Graph)ApplicationManager.getApplication().runReadAction(() -> {
            com.intellij.openapi.project.Project project = module.getProject();
            return ModuleManager.getInstance((com.intellij.openapi.project.Project)project).moduleGraph();
        });
        if (graph == null) {
            return null;
        }
        HashSet facets = Sets.newHashSet();
        HashSet seen = Sets.newHashSet();
        seen.add(module);
        LintIdeProject.addAndroidModules(facets, seen, (Graph<Module>)graph, module);
        for (AndroidFacet facet : facets) {
            if (!((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) continue;
            return facet.getModule();
        }
        if (!facets.isEmpty()) {
            return ((AndroidFacet)((Object)facets.iterator().next())).getModule();
        }
        return null;
    }

    private static void addAndroidModules(Set<AndroidFacet> androidFacets, Set<Module> seen, Graph<Module> graph, Module module) {
        Iterator iterator = graph.getOut((Object)module);
        while (iterator.hasNext()) {
            Module dep = (Module)iterator.next();
            AndroidFacet facet = AndroidFacet.getInstance(dep);
            if (facet != null) {
                androidFacets.add(facet);
            }
            if (seen.contains(dep)) continue;
            seen.add(dep);
            LintIdeProject.addAndroidModules(androidFacets, seen, graph, dep);
        }
    }

    private static void addProjects(LintClient client, Module module, @Nullable List<VirtualFile> files2, Map<Module, Project> moduleMap, Map<AndroidLibrary, Project> libraryMap, Map<Project, Module> projectMap, List<Project> projects) {
        AndroidModuleModel androidModuleModel;
        if (moduleMap.containsKey(module)) {
            return;
        }
        LintModuleProject project = LintIdeProject.createModuleProject(client, module);
        if (project == null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(module, false);
            for (AndroidFacet dependentFacet : dependentFacets) {
                LintIdeProject.addProjects(client, dependentFacet.getModule(), files2, moduleMap, libraryMap, projectMap, projects);
            }
            return;
        }
        project.setIdeaProject(module.getProject());
        projects.add(project);
        moduleMap.put(module, project);
        projectMap.put(project, module);
        if (LintIdeProject.processFileFilter(module, files2, project)) {
            return;
        }
        ArrayList dependencies = Lists.newArrayList();
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(module, true);
        for (AndroidFacet dependentFacet : dependentFacets) {
            Project p = moduleMap.get(dependentFacet.getModule());
            if (p != null) {
                dependencies.add(p);
                continue;
            }
            LintIdeProject.addProjects(client, dependentFacet.getModule(), files2, moduleMap, libraryMap, projectMap, dependencies);
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidModuleModel = AndroidModuleModel.get(facet)) != null) {
            LintIdeProject.addGradleLibraryProjects(client, files2, libraryMap, projects, facet, androidModuleModel, project, projectMap, dependencies);
        }
        project.setDirectLibraries(dependencies);
    }

    private static boolean processFileFilter(Module module, @Nullable List<VirtualFile> files2, LintModuleProject project) {
        if (files2 != null && !files2.isEmpty()) {
            ListIterator<VirtualFile> iterator = files2.listIterator();
            while (iterator.hasNext()) {
                VirtualFile file = iterator.next();
                if (!module.getModuleContentScope().accept(file)) continue;
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                iterator.remove();
            }
            if (files2.isEmpty()) {
                project.setDirectLibraries(Collections.emptyList());
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static LintModuleProject createModuleProject(LintClient client, Module module) {
        LintModuleProject project;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        File dir = LintIdeProject.getLintProjectDirectory(module, facet);
        if (dir == null) {
            return null;
        }
        if (facet == null) {
            project = new LintModuleProject(client, dir, dir, module);
            AndroidFacet f = LintIdeProject.findAndroidFacetInProject(module.getProject());
            if (f != null) {
                project.gradleProject = f.requiresAndroidModel();
            }
        } else {
            AndroidModel androidModel;
            project = facet.requiresAndroidModel() ? ((androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel()) instanceof AndroidModuleModel ? new LintGradleProject(client, dir, dir, facet, (AndroidModuleModel)androidModel) : (androidModel != null ? new LintAndroidModelProject(client, dir, dir, facet, androidModel) : new LintAndroidProject(client, dir, dir, facet))) : new LintAndroidProject(client, dir, dir, facet);
        }
        client.registerProject(dir, (Project)project);
        return project;
    }

    @Nullable
    public static File getLintProjectDirectory(Module module, @Nullable AndroidFacet facet) {
        File dir;
        if (facet != null) {
            VirtualFile mainContentRoot = AndroidRootUtil.getMainContentRoot(facet);
            if (mainContentRoot == null) {
                return null;
            }
            dir = VfsUtilCore.virtualToIoFile((VirtualFile)mainContentRoot);
        } else {
            String moduleDirPath = AndroidRootUtil.getModuleDirPath(module);
            if (moduleDirPath == null) {
                return null;
            }
            dir = new File(FileUtil.toSystemDependentName((String)moduleDirPath));
        }
        return dir;
    }

    public static boolean hasAndroidModule(com.intellij.openapi.project.Project project) {
        return LintIdeProject.findAndroidFacetInProject(project) != null;
    }

    @Nullable
    private static AndroidFacet findAndroidFacetInProject(com.intellij.openapi.project.Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((com.intellij.openapi.project.Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            return facet;
        }
        return null;
    }

    private static void addGradleLibraryProjects(LintClient client, @Nullable List<VirtualFile> files2, Map<AndroidLibrary, Project> libraryMap, List<Project> projects, AndroidFacet facet, AndroidModuleModel androidModuleModel, LintModuleProject project, Map<Project, Module> projectMap, List<Project> dependencies) {
        Collection libraries = androidModuleModel.getSelectedMainCompileDependencies().getLibraries();
        for (AndroidLibrary library : libraries) {
            Project p = libraryMap.get(library);
            if (p == null) {
                File dir = library.getFolder();
                p = new LintGradleLibraryProject(client, dir, dir, library);
                libraryMap.put(library, p);
                projectMap.put(p, facet.getModule());
                projects.add(p);
                if (files2 != null) {
                    VirtualFile libraryDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
                    if (libraryDir != null) {
                        ListIterator<VirtualFile> iterator = files2.listIterator();
                        while (iterator.hasNext()) {
                            VirtualFile file = iterator.next();
                            if (!VfsUtilCore.isAncestor((VirtualFile)libraryDir, (VirtualFile)file, (boolean)false)) continue;
                            project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                            iterator.remove();
                        }
                    }
                    if (files2.isEmpty()) {
                        files2 = null;
                    }
                }
            }
            dependencies.add(p);
        }
    }

    protected void initialize() {
    }

    protected static boolean depsDependsOn(Project project, String artifact) {
        for (Project dependency : project.getDirectLibraries()) {
            Boolean b = dependency.dependsOn(artifact);
            if (b == null || !b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public com.intellij.openapi.project.Project getIdeaProject() {
        if (this.client instanceof LintIdeClient) {
            return ((LintIdeClient)this.client).myProject;
        }
        return super.getIdeaProject();
    }

    private static class LintGradleLibraryProject
    extends LintIdeProject {
        private final AndroidLibrary myLibrary;
        private static boolean sOptionalAvailable = true;

        private LintGradleLibraryProject(LintClient client, File dir, File referenceDir, AndroidLibrary library) {
            super(client, dir, referenceDir);
            this.myLibrary = library;
            this.library = true;
            this.mergeManifests = true;
            this.reportIssues = false;
            this.gradleProject = true;
            this.directLibraries = Collections.emptyList();
        }

        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                File manifest = this.myLibrary.getManifest();
                this.manifestFiles = manifest.exists() ? Collections.singletonList(manifest) : Collections.emptyList();
            }
            return this.manifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                File proguardRules = this.myLibrary.getProguardRules();
                this.proguardFiles = proguardRules.exists() ? Collections.singletonList(proguardRules) : Collections.emptyList();
            }
            return this.proguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.resourceFolders == null) {
                File folder = this.myLibrary.getResFolder();
                this.resourceFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.resourceFolders;
        }

        public List<File> getAssetFolders() {
            if (this.assetFolders == null) {
                File folder = this.myLibrary.getAssetsFolder();
                this.assetFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.assetFolders;
        }

        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }

        @Nullable
        public AndroidProject getGradleProjectModel() {
            return null;
        }

        @Nullable
        public AndroidLibrary getGradleLibraryModel() {
            return this.myLibrary;
        }

        @Nullable
        public Boolean dependsOn(String artifact) {
            if ("com.android.support:support-v4".equals(artifact) || "androidx.legacy:legacy-support-v4".equals(artifact)) {
                if (this.supportLib == null) {
                    this.supportLib = GradleUtil.dependsOn(this.myLibrary, "com.android.support:support-v4", true) || GradleUtil.dependsOn(this.myLibrary, "androidx.legacy:legacy-support-v4", true);
                }
                return this.supportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact) || "androidx.appcompat:appcompat".equals(artifact)) {
                if (this.appCompat == null) {
                    this.appCompat = GradleUtil.dependsOn(this.myLibrary, "com.android.support:appcompat-v7", true) || GradleUtil.dependsOn(this.myLibrary, "androidx.appcompat:appcompat", true);
                }
                return this.appCompat;
            }
            if ("com.android.support:leanback-v17".equals(artifact) || "androidx.leanback:leanback".equals(artifact)) {
                if (this.leanback == null) {
                    this.leanback = GradleUtil.dependsOn(this.myLibrary, "com.android.support:leanback-v17", true) || GradleUtil.dependsOn(this.myLibrary, "androidx.leanback:leanback", true);
                }
                return this.leanback;
            }
            if (GradleUtil.dependsOn(this.myLibrary, artifact, true)) {
                return true;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintGradleProject
    extends LintAndroidModelProject {
        private final AndroidModuleModel myAndroidModuleModel;
        private static boolean sProvidedAvailable = true;

        private LintGradleProject(LintClient client, File dir, File referenceDir, AndroidFacet facet, AndroidModuleModel androidModuleModel) {
            super(client, dir, referenceDir, facet, androidModuleModel);
            this.gradleProject = true;
            this.mergeManifests = true;
            this.myAndroidModuleModel = androidModuleModel;
        }

        @Override
        protected boolean includeTests() {
            GradleVersion version2;
            AndroidProject model2;
            if (this.isGradleProject() && (model2 = this.getGradleProjectModel()) != null && (version2 = this.getGradleModelVersion()) != null && version2.isAtLeast(2, 4, 0, "alpha", 4, true)) {
                try {
                    return model2.getLintOptions().isCheckTestSources();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.includeTests();
        }

        @Override
        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                File manifestFile;
                SourceProvider variantProvider;
                SourceProvider buildTypeSourceProvider;
                File manifestFile2;
                File manifestFile3;
                this.manifestFiles = Lists.newArrayList();
                File mainManifest = this.myFacet.getMainSourceProvider().getManifestFile();
                if (mainManifest.exists()) {
                    this.manifestFiles.add(mainManifest);
                }
                List<SourceProvider> flavorSourceProviders = this.myAndroidModuleModel.getFlavorSourceProviders();
                for (SourceProvider provider : flavorSourceProviders) {
                    manifestFile3 = provider.getManifestFile();
                    if (!manifestFile3.exists()) continue;
                    this.manifestFiles.add(manifestFile3);
                }
                SourceProvider multiProvider = this.myAndroidModuleModel.getMultiFlavorSourceProvider();
                if (multiProvider != null && (manifestFile2 = multiProvider.getManifestFile()).exists()) {
                    this.manifestFiles.add(manifestFile2);
                }
                if ((buildTypeSourceProvider = this.myAndroidModuleModel.getBuildTypeSourceProvider()) != null && (manifestFile3 = buildTypeSourceProvider.getManifestFile()).exists()) {
                    this.manifestFiles.add(manifestFile3);
                }
                if ((variantProvider = this.myAndroidModuleModel.getVariantSourceProvider()) != null && (manifestFile = variantProvider.getManifestFile()).exists()) {
                    this.manifestFiles.add(manifestFile);
                }
            }
            return this.manifestFiles;
        }

        public List<File> getAssetFolders() {
            if (this.assetFolders == null) {
                this.assetFolders = Lists.newArrayList();
                for (SourceProvider provider : IdeaSourceProvider.getAllSourceProviders(this.myFacet)) {
                    Collection dirs = provider.getAssetsDirectories();
                    for (File dir : dirs) {
                        if (!dir.exists()) continue;
                        this.assetFolders.add(dir);
                    }
                }
            }
            return this.assetFolders;
        }

        @Override
        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                AndroidModuleModel androidModel;
                if (this.myFacet.requiresAndroidModel() && (androidModel = AndroidModuleModel.get(this.myFacet)) != null) {
                    ProductFlavor flavor = androidModel.getAndroidProject().getDefaultConfig().getProductFlavor();
                    this.proguardFiles = Lists.newArrayList();
                    for (File file : flavor.getProguardFiles()) {
                        if (!file.exists()) continue;
                        this.proguardFiles.add(file);
                    }
                    try {
                        for (File file : flavor.getConsumerProguardFiles()) {
                            if (!file.exists()) continue;
                            this.proguardFiles.add(file);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.proguardFiles == null) {
                    this.proguardFiles = Collections.emptyList();
                }
            }
            return this.proguardFiles;
        }

        public boolean hasDynamicFeatures() {
            if (this.getProjectType() != ProjectType.APP) {
                return false;
            }
            if (!GradleProjectInfo.getInstance(this.myFacet.getModule().getProject()).isBuildWithGradle()) {
                return false;
            }
            if (!this.myFacet.requiresAndroidModel()) {
                return false;
            }
            AndroidModuleModel model2 = AndroidModuleModel.get(this.myFacet);
            if (model2 == null) {
                return false;
            }
            IdeAndroidProject project = model2.getAndroidProject();
            return project.isBaseSplit() && !project.getDynamicFeatures().isEmpty();
        }

        @Override
        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        @Override
        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }

        public int getBuildSdk() {
            String compileTarget;
            AndroidVersion version2;
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel != null && (version2 = AndroidTargetHash.getPlatformVersion((String)(compileTarget = androidModel.getAndroidProject().getCompileTarget()))) != null) {
                return version2.getFeatureLevel();
            }
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
            if (platform != null) {
                return platform.getApiVersion().getFeatureLevel();
            }
            return super.getBuildSdk();
        }

        @Nullable
        public String getBuildTargetHash() {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel != null) {
                return androidModel.getAndroidProject().getCompileTarget();
            }
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
            if (platform != null) {
                return AndroidTargetHash.getPlatformHashString((AndroidVersion)platform.getApiVersion());
            }
            return super.getBuildTargetHash();
        }

        @Nullable
        public AndroidProject getGradleProjectModel() {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel != null) {
                return androidModel.getAndroidProject();
            }
            return null;
        }

        @Nullable
        public Variant getCurrentVariant() {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel != null) {
                return androidModel.getSelectedVariant();
            }
            return null;
        }

        @Nullable
        public AndroidLibrary getGradleLibraryModel() {
            return null;
        }

        @Override
        @Nullable
        public Boolean dependsOn(String artifact) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if ("com.android.support:support-v4".equals(artifact) || "androidx.legacy:legacy-support-v4".equals(artifact)) {
                if (this.supportLib == null) {
                    this.supportLib = this.myFacet.requiresAndroidModel() && ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getModel() != null && androidModel != null ? Boolean.valueOf(GradleUtil.dependsOn(androidModel, "com.android.support:support-v4") || GradleUtil.dependsOn(androidModel, "androidx.legacy:legacy-support-v4")) : Boolean.valueOf(LintGradleProject.depsDependsOn(this, "com.android.support:support-v4") || LintGradleProject.depsDependsOn(this, "androidx.legacy:legacy-support-v4"));
                }
                return this.supportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact) || "androidx.appcompat:appcompat".equals(artifact)) {
                if (this.appCompat == null) {
                    this.appCompat = this.myFacet.requiresAndroidModel() && ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getModel() != null && androidModel != null ? Boolean.valueOf(GradleUtil.dependsOn(androidModel, "com.android.support:appcompat-v7") || GradleUtil.dependsOn(androidModel, "androidx.appcompat:appcompat")) : Boolean.valueOf(LintGradleProject.depsDependsOn(this, "com.android.support:appcompat-v7") || LintGradleProject.depsDependsOn(this, "androidx.appcompat:appcompat"));
                }
                return this.appCompat;
            }
            if ("com.android.support:leanback-v17".equals(artifact) || "androidx.leanback:leanback".equals(artifact)) {
                if (this.leanback == null) {
                    this.leanback = this.myFacet.requiresAndroidModel() && ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getModel() != null && androidModel != null ? Boolean.valueOf(GradleUtil.dependsOn(androidModel, "com.android.support:leanback-v17") || GradleUtil.dependsOn(androidModel, "androidx.leanback:leanback")) : Boolean.valueOf(LintGradleProject.depsDependsOn(this, "com.android.support:leanback-v17") || LintGradleProject.depsDependsOn(this, "androidx.leanback:leanback"));
                }
                return this.leanback;
            }
            if (this.myFacet.requiresAndroidModel() && ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getModel() != null && androidModel != null) {
                String newArtifact;
                if (GradleUtil.dependsOn(androidModel, artifact)) {
                    return true;
                }
                if (artifact.startsWith("com.android.support") && !(newArtifact = AndroidxNameUtils.getCoordinateMapping((String)artifact)).equals(artifact) && GradleUtil.dependsOn(androidModel, newArtifact)) {
                    return true;
                }
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintAndroidModelProject
    extends LintAndroidProject {
        private final AndroidModel myAndroidModel;

        private LintAndroidModelProject(LintClient client, File dir, File referenceDir, AndroidFacet facet, AndroidModel androidModel) {
            super(client, dir, referenceDir, facet);
            this.myAndroidModel = androidModel;
        }

        @Nullable
        public String getPackage() {
            String manifestPackage = super.getPackage();
            if (manifestPackage != null) {
                return manifestPackage;
            }
            return this.myAndroidModel.getApplicationId();
        }

        public AndroidVersion getMinSdkVersion() {
            if (this.myMinSdkVersion == null) {
                this.myMinSdkVersion = AndroidModuleInfo.getInstance(this.myFacet).getMinSdkVersion();
            }
            return this.myMinSdkVersion;
        }

        public AndroidVersion getTargetSdkVersion() {
            if (this.myTargetSdkVersion == null) {
                this.myTargetSdkVersion = AndroidModuleInfo.getInstance(this.myFacet).getTargetSdkVersion();
            }
            return this.myTargetSdkVersion;
        }
    }

    private static class LintAndroidProject
    extends LintModuleProject {
        protected final AndroidFacet myFacet;

        private LintAndroidProject(LintClient client, File dir, File referenceDir, AndroidFacet facet) {
            super(client, dir, referenceDir, facet.getModule());
            this.myFacet = facet;
            this.gradleProject = false;
            this.library = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).isLibraryProject();
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
            if (platform != null) {
                this.buildSdk = platform.getApiLevel();
            }
        }

        @Override
        public boolean isAndroidProject() {
            return true;
        }

        public String getName() {
            return this.myFacet.getModule().getName();
        }

        public ProjectType getProjectType() {
            return GradleModelConverterUtil.getProjectType((int)((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType());
        }

        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet);
                this.manifestFiles = manifestFile != null ? Collections.singletonList(VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile)) : Collections.emptyList();
            }
            return this.manifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                List urls;
                JpsAndroidModuleProperties properties = this.myFacet.getProperties();
                if (properties.RUN_PROGUARD && !(urls = properties.myProGuardCfgFiles).isEmpty()) {
                    this.proguardFiles = new ArrayList();
                    for (String osPath : AndroidUtils.urlsToOsPaths(urls, null)) {
                        if (osPath.contains("%MODULE_SDK_HOME%")) continue;
                        this.proguardFiles.add(new File(osPath));
                    }
                }
                if (this.proguardFiles == null) {
                    this.proguardFiles = Collections.emptyList();
                }
            }
            return this.proguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.resourceFolders == null) {
                List<VirtualFile> folders = ResourceFolderManager.getInstance(this.myFacet).getFolders();
                ArrayList dirs = Lists.newArrayListWithExpectedSize((int)folders.size());
                for (VirtualFile folder : folders) {
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)folder));
                }
                this.resourceFolders = dirs;
            }
            return this.resourceFolders;
        }

        @Nullable
        public Boolean dependsOn(String artifact) {
            GradleCoordinate queryCoordinate = GradleCoordinate.parseCoordinateString((String)(artifact + ":+"));
            if (queryCoordinate != null) {
                String newArtifact;
                GradleCoordinate foundDependency = ProjectSystemUtil.getModuleSystem(this.myFacet.getModule()).getResolvedDependency(queryCoordinate);
                if (foundDependency != null) {
                    return Boolean.TRUE;
                }
                if (artifact.startsWith("com.android.support") && !(newArtifact = AndroidxNameUtils.getCoordinateMapping((String)artifact)).equals(artifact) && (queryCoordinate = GradleCoordinate.parseCoordinateString((String)(newArtifact + ":+"))) != null && (foundDependency = ProjectSystemUtil.getModuleSystem(this.myFacet.getModule()).getResolvedDependency(queryCoordinate)) != null) {
                    return Boolean.TRUE;
                }
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintModuleProject
    extends LintIdeProject {
        private final Module myModule;

        public void setDirectLibraries(List<Project> libraries) {
            this.directLibraries = libraries;
        }

        private LintModuleProject(LintClient client, File dir, File referenceDir, Module module) {
            super(client, dir, referenceDir);
            this.myModule = module;
        }

        public boolean isAndroidProject() {
            return false;
        }

        protected boolean includeTests() {
            return false;
        }

        public List<File> getJavaSourceFolders() {
            if (this.javaSourceFolders == null) {
                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots(false);
                ArrayList<File> dirs = new ArrayList<File>(sourceRoots.length);
                com.intellij.openapi.project.Project project = this.myModule.getProject();
                for (VirtualFile root : sourceRoots) {
                    if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)root, (com.intellij.openapi.project.Project)project)) continue;
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
                this.javaSourceFolders = dirs;
            }
            return this.javaSourceFolders;
        }

        public List<File> getGeneratedSourceFolders() {
            if (this.generatedSourceFolders == null) {
                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots(this.includeTests());
                ArrayList<File> dirs = new ArrayList<File>(sourceRoots.length);
                com.intellij.openapi.project.Project project = this.myModule.getProject();
                for (VirtualFile root : sourceRoots) {
                    if (!GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)root, (com.intellij.openapi.project.Project)project)) continue;
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
                this.generatedSourceFolders = dirs;
            }
            return this.generatedSourceFolders;
        }

        public List<File> getTestSourceFolders() {
            if (this.testSourceFolders == null) {
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)this.myModule);
                Object[] sourceRoots = manager.getSourceRoots(false);
                VirtualFile[] sourceAndTestRoots = manager.getSourceRoots(true);
                com.intellij.openapi.project.Project project = this.myModule.getProject();
                ArrayList<File> dirs = new ArrayList<File>(sourceAndTestRoots.length);
                for (VirtualFile root : sourceAndTestRoots) {
                    if (ArrayUtil.contains((Object)root, (Object[])sourceRoots) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)root, (com.intellij.openapi.project.Project)project)) continue;
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
                this.testSourceFolders = dirs;
            }
            return this.testSourceFolders;
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }
    }
}

