/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.lint.LintIdeRequest;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class LintIdeUtils {
    private LintIdeUtils() {
    }

    public static Location getLocation(File file, PsiElement element) {
        PsiClass clz;
        PsiIdentifier nameIdentifier;
        assert (element.getContainingFile().getVirtualFile() == null || FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)element.getContainingFile().getVirtualFile()), (File)file));
        if (element instanceof PsiClass && (nameIdentifier = (clz = (PsiClass)element).getNameIdentifier()) != null) {
            element = nameIdentifier;
        }
        TextRange textRange = element.getTextRange();
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create((File)file, (Position)start, (Position)end).withSource((Object)element);
    }

    public static PsiFile getPsiFile(Context context) {
        LintRequest request = context.getDriver().getRequest();
        Project project = ((LintIdeRequest)request).getProject();
        if (project.isDisposed()) {
            return null;
        }
        VirtualFile file = VfsUtil.findFileByIoFile((File)context.file, (boolean)false);
        if (file == null) {
            return null;
        }
        return AndroidPsiUtils.getPsiFileSafely(project, file);
    }

    public static String getInternalMethodName(PsiMethod method) {
        if (method.isConstructor()) {
            return "<init>";
        }
        return method.getName();
    }

    public static String getInternalName(PsiClass psiClass) {
        PsiClass parent;
        if (psiClass instanceof PsiAnonymousClass && (parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class)) != null) {
            String internalName = LintIdeUtils.getInternalName(parent);
            if (internalName == null) {
                return null;
            }
            return internalName + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
        }
        String sig = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (sig == null) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName != null) {
                return ClassContext.getInternalName((String)qualifiedName);
            }
            return null;
        }
        if (sig.indexOf(46) != -1) {
            sig = ClassContext.getInternalName((String)sig);
        }
        return sig;
    }

    public static String getInternalDescription(PsiMethod method, boolean includeName, boolean includeReturn) {
        assert (!includeName);
        assert (!includeReturn);
        StringBuilder signature = new StringBuilder();
        if (includeName) {
            if (method.isConstructor()) {
                PsiClass outerClass;
                PsiClass declaringClass = method.getContainingClass();
                if (declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static") && !LintIdeUtils.appendJvmTypeName(signature, outerClass)) {
                    return null;
                }
                signature.append("<init>");
            } else {
                signature.append(method.getName());
            }
        }
        signature.append('(');
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (LintIdeUtils.appendJvmSignature(signature, psiParameter.getType())) continue;
            return null;
        }
        signature.append(')');
        if (includeReturn) {
            if (!method.isConstructor()) {
                if (!LintIdeUtils.appendJvmSignature(signature, method.getReturnType())) {
                    return null;
                }
            } else {
                signature.append('V');
            }
        }
        return signature.toString();
    }

    private static boolean appendJvmTypeName(StringBuilder signature, PsiClass outerClass) {
        String className = LintIdeUtils.getInternalName(outerClass);
        if (className == null) {
            return false;
        }
        signature.append('L').append(className.replace('.', '/')).append(';');
        return true;
    }

    private static boolean appendJvmSignature(StringBuilder buffer, PsiType type) {
        if (type == null) {
            return false;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)type);
        if (psiType instanceof PsiArrayType) {
            buffer.append('[');
            LintIdeUtils.appendJvmSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)psiType).resolve();
            if (resolved == null) {
                return false;
            }
            if (!LintIdeUtils.appendJvmTypeName(buffer, resolved)) {
                return false;
            }
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(JVMNameUtil.getPrimitiveSignature((String)psiType.getCanonicalText()));
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public static List<File> getResourceDirectories(@NotNull AndroidFacet facet) {
        AndroidModel androidModel;
        if (facet.requiresAndroidModel() && (androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel()) != null) {
            ArrayList<File> resDirectories = new ArrayList<File>();
            List<SourceProvider> sourceProviders = androidModel.getActiveSourceProviders();
            for (SourceProvider provider : sourceProviders) {
                for (File file : provider.getResDirectories()) {
                    if (!file.isDirectory()) continue;
                    resDirectories.add(file);
                }
            }
            return resDirectories;
        }
        return new ArrayList<File>(facet.getMainSourceProvider().getResDirectories());
    }

    public static boolean isApiLevelAtLeast(PsiFile file, int minApiLevel, boolean defaultValue) {
        AndroidFacet facet;
        if (file != null && (facet = AndroidFacet.getInstance((PsiElement)file)) != null && !facet.isDisposed()) {
            AndroidModuleInfo info = AndroidModuleInfo.getInstance(facet);
            return info.getMinSdkVersion().getApiLevel() >= minApiLevel;
        }
        return defaultValue;
    }
}

