/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.LongEpochMessageFormatter;
import com.android.tools.idea.logcat.LongMessageFormatter;
import com.android.tools.idea.logcat.MessageFormatter;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import java.time.ZoneId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogcatFormatter
extends DefaultLogFormatter {
    private static final String FULL_FORMAT = AndroidLogcatFormatter.createCustomFormat(true, true, true, true);
    @NonNls
    private static final Pattern CONTINUATION_PATTERN = Pattern.compile("^\\+ (.*)$");
    public static final CharSequence CONTINUATION_INDENT = "    ";
    private final MessageFormatter myLongEpochFormatter;
    private final MessageFormatter myLongFormatter;
    private final AndroidLogcatPreferences myPreferences;

    public AndroidLogcatFormatter(@NotNull ZoneId timeZone, @NotNull AndroidLogcatPreferences preferences) {
        this.myLongEpochFormatter = new LongEpochMessageFormatter(preferences, timeZone);
        this.myLongFormatter = new LongMessageFormatter();
        this.myPreferences = preferences;
    }

    @NotNull
    String formatMessageFull(@NotNull LogCatHeader header, @NotNull String message2) {
        return this.formatMessage(FULL_FORMAT, header, message2);
    }

    @NotNull
    public static String formatContinuation(@NotNull String message2) {
        return String.format("+ %s", message2);
    }

    @NotNull
    public static String createCustomFormat(boolean showTime, boolean showPid, boolean showPackage, boolean showTag) {
        StringBuilder builder = new StringBuilder();
        if (showTime) {
            builder.append("%1$s ");
        }
        if (showPid) {
            builder.append("%2$s").append(showPackage ? (char)'/' : ' ');
        }
        if (showPackage) {
            builder.append("%3$s ");
        }
        builder.append("%4$c");
        if (showTag) {
            builder.append("/%5$s");
        }
        builder.append(": %6$s");
        return builder.toString();
    }

    @NotNull
    public String formatMessage(@NotNull String format, @NotNull LogCatHeader header, @NotNull String message2) {
        if (header.getTimestamp() == null) {
            return this.myLongEpochFormatter.format(format, header, message2);
        }
        if (header.getTimestampInstant() == null) {
            return this.myLongFormatter.format(format, header, message2);
        }
        throw new AssertionError(header);
    }

    @NotNull
    LogCatMessage parseMessage(@NotNull String message2) {
        LogCatMessage result2 = this.tryParseMessage(message2);
        if (result2 == null) {
            throw new IllegalArgumentException("Invalid message doesn't match expected logcat pattern: " + message2);
        }
        return result2;
    }

    @Nullable
    LogCatMessage tryParseMessage(@NotNull String message2) {
        LogCatMessage logcatMessage = this.myLongEpochFormatter.tryParse(message2);
        if (logcatMessage != null) {
            return logcatMessage;
        }
        logcatMessage = this.myLongFormatter.tryParse(message2);
        if (logcatMessage != null) {
            return logcatMessage;
        }
        return null;
    }

    @Nullable
    public static String tryParseContinuation(@NotNull String msg) {
        Matcher matcher = CONTINUATION_PATTERN.matcher(msg);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public String formatPrefix(String prefix) {
        if (prefix.isEmpty()) {
            return prefix;
        }
        String[] lines = prefix.split("\n");
        StringBuilder sb = new StringBuilder(prefix.length() + (lines.length - 1) * CONTINUATION_INDENT.length());
        for (String line : lines) {
            sb.append(this.formatMessage(line));
            sb.append('\n');
        }
        return sb.toString();
    }

    @NotNull
    public String formatMessage(@NotNull String message2) {
        String continuation = AndroidLogcatFormatter.tryParseContinuation(message2);
        if (continuation != null) {
            return CONTINUATION_INDENT + continuation;
        }
        LogCatMessage logcatMessage = this.tryParseMessage(message2);
        if (logcatMessage == null || this.myPreferences.LOGCAT_FORMAT_STRING.isEmpty()) {
            return message2;
        }
        return this.formatMessage(logcatMessage);
    }

    @NotNull
    String formatMessage(@NotNull LogCatMessage message2) {
        String format = this.myPreferences.LOGCAT_FORMAT_STRING.isEmpty() ? FULL_FORMAT : this.myPreferences.LOGCAT_FORMAT_STRING;
        return this.formatMessage(format, message2.getHeader(), message2.getMessage());
    }
}

