/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatLongEpochMessageParser;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatMessageParser;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.StackTraceExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogcatReceiver
extends AndroidOutputReceiver
implements Disposable {
    private static final String STACK_TRACE_LINE_PREFIX = StringUtil.repeatSymbol((char)' ', (int)4);
    private static final String STACK_TRACE_CAUSE_LINE_PREFIX = Character.toString(' ');
    private static final Pattern CARRIAGE_RETURN = Pattern.compile("\r", 16);
    private final LogCatMessageParser myLongEpochParser = new LogCatLongEpochMessageParser();
    private final LogCatMessageParser myLongParser = new LogCatMessageParser();
    private final IDevice myDevice;
    private final StackTraceExpander myStackTraceExpander;
    private final AndroidLogcatService.LogcatListener myLogcatListener;
    private int myDelayedNewlineCount;
    @Nullable
    private LogCatHeader myActiveHeader;
    private int myLineIndex;
    private volatile boolean myCanceled;

    AndroidLogcatReceiver(@NotNull IDevice device, @NotNull AndroidLogcatService.LogcatListener listener2) {
        this.myDevice = device;
        this.myStackTraceExpander = new StackTraceExpander(STACK_TRACE_LINE_PREFIX, STACK_TRACE_CAUSE_LINE_PREFIX);
        this.myLogcatListener = listener2;
    }

    @Override
    public void processNewLine(@NotNull String line) {
        if ((line = CARRIAGE_RETURN.matcher(line).replaceAll("")).isEmpty()) {
            ++this.myDelayedNewlineCount;
            return;
        }
        LogCatHeader header = this.myLongEpochParser.processLogHeader(line, this.myDevice);
        if (header == null) {
            header = this.myLongParser.processLogHeader(line, this.myDevice);
        }
        if (header != null) {
            this.myStackTraceExpander.reset();
            this.myActiveHeader = header;
            this.myLineIndex = 0;
            this.myDelayedNewlineCount = 0;
        } else if (this.myActiveHeader != null) {
            if (this.myDelayedNewlineCount > 0 && this.myLineIndex == 0) {
                this.myDelayedNewlineCount = 0;
            } else {
                this.processAnyDelayedNewlines(this.myActiveHeader);
            }
            for (String processedLine : this.myStackTraceExpander.process(line)) {
                this.notifyLine(this.myActiveHeader, processedLine);
            }
        }
    }

    void notifyLine(@NotNull LogCatHeader header, @NotNull String line) {
        this.myLogcatListener.onLogLineReceived(new LogCatMessage(header, line));
        ++this.myLineIndex;
    }

    private void processAnyDelayedNewlines(@NotNull LogCatHeader header) {
        if (this.myDelayedNewlineCount == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.myDelayedNewlineCount; ++i2) {
            this.notifyLine(header, "");
        }
        this.myDelayedNewlineCount = 0;
    }

    public boolean isCancelled() {
        return this.myCanceled;
    }

    public void dispose() {
        this.cancel();
    }

    public void cancel() {
        this.myCanceled = true;
    }

    int getDelayedNewlineCount() {
        return this.myDelayedNewlineCount;
    }
}

