/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.run.LoggingReceiver;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public final class AndroidLogcatService
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    private final Map<IDevice, AndroidLogcatReceiver> myLogReceivers = new HashMap<IDevice, AndroidLogcatReceiver>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, LogcatBuffer> myLogBuffers = new HashMap<IDevice, LogcatBuffer>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, ExecutorService> myExecutors = new HashMap<IDevice, ExecutorService>();
    @GuardedBy(value="myLock")
    private final Multimap<IDevice, ListenerConnector> myDeviceToListenerMultimap = ArrayListMultimap.create();

    private static Logger getLog() {
        return Logger.getInstance(AndroidLogcatService.class);
    }

    @NotNull
    public static AndroidLogcatService getInstance() {
        return (AndroidLogcatService)ServiceManager.getService(AndroidLogcatService.class);
    }

    AndroidLogcatService() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReceiving(@NotNull IDevice device) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                return;
            }
            this.connect(device);
            AndroidLogcatReceiver receiver = this.newAndroidLogcatReceiver(device);
            this.myLogReceivers.put(device, receiver);
            this.myLogBuffers.put(device, new LogcatBuffer());
            this.myExecutors.get(device).submit(() -> AndroidLogcatService.executeLogcat((IShellEnabledDevice)device, receiver));
        }
    }

    @NotNull
    private AndroidLogcatReceiver newAndroidLogcatReceiver(final @NotNull IDevice device) {
        return new AndroidLogcatReceiver(device, new LogcatListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLogLineReceived(@NotNull LogCatMessage line) {
                ImmutableList connectors;
                Object object = AndroidLogcatService.this.myLock;
                synchronized (object) {
                    connectors = ImmutableList.copyOf((Collection)AndroidLogcatService.this.myDeviceToListenerMultimap.get((Object)device));
                    LogcatBuffer buffer = (LogcatBuffer)AndroidLogcatService.this.myLogBuffers.get(device);
                    if (buffer != null) {
                        buffer.addMessage(line);
                    }
                }
                connectors.forEach(connector -> connector.onLogLineReceived(line));
            }
        });
    }

    private static void executeLogcat(@NotNull IShellEnabledDevice device, @NotNull AndroidLogcatReceiver receiver) {
        try {
            AndroidLogcatService.execute(device, AndroidLogcatService.supportsEpochFormatModifier(device) ? "logcat -v long -v epoch" : "logcat -v long", receiver, Duration.ZERO);
        }
        catch (Throwable throwable) {
            AndroidLogcatService.getLog().warn(throwable);
            String app = IdeInfo.getInstance().isAndroidStudio() ? "com.android.studio" : "com.jetbrains.idea";
            receiver.notifyLine(new LogCatHeader(Log.LogLevel.ERROR, 0, 0, app, "AndroidLogcatService", Instant.now()), throwable.toString());
        }
    }

    private static boolean supportsEpochFormatModifier(@NotNull IShellEnabledDevice device) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        LogcatHelpReceiver receiver = new LogcatHelpReceiver();
        device.executeShellCommand("logcat --help", (IShellOutputReceiver)receiver, 10L, TimeUnit.SECONDS);
        return receiver.mySupportsEpochFormatModifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(@NotNull IDevice device) {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myExecutors.containsKey(device)) {
                ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("logcat-" + device.getName()).build();
                this.myExecutors.put(device, Executors.newSingleThreadExecutor(factory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(@NotNull IDevice device) {
        Object object = this.myLock;
        synchronized (object) {
            this.stopReceiving(device);
            this.myExecutors.remove(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReceiving(@NotNull IDevice device) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                this.myLogReceivers.get(device).cancel();
                this.myLogReceivers.remove(device);
                this.myLogBuffers.remove(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogcat(@NotNull IDevice device, @NotNull Project project) {
        Object object = this.myLock;
        synchronized (object) {
            ExecutorService executor = this.myExecutors.get(device);
            if (executor == null) {
                this.notifyThatLogcatWasCleared(device);
                return;
            }
            this.stopReceiving(device);
            executor.submit(() -> {
                try {
                    AndroidLogcatService.execute((IShellEnabledDevice)device, "logcat -c", new LoggingReceiver(AndroidLogcatService.getLog()), Duration.ofSeconds(5L));
                }
                catch (Exception exception) {
                    AndroidLogcatService.getLog().warn((Throwable)exception);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        String title = AndroidBundle.message("android.logcat.error.dialog.title", new Object[0]);
                        Messages.showErrorDialog((Project)project, (String)exception.toString(), (String)title);
                    });
                }
                this.notifyThatLogcatWasCleared(device);
            });
            this.startReceiving(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThatLogcatWasCleared(@NotNull IDevice device) {
        ImmutableList connectors;
        Object object = this.myLock;
        synchronized (object) {
            connectors = ImmutableList.copyOf((Collection)this.myDeviceToListenerMultimap.get((Object)device));
        }
        connectors.forEach(ListenerConnector::onCleared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener2, boolean addOldLogs) {
        Object object = this.myLock;
        synchronized (object) {
            ImmutableList oldMessages = addOldLogs && this.myLogBuffers.containsKey(device) ? this.myLogBuffers.get(device).getMessages() : ImmutableList.of();
            ListenerConnector listenerConnector = new ListenerConnector(listener2, (Collection<LogCatMessage>)oldMessages);
            this.myDeviceToListenerMultimap.put((Object)device, (Object)listenerConnector);
            if (device.isOnline()) {
                this.startReceiving(device);
            }
            if (!oldMessages.isEmpty()) {
                ExecutorService executor = this.myExecutors.get(device);
                assert (executor != null);
                executor.submit(() -> listenerConnector.processBacklog());
            }
        }
    }

    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener2) {
        this.addListener(device, listener2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull IDevice device, @NotNull LogcatListener listener2) {
        Object object = this.myLock;
        synchronized (object) {
            Collection connectors = this.myDeviceToListenerMultimap.get((Object)device);
            if (connectors.isEmpty()) {
                return;
            }
            Iterator iter = connectors.iterator();
            while (iter.hasNext()) {
                ListenerConnector connector = (ListenerConnector)iter.next();
                if (!connector.isConnectedTo(listener2)) continue;
                connector.disconnectListener();
                iter.remove();
                break;
            }
            if (connectors.isEmpty()) {
                this.stopReceiving(device);
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device.isOnline()) {
            this.startReceiving(device);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        this.disconnect(device);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device.isOnline()) {
            this.startReceiving(device);
        } else {
            this.disconnect(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        Object object = this.myLock;
        synchronized (object) {
            for (AndroidLogcatReceiver receiver : this.myLogReceivers.values()) {
                receiver.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Disposer.dispose((Disposable)this);
        Object object = this.myLock;
        synchronized (object) {
            this.myExecutors.values().forEach(executor -> {
                try {
                    executor.shutdownNow();
                    executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    AndroidLogcatService.getLog().info("Error shutting down executor", (Throwable)e);
                }
            });
        }
    }

    private static void execute(@NotNull IShellEnabledDevice device, @NotNull String command, @NotNull AndroidOutputReceiver receiver, @NotNull Duration duration) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        device.executeShellCommand(command, (IShellOutputReceiver)receiver, duration.toMillis(), TimeUnit.MILLISECONDS);
        if (receiver.isCancelled()) {
            return;
        }
        receiver.invalidate();
    }

    private static final class LogcatHelpReceiver
    extends MultiLineReceiver {
        private boolean mySupportsEpochFormatModifier;
        private boolean myCancelled;

        private LogcatHelpReceiver() {
        }

        public void processNewLines(@NotNull String[] lines) {
            if (this.mySupportsEpochFormatModifier) {
                this.myCancelled = true;
                return;
            }
            this.mySupportsEpochFormatModifier = Arrays.stream(lines).anyMatch(line -> line.contains("epoch"));
        }

        public boolean isCancelled() {
            return this.myCancelled;
        }
    }

    public static interface LogcatListener {
        default public void onLogLineReceived(@NotNull LogCatMessage line) {
        }

        default public void onCleared() {
        }
    }

    private static class ListenerConnector
    implements LogcatListener {
        @GuardedBy(value="myListenerLock")
        @Nullable
        private LogcatListener myListener;
        @GuardedBy(value="myBacklogLock")
        @Nullable
        private Queue<LogCatMessage> myBacklog;
        @NotNull
        private final Object myListenerLock = new Object();
        @NotNull
        private final Object myBacklogLock = new Object();

        ListenerConnector(@NotNull LogcatListener listener2, @NotNull Collection<LogCatMessage> messageBacklog) {
            this.myListener = listener2;
            this.myBacklog = messageBacklog.isEmpty() ? null : new ArrayDeque<LogCatMessage>(messageBacklog);
        }

        @Override
        public void onLogLineReceived(@NotNull LogCatMessage message2) {
            this.processBacklog();
            this.dispatchMessage(message2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCleared() {
            Object object = this.myBacklogLock;
            synchronized (object) {
                this.myBacklog = null;
            }
            object = this.myListenerLock;
            synchronized (object) {
                if (this.myListener != null) {
                    this.myListener.onCleared();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isConnectedTo(@NotNull LogcatListener listener2) {
            Object object = this.myListenerLock;
            synchronized (object) {
                return listener2 == this.myListener;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnectListener() {
            Object object = this.myListenerLock;
            synchronized (object) {
                this.myListener = null;
            }
            object = this.myBacklogLock;
            synchronized (object) {
                this.myBacklog = null;
            }
        }

        void processBacklog() {
            LogCatMessage message2;
            while ((message2 = this.getMessageFromBacklog()) != null) {
                this.dispatchMessage(message2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchMessage(@NotNull LogCatMessage message2) {
            Object object = this.myListenerLock;
            synchronized (object) {
                if (this.myListener != null) {
                    this.myListener.onLogLineReceived(message2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private LogCatMessage getMessageFromBacklog() {
            Object object = this.myBacklogLock;
            synchronized (object) {
                if (this.myBacklog == null) {
                    return null;
                }
                LogCatMessage message2 = this.myBacklog.remove();
                if (this.myBacklog.isEmpty()) {
                    this.myBacklog = null;
                }
                return message2;
            }
        }
    }

    private static class LogcatBuffer {
        private int myBufferSize;
        private final LinkedList<LogCatMessage> myMessages = new LinkedList();

        private LogcatBuffer() {
        }

        public void addMessage(@NotNull LogCatMessage message2) {
            this.myMessages.add(message2);
            this.myBufferSize += message2.getMessage().length();
            if (ConsoleBuffer.useCycleBuffer()) {
                while (this.myBufferSize > ConsoleBuffer.getCycleBufferSize()) {
                    this.myBufferSize -= this.myMessages.removeFirst().getMessage().length();
                }
            }
        }

        @NotNull
        public List<LogCatMessage> getMessages() {
            return this.myMessages;
        }
    }
}

