/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.MessageFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LongMessageFormatter
implements MessageFormatter {
    private static final Pattern DATE_TIME = Pattern.compile("\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d.\\d\\d\\d");
    private static final Pattern HEADER_MESSAGE = Pattern.compile("^(" + DATE_TIME + ") +(" + PROCESS_ID + ")-(" + THREAD_ID + ")/(" + PACKAGE + ") (" + PRIORITY + ")/(" + TAG + "): (" + MESSAGE + ")$");

    LongMessageFormatter() {
    }

    @Override
    @NotNull
    public String format(@NotNull String format, @NotNull LogCatHeader header, @NotNull String message2) {
        LogCatTimestamp dateTime = header.getTimestamp();
        String processIdThreadId = header.getPid() + "-" + header.getTid();
        Character priority = Character.valueOf(header.getLogLevel().getPriorityLetter());
        String tag = header.getTag().replace(' ', '\u00a0');
        return String.format(Locale.ROOT, format, dateTime, processIdThreadId, header.getAppName(), priority, tag, message2);
    }

    @Override
    @Nullable
    public LogCatMessage tryParse(@NotNull String message2) {
        Matcher matcher = HEADER_MESSAGE.matcher(message2);
        if (!matcher.matches()) {
            return null;
        }
        Log.LogLevel priority = Log.LogLevel.getByLetterString((String)matcher.group(5));
        assert (priority != null);
        int processId = Integer.parseInt(matcher.group(2));
        int threadId = Integer.parseInt(matcher.group(3));
        String tag = matcher.group(6);
        LogCatTimestamp timestamp = LogCatTimestamp.fromString((String)matcher.group(1));
        LogCatHeader header = new LogCatHeader(priority, processId, threadId, matcher.group(4), tag, timestamp);
        return new LogCatMessage(header, matcher.group(7));
    }
}

