/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleInfo
extends AndroidFacetScopedService {
    private static final Key<AndroidModuleInfo> KEY = Key.create((String)AndroidModuleInfo.class.getName());

    @NotNull
    public static AndroidModuleInfo getInstance(@NotNull AndroidFacet facet) {
        AndroidModuleInfo androidModuleInfo = (AndroidModuleInfo)facet.getUserData(KEY);
        if (androidModuleInfo == null) {
            Module baseFeature;
            if (((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4 && (baseFeature = InstantApps.findBaseFeature(facet)) != null) {
                androidModuleInfo = AndroidModuleInfo.getInstance(baseFeature);
            }
            if (androidModuleInfo == null) {
                androidModuleInfo = new AndroidModuleInfo(facet);
            }
            facet.putUserData(KEY, androidModuleInfo);
        }
        return androidModuleInfo;
    }

    @Nullable
    public static AndroidModuleInfo getInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? AndroidModuleInfo.getInstance(facet) : null;
    }

    public static void setInstanceForTest(@NotNull AndroidFacet facet, @Nullable AndroidModuleInfo androidModuleInfo) {
        facet.putUserData(KEY, androidModuleInfo);
    }

    private AndroidModuleInfo(@NotNull AndroidFacet facet) {
        super(facet);
    }

    public int getModuleMinApi() {
        return this.getMinSdkVersion().getApiLevel();
    }

    @Nullable
    public String getPackage() {
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
        if (androidModel != null) {
            return androidModel.getApplicationId();
        }
        return MergedManifestManager.getSnapshot(facet).getApplicationId();
    }

    @NotNull
    public AndroidVersion getRuntimeMinSdkVersion() {
        AndroidVersion minSdkVersion2;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
        if (androidModel != null && (minSdkVersion2 = androidModel.getRuntimeMinSdkVersion()) != null) {
            return minSdkVersion2;
        }
        return MergedManifestManager.getSnapshot(facet).getMinSdkVersion();
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion minSdkVersion2;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
        if (androidModel != null && (minSdkVersion2 = androidModel.getMinSdkVersion()) != null) {
            return minSdkVersion2;
        }
        return MergedManifestManager.getSnapshot(facet).getMinSdkVersion();
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion targetSdkVersion2;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
        if (androidModel != null && (targetSdkVersion2 = androidModel.getTargetSdkVersion()) != null) {
            return targetSdkVersion2;
        }
        return MergedManifestManager.getSnapshot(facet).getTargetSdkVersion();
    }

    @Nullable
    public AndroidVersion getBuildSdkVersion() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.getModule());
        if (platform != null) {
            return platform.getApiVersion();
        }
        return null;
    }

    @Nullable
    public Boolean isDebuggable() {
        Boolean debuggable2;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
        if (androidModel != null && (debuggable2 = androidModel.isDebuggable()) != null) {
            return debuggable2;
        }
        return MergedManifestManager.getSnapshot(facet).getApplicationDebuggable();
    }

    @NotNull
    public static AndroidVersion getTargetSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.getInstance(facet.getModule())) != null) {
            return moduleInfo.getTargetSdkVersion();
        }
        return AndroidVersion.DEFAULT;
    }

    @NotNull
    public static AndroidVersion getMinSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.getInstance(facet.getModule())) != null) {
            return moduleInfo.getMinSdkVersion();
        }
        return AndroidVersion.DEFAULT;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        facet.putUserData(KEY, null);
    }
}

