/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.annotations.concurrency.Slow;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavor;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestContributors;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.project.SyncTimestampUtil;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import gnu.trove.TObjectLongHashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

final class MergedManifestInfo {
    private static final Logger LOG = Logger.getInstance(MergedManifestInfo.class);
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final Document myDomDocument;
    @Nullable
    private final ImmutableList<VirtualFile> myFiles;
    @NotNull
    private final TObjectLongHashMap<VirtualFile> myLastModifiedMap;
    private final long mySyncTimestamp;
    @Nullable
    private final ImmutableList<MergingReport.Record> myLoggingRecords;
    @Nullable
    private final Actions myActions;

    private MergedManifestInfo(@NotNull AndroidFacet facet, @Nullable Document domDocument, @NotNull TObjectLongHashMap<VirtualFile> lastModifiedMap, long syncTimestamp, @Nullable ImmutableList<MergingReport.Record> loggingRecords, @Nullable Actions actions2) {
        this.myFacet = facet;
        this.myDomDocument = domDocument;
        this.myLastModifiedMap = lastModifiedMap;
        this.mySyncTimestamp = syncTimestamp;
        this.myLoggingRecords = loggingRecords;
        this.myActions = actions2;
        ImmutableList.Builder files2 = ImmutableList.builder();
        lastModifiedMap.forEachKey(file -> {
            files2.add(file);
            return true;
        });
        this.myFiles = files2.build();
    }

    @Slow
    @NotNull
    public static MergedManifestInfo create(@NotNull AndroidFacet facet) {
        PsiFile psiFile;
        Project project = facet.getModule().getProject();
        long syncTimestamp = SyncTimestampUtil.getLastSyncTimestamp(project);
        MergedManifestContributors contributors = MergedManifestContributors.determineFor(facet);
        TObjectLongHashMap<VirtualFile> lastModified = MergedManifestInfo.getFileModificationStamps(project, contributors.allFiles);
        Document document = null;
        ImmutableList<MergingReport.Record> loggingRecords = null;
        Actions actions2 = null;
        ParsedMergeResult result2 = MergedManifestInfo.mergeManifests(facet, contributors);
        if (result2 != null) {
            document = result2.document;
            loggingRecords = result2.loggingRecords;
            actions2 = result2.actions;
        }
        if (document == null && contributors.primaryManifest != null && (psiFile = PsiManager.getInstance((Project)project).findFile(contributors.primaryManifest)) != null) {
            document = XmlUtils.parseDocumentSilently((String)psiFile.getText(), (boolean)true);
        }
        return new MergedManifestInfo(facet, document, lastModified, syncTimestamp, loggingRecords, actions2);
    }

    @Slow
    @Nullable
    private static ParsedMergeResult mergeManifests(@NotNull AndroidFacet facet, @NotNull MergedManifestContributors manifests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = facet.getModule().getProject();
        if (project.isDisposed() || manifests.primaryManifest == null) {
            return null;
        }
        try {
            MergingReport mergingReport = MergedManifestInfo.getMergedManifest(facet, manifests.primaryManifest, manifests.flavorAndBuildTypeManifests, manifests.libraryManifests, manifests.navigationFiles);
            XmlDocument doc = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            if (doc != null) {
                return new ParsedMergeResult(doc.getXml(), (ImmutableList<MergingReport.Record>)mergingReport.getLoggingRecords(), mergingReport.getActions());
            }
            LOG.warn("getMergedManifest failed " + mergingReport.getReportString());
            return new ParsedMergeResult(null, (ImmutableList<MergingReport.Record>)mergingReport.getLoggingRecords(), mergingReport.getActions());
        }
        catch (ManifestMerger2.MergeFailureException ex) {
            if (ex.getCause() instanceof ProcessCanceledException) {
                return null;
            }
            if (ex.getCause() instanceof SAXParseException) {
                return null;
            }
            LOG.warn("getMergedManifest exception", (Throwable)ex);
            return null;
        }
    }

    public boolean isUpToDate() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (Disposer.isDisposed((Disposable)this.myFacet)) {
            return true;
        }
        MergedManifestContributors manifests = MergedManifestContributors.determineFor(this.myFacet);
        if (manifests.primaryManifest == null) {
            return true;
        }
        long lastSyncTimestamp = SyncTimestampUtil.getLastSyncTimestamp(this.myFacet.getModule().getProject());
        if (this.myDomDocument == null || this.mySyncTimestamp != lastSyncTimestamp) {
            return false;
        }
        return this.myLastModifiedMap.equals(MergedManifestInfo.getFileModificationStamps(this.myFacet.getModule().getProject(), manifests.allFiles));
    }

    @NotNull
    private static TObjectLongHashMap<VirtualFile> getFileModificationStamps(@NotNull Project project, @NotNull Iterable<VirtualFile> files2) {
        TObjectLongHashMap modificationStamps = new TObjectLongHashMap();
        for (VirtualFile file : files2) {
            modificationStamps.put((Object)file, MergedManifestInfo.getFileModificationStamp(project, file));
        }
        return modificationStamps;
    }

    private static long getFileModificationStamp(@NotNull Project project, @NotNull VirtualFile file) {
        try {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            return psiFile == null ? file.getModificationStamp() : psiFile.getModificationStamp();
        }
        catch (ProcessCanceledException ignore) {
            return 0L;
        }
    }

    @Nullable
    public Document getXmlDocument() {
        return this.myDomDocument;
    }

    @Nullable
    public ImmutableList<VirtualFile> getFiles() {
        return this.myFiles;
    }

    @NotNull
    public ImmutableList<MergingReport.Record> getLoggingRecords() {
        return this.myLoggingRecords == null ? ImmutableList.of() : this.myLoggingRecords;
    }

    @Nullable
    public Actions getActions() {
        return this.myActions;
    }

    @Slow
    @NotNull
    static MergingReport getMergedManifest(@NotNull AndroidFacet facet, final @NotNull VirtualFile primaryManifestFile, @NotNull List<VirtualFile> flavorAndBuildTypeManifests, final @NotNull List<VirtualFile> libManifests, @NotNull List<VirtualFile> navigationFiles) throws ManifestMerger2.MergeFailureException {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final File mainManifestFile = VfsUtilCore.virtualToIoFile((VirtualFile)primaryManifestFile);
        ILogger logger = NullLogger.getLogger();
        ManifestMerger2.MergeType mergeType = ((AndroidFacetConfiguration)facet.getConfiguration()).isAppOrFeature() ? ManifestMerger2.MergeType.APPLICATION : ManifestMerger2.MergeType.LIBRARY;
        AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
        AndroidModuleModel gradleModel = AndroidModuleModel.get(facet);
        ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifestFile, (ILogger)logger, (ManifestMerger2.MergeType)mergeType);
        manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.SKIP_BLAME, ManifestMerger2.Invoker.Feature.SKIP_XML_STRING});
        manifestMergerInvoker.addFlavorAndBuildTypeManifests(VfsUtilCore.virtualToIoFiles(flavorAndBuildTypeManifests).toArray(new File[0]));
        manifestMergerInvoker.addNavigationFiles((Iterable)VfsUtilCore.virtualToIoFiles(navigationFiles));
        ArrayList<Pair> libraryManifests = new ArrayList<Pair>();
        for (VirtualFile file : libManifests) {
            libraryManifests.add(Pair.of((Object)file.getName(), (Object)VfsUtilCore.virtualToIoFile((VirtualFile)file)));
        }
        manifestMergerInvoker.addBundleManifests(libraryManifests);
        if (androidModel != null) {
            String packageOverride;
            Integer versionCode2;
            AndroidVersion targetSdkVersion2;
            AndroidVersion minSdkVersion2 = androidModel.getMinSdkVersion();
            if (minSdkVersion2 != null) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion2.getApiString());
            }
            if ((targetSdkVersion2 = androidModel.getTargetSdkVersion()) != null) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion2.getApiString());
            }
            if ((versionCode2 = androidModel.getVersionCode()) != null && versionCode2 > 0) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.VERSION_CODE, String.valueOf(versionCode2));
            }
            if (!Strings.isNullOrEmpty((String)(packageOverride = androidModel.getApplicationId()))) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.PACKAGE, packageOverride);
            }
        }
        if (gradleModel != null) {
            BuildTypeContainer buildTypeContainer = gradleModel.findBuildType(gradleModel.getSelectedVariant().getBuildType());
            assert (buildTypeContainer != null);
            BuildType buildType = buildTypeContainer.getBuildType();
            ProductFlavor mergedProductFlavor = gradleModel.getSelectedVariant().getMergedFlavor();
            HashMap placeHolders = new HashMap(mergedProductFlavor.getManifestPlaceholders());
            placeHolders.putAll(buildType.getManifestPlaceholders());
            manifestMergerInvoker.setPlaceHolderValues(placeHolders);
            Integer maxSdkVersion2 = mergedProductFlavor.getMaxSdkVersion();
            if (maxSdkVersion2 != null) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.MAX_SDK_VERSION, maxSdkVersion2.toString());
            }
            String versionName2 = mergedProductFlavor.getVersionName();
            String flavorVersionNameSuffix = null;
            if (gradleModel.getFeatures().isProductFlavorVersionSuffixSupported()) {
                flavorVersionNameSuffix = MergedManifestInfo.getVersionNameSuffix((BaseConfig)mergedProductFlavor);
            }
            String versionNameSuffix2 = Joiner.on((String)"").skipNulls().join((Object)flavorVersionNameSuffix, (Object)MergedManifestInfo.getVersionNameSuffix((BaseConfig)buildType), new Object[0]);
            if (!Strings.isNullOrEmpty((String)versionName2) || !Strings.isNullOrEmpty((String)versionNameSuffix2)) {
                Manifest manifest;
                if (Strings.isNullOrEmpty((String)versionName2) && (manifest = facet.getManifest()) != null) {
                    versionName2 = manifest.getXmlTag().getAttributeValue("versionName", "http://schemas.android.com/apk/res/android");
                }
                if (!Strings.isNullOrEmpty((String)versionNameSuffix2)) {
                    versionName2 = Strings.nullToEmpty((String)versionName2) + versionNameSuffix2;
                }
                manifestMergerInvoker.setOverride(ManifestSystemProperty.VERSION_NAME, versionName2);
            }
        }
        if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
            manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
        }
        final Module module = facet.getModule();
        final Project project = module.getProject();
        manifestMergerInvoker.withFileStreamProvider(new ManifestMerger2.FileStreamProvider(){

            protected InputStream getInputStream(@NotNull File file) throws FileNotFoundException {
                MergedManifestSnapshot manifest;
                Document document;
                Module moduleContainingManifest;
                VirtualFile vFile = file == mainManifestFile ? primaryManifestFile : VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (vFile == null) {
                    return new ByteArrayInputStream("<manifest/>".getBytes(StandardCharsets.UTF_8));
                }
                if (!libManifests.isEmpty() && (moduleContainingManifest = this.getAndroidModuleForManifest(vFile)) != null && !module.equals(moduleContainingManifest) && (document = (manifest = MergedManifestManager.getSnapshot(moduleContainingManifest)).getDocument()) != null) {
                    String text = XmlUtils.toXml((Node)document);
                    return new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
                }
                try {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                    if (psiFile != null) {
                        String text = psiFile.getText();
                        return new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                return super.getInputStream(file);
            }

            @Nullable
            private Module getAndroidModuleForManifest(@NotNull VirtualFile vFile) {
                for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                    AndroidFacet androidFacet = AndroidFacet.getInstance(m);
                    if (androidFacet == null) continue;
                    List<VirtualFile> manifestFiles = IdeaSourceProvider.getManifestFiles(androidFacet);
                    for (VirtualFile manifestFile : manifestFiles) {
                        if (!vFile.equals(manifestFile)) continue;
                        return m;
                    }
                }
                return null;
            }
        });
        return manifestMergerInvoker.merge();
    }

    @Deprecated
    @Nullable
    private static String getVersionNameSuffix(@NotNull BaseConfig config) {
        try {
            return config.getVersionNameSuffix();
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("Method 'getVersionNameSuffix' not found", (Throwable)e);
            return null;
        }
    }

    private static class ParsedMergeResult {
        @Nullable
        final Document document;
        @NotNull
        final ImmutableList<MergingReport.Record> loggingRecords;
        @NotNull
        final Actions actions;

        ParsedMergeResult(@Nullable Document document, @NotNull ImmutableList<MergingReport.Record> loggingRecords, @NotNull Actions actions2) {
            this.document = document;
            this.loggingRecords = loggingRecords;
            this.actions = actions2;
        }
    }
}

