/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.model.MergedManifestInfo;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.model.MergedManifestSnapshotFactory;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergedManifestManager {
    private static final long REFRESH_CHECK_INTERVAL_MS = 50L;
    private static final Key<MergedManifestSnapshot> KEY = Key.create((String)"manifest.merger.by.module");

    @Slow
    @NotNull
    public static MergedManifestSnapshot getSnapshot(@NotNull Module module, boolean forceRefresh) {
        if (module.isDisposed()) {
            return MergedManifestSnapshotFactory.createEmptyMergedManifestSnapshot(module);
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "Attempt to obtain manifest info from a non Android module: " + module.getName();
        return MergedManifestManager.getSnapshot(facet, forceRefresh);
    }

    @NotNull
    public static MergedManifestSnapshot getSnapshot(@NotNull Module module) {
        return MergedManifestManager.getSnapshot(module, false);
    }

    @Slow
    @VisibleForTesting
    @Nullable
    static MergedManifestSnapshot readSnapshotFromDisk(@NotNull AndroidFacet facet, @Nullable MergedManifestInfo mergedManifestInfo, boolean forceLoad) {
        return (MergedManifestSnapshot)ReadAction.compute(() -> {
            if (!(facet.isDisposed() || !forceLoad && mergedManifestInfo != null && mergedManifestInfo.isUpToDate())) {
                return MergedManifestSnapshotFactory.createMergedManifestSnapshot(facet, MergedManifestInfo.create(facet));
            }
            return null;
        });
    }

    @Slow
    @NotNull
    private static MergedManifestSnapshot getFreshSnapshot(@NotNull AndroidFacet facet, @NotNull MergedManifestSnapshot snapshot) {
        MergedManifestSnapshot newManifestSnapshot;
        MergedManifestInfo mergedManifestInfo;
        long creationTimestamp = snapshot.getCreationTimestamp();
        if (Clock.getTime() - creationTimestamp > 50L && (mergedManifestInfo = snapshot.getMergedManifestInfo()) != null && (newManifestSnapshot = MergedManifestManager.readSnapshotFromDisk(facet, mergedManifestInfo, false)) != null) {
            return newManifestSnapshot;
        }
        return snapshot;
    }

    @Nullable
    public static MergedManifestSnapshot getCachedSnapshot(@NotNull AndroidFacet facet) {
        return (MergedManifestSnapshot)facet.getModule().getUserData(KEY);
    }

    @Slow
    @NotNull
    public static MergedManifestSnapshot getSnapshot(@NotNull AndroidFacet facet, boolean forceRefresh) {
        Module module = facet.getModule();
        if (module.isDisposed()) {
            return MergedManifestSnapshotFactory.createEmptyMergedManifestSnapshot(module);
        }
        MergedManifestSnapshot cachedManifest = MergedManifestManager.getCachedSnapshot(facet);
        if (forceRefresh || cachedManifest == null) {
            MergedManifestInfo file = cachedManifest != null ? cachedManifest.getMergedManifestInfo() : null;
            if ((cachedManifest = MergedManifestManager.readSnapshotFromDisk(facet, file, forceRefresh)) != null) {
                module.putUserData(KEY, (Object)cachedManifest);
            }
        } else {
            cachedManifest = MergedManifestManager.getFreshSnapshot(facet, cachedManifest);
            module.putUserData(KEY, (Object)cachedManifest);
        }
        return cachedManifest != null ? cachedManifest : MergedManifestSnapshotFactory.createEmptyMergedManifestSnapshot(module);
    }

    @Slow
    @NotNull
    public static MergedManifestSnapshot getSnapshot(@NotNull AndroidFacet facet) {
        return MergedManifestManager.getSnapshot(facet, false);
    }
}

