/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlNode;
import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestInfo;
import com.android.tools.idea.model.MergedManifestSnapshotFactory;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.lint.checks.PermissionHolder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class MergedManifestSnapshot {
    private final long myCreationTimeMs = Clock.getTime();
    private final Module myModule;
    @Nullable
    private final String myPackageName;
    @Nullable
    private final String myApplicationId;
    @Nullable
    private final Integer myVersionCode;
    @Nullable
    private final Actions myActions;
    @NotNull
    private final ImmutableList<MergingReport.Record> myLoggingRecords;
    @Nullable
    private String myManifestTheme;
    @NotNull
    private final ImmutableMap<String, ActivityAttributesSnapshot> myAttributes;
    @Nullable
    private final MergedManifestInfo myMergedManifestInfo;
    @NotNull
    private final AndroidVersion myMinSdk;
    @NotNull
    private final AndroidVersion myTargetSdk;
    @Nullable
    private final ResourceValue myAppIcon;
    @Nullable
    private final ResourceValue myAppLabel;
    private final boolean mySupportsRtl;
    @Nullable
    private final Boolean myIsDebuggable;
    @NotNull
    private final ImmutableMap<String, XmlNode.NodeKey> myNodeKeys;
    @Nullable
    private final Document myDocument;
    @NotNull
    private final ImmutableList<VirtualFile> myFiles;
    @NotNull
    private final MergedManifestSnapshotFactory.ModulePermissions myHolder;
    private final boolean myAppHasCode;
    private final ImmutableList<Element> myActivities;
    private final ImmutableList<Element> myActivityAliases;
    private final ImmutableList<Element> myServices;

    MergedManifestSnapshot(@NotNull Module module, @Nullable String packageName, @Nullable String applicationId2, @Nullable Integer versionCode2, @Nullable String manifestTheme, @NotNull ImmutableMap<String, ActivityAttributesSnapshot> activityAttributes, @Nullable MergedManifestInfo mergedManifestInfo, @NotNull AndroidVersion minSdk, @NotNull AndroidVersion targetSdk, @Nullable ResourceValue appIcon, @Nullable ResourceValue appLabel, boolean supportsRtl, @Nullable Boolean isDebuggable, @Nullable Document document, @Nullable ImmutableList<VirtualFile> manifestFiles, @NotNull MergedManifestSnapshotFactory.ModulePermissions permissionsHolder, boolean appHasCode, @NotNull ImmutableList<Element> activities, @NotNull ImmutableList<Element> activityAliases, @NotNull ImmutableList<Element> services, @Nullable Actions actions2, @NotNull ImmutableList<MergingReport.Record> loggingRecords) {
        this.myModule = module;
        this.myPackageName = packageName;
        this.myApplicationId = applicationId2;
        this.myVersionCode = versionCode2;
        this.myManifestTheme = manifestTheme;
        this.myAttributes = activityAttributes;
        this.myMergedManifestInfo = mergedManifestInfo;
        this.myMinSdk = minSdk;
        this.myTargetSdk = targetSdk;
        this.myAppIcon = appIcon;
        this.myAppLabel = appLabel;
        this.mySupportsRtl = supportsRtl;
        this.myIsDebuggable = isDebuggable;
        this.myDocument = document;
        this.myFiles = manifestFiles != null ? manifestFiles : ImmutableList.of();
        this.myHolder = permissionsHolder;
        this.myAppHasCode = appHasCode;
        this.myActivities = activities;
        this.myActivityAliases = activityAliases;
        this.myServices = services;
        this.myLoggingRecords = loggingRecords;
        this.myActions = actions2;
        if (actions2 != null) {
            ImmutableMap.Builder nodeKeysBuilder = ImmutableMap.builder();
            Set keys = this.myActions.getNodeKeys();
            for (XmlNode.NodeKey key : keys) {
                nodeKeysBuilder.put((Object)key.toString(), (Object)key);
            }
            this.myNodeKeys = nodeKeysBuilder.build();
        } else {
            this.myNodeKeys = ImmutableMap.of();
        }
    }

    long getCreationTimestamp() {
        return this.myCreationTimeMs;
    }

    @Nullable
    MergedManifestInfo getMergedManifestInfo() {
        return this.myMergedManifestInfo;
    }

    @Nullable
    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public List<VirtualFile> getManifestFiles() {
        return this.myFiles;
    }

    @Nullable
    public String getPackage() {
        return this.myPackageName;
    }

    @Nullable
    public String getApplicationId() {
        return this.myApplicationId;
    }

    @Nullable
    public Integer getVersionCode() {
        return this.myVersionCode;
    }

    @NotNull
    public Map<String, ActivityAttributesSnapshot> getActivityAttributesMap() {
        return this.myAttributes;
    }

    @Nullable
    public ActivityAttributesSnapshot getActivityAttributes(@NotNull String activity) {
        int index = activity.indexOf(46);
        if (index <= 0 && this.myApplicationId != null && !this.myApplicationId.isEmpty()) {
            activity = this.myApplicationId + (index == -1 ? "." : "") + activity;
        }
        return this.getActivityAttributesMap().get(activity);
    }

    @Nullable
    public String getManifestTheme() {
        return this.myManifestTheme;
    }

    @NotNull
    public String getDefaultTheme(@Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device) {
        AndroidVersion targetSdkVersion2;
        AndroidFacet facet;
        if (this.myManifestTheme != null) {
            return this.myManifestTheme;
        }
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                return "@android:style/Theme.DeviceDefault.Light";
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                return "@style/Theme.Leanback";
            }
        }
        if ((facet = AndroidFacet.getInstance(this.myModule)) == null) {
            return "@android:style/Theme.Material.Light";
        }
        int targetSdk = this.getTargetSdkVersion().getApiLevel();
        AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
        if (androidModel != null && (targetSdkVersion2 = androidModel.getTargetSdkVersion()) != null) {
            targetSdk = targetSdkVersion2.getApiLevel();
        }
        int renderingTargetSdk = targetSdk;
        if (renderingTarget instanceof CompatibilityRenderTarget) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        } else if (renderingTarget != null) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        }
        int apiLevel = Math.min(targetSdk, renderingTargetSdk);
        if (apiLevel >= 21) {
            return "@android:style/Theme.Material.Light";
        }
        if (apiLevel >= 14 || apiLevel >= 11 && screenSize == ScreenSize.XLARGE) {
            return "@android:style/Theme.Holo";
        }
        return "@android:style/Theme";
    }

    @Nullable
    public ResourceValue getApplicationIcon() {
        return this.myAppIcon;
    }

    @Nullable
    public ResourceValue getApplicationLabel() {
        return this.myAppLabel;
    }

    public boolean isRtlSupported() {
        return this.mySupportsRtl;
    }

    @Nullable
    public Boolean getApplicationDebuggable() {
        return this.myIsDebuggable;
    }

    public boolean getApplicationHasCode() {
        return this.myAppHasCode;
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        return this.myTargetSdk;
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        return this.myMinSdk;
    }

    @NotNull
    public PermissionHolder getPermissionHolder() {
        return this.myHolder;
    }

    @NotNull
    public List<Element> getActivities() {
        return this.myActivities;
    }

    @NotNull
    public List<Element> getActivityAliases() {
        return this.myActivityAliases;
    }

    @NotNull
    public List<Element> getServices() {
        return this.myServices;
    }

    @Nullable
    public Element findUsedFeature(@NotNull String name) {
        if (this.myDocument == null) {
            return null;
        }
        for (Node node = this.myDocument.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            if (node.getNodeType() != 1 || !"uses-feature".equals(node.getNodeName()) || !name.equals((element = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public ImmutableList<MergingReport.Record> getLoggingRecords() {
        return this.myMergedManifestInfo != null ? this.myMergedManifestInfo.getLoggingRecords() : ImmutableList.of();
    }

    @Nullable
    public Actions getActions() {
        return this.myActions;
    }

    @Nullable
    public XmlNode.NodeKey getNodeKey(String name) {
        return (XmlNode.NodeKey)this.myNodeKeys.get((Object)name);
    }

    @Nullable
    public Element findActivity(@Nullable String qualifiedName) {
        if (qualifiedName == null || this.myActivities == null) {
            return null;
        }
        return MergedManifestSnapshot.getActivityOrAliasByName(qualifiedName, this.myActivities);
    }

    @Nullable
    public Element findActivityAlias(@Nullable String qualifiedName) {
        if (qualifiedName == null || this.myActivityAliases == null) {
            return null;
        }
        return MergedManifestSnapshot.getActivityOrAliasByName(qualifiedName, this.myActivityAliases);
    }

    @Nullable
    private static Element getActivityOrAliasByName(@NotNull String qualifiedName, @NotNull List<Element> activityOrAliasElements) {
        for (Element activity : activityOrAliasElements) {
            if (!qualifiedName.equals(ActivityLocatorUtils.getQualifiedName(activity))) continue;
            return activity;
        }
        return null;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }
}

