/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestInfo;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.lint.checks.PermissionHolder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MergedManifestSnapshotFactory {
    MergedManifestSnapshotFactory() {
    }

    @Nullable
    private static String getAttributeValue(@NotNull Element element, @Nullable String namespaceUri, @NotNull String attributeName) {
        return Strings.emptyToNull((String)element.getAttributeNS(namespaceUri, attributeName));
    }

    @Nullable
    private static ResourceValue getResourceValue(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull Element element, @Nullable String namespaceUri, @NotNull String attributeName) {
        String value2 = MergedManifestSnapshotFactory.getAttributeValue(element, namespaceUri, attributeName);
        if (value2 == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parse((String)value2);
        ResourceReference reference2 = url == null ? null : url.resolve(namespace, namespacePrefix -> element.lookupNamespaceURI(namespacePrefix));
        return new ManifestResourceValue(namespace, type, attributeName, value2, reference2);
    }

    private static AndroidVersion getApiVersion(@NotNull Element usesSdk, @NotNull String attribute, @NotNull AndroidVersion defaultApiLevel) {
        AndroidVersion version2;
        String valueString = MergedManifestSnapshotFactory.getAttributeValue(usesSdk, "http://schemas.android.com/apk/res/android", attribute);
        if (valueString != null && (version2 = SdkVersionInfo.getVersion((String)valueString, null)) != null) {
            return version2;
        }
        return defaultApiLevel;
    }

    @NotNull
    static MergedManifestSnapshot createEmptyMergedManifestSnapshot(@NotNull Module module) {
        return new MergedManifestSnapshot(module, null, null, null, null, (ImmutableMap<String, ActivityAttributesSnapshot>)ImmutableMap.of(), null, AndroidVersion.DEFAULT, AndroidVersion.DEFAULT, null, null, false, null, null, null, ModulePermissions.NOP_MODULE_PERMISSIONS, false, (ImmutableList<Element>)ImmutableList.of(), (ImmutableList<Element>)ImmutableList.of(), (ImmutableList<Element>)ImmutableList.of(), null, (ImmutableList<MergingReport.Record>)ImmutableList.of());
    }

    @Nullable
    static MergedManifestSnapshot createMergedManifestSnapshot(@NotNull AndroidFacet facet, @NotNull MergedManifestInfo mergedManifestInfo) {
        try {
            Document document = mergedManifestInfo.getXmlDocument();
            if (document == null) {
                return null;
            }
            Element root = document.getDocumentElement();
            if (root == null) {
                return null;
            }
            String appId = MergedManifestSnapshotFactory.getAttributeValue(root, null, "package");
            Manifest manifest = facet.getManifest();
            String packageName = manifest == null ? appId : (String)manifest.getPackage().getValue();
            AaptOptions.Namespacing namespacing = ResourceRepositoryManager.getInstance(facet).getNamespacing();
            ResourceNamespace namespace = namespacing == AaptOptions.Namespacing.DISABLED ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)packageName);
            String versionCodeStr = MergedManifestSnapshotFactory.getAttributeValue(root, "http://schemas.android.com/apk/res/android", "versionCode");
            Integer versionCode2 = null;
            try {
                versionCode2 = versionCodeStr != null ? Integer.valueOf(versionCodeStr) : null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ResourceValue appIcon = null;
            ResourceValue appLabel = null;
            String manifestTheme = null;
            boolean supportsRtl = false;
            Boolean isAppDebuggable = null;
            boolean appHasCode = true;
            ImmutableMap.Builder activityAttributesMapBuilder = ImmutableMap.builder();
            ArrayList<Element> activities = new ArrayList<Element>();
            ArrayList<Element> activityAliases = new ArrayList<Element>(4);
            ArrayList<Element> services = new ArrayList<Element>(4);
            AndroidVersion targetSdk = AndroidVersion.DEFAULT;
            AndroidVersion minSdk = AndroidVersion.DEFAULT;
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)2);
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                String name;
                String protectionLevel;
                Element element;
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                if ("application".equals(nodeName)) {
                    Element application = (Element)node;
                    appIcon = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.DRAWABLE, application, "http://schemas.android.com/apk/res/android", "icon");
                    appLabel = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.STRING, application, "http://schemas.android.com/apk/res/android", "label");
                    manifestTheme = MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "theme");
                    supportsRtl = "true".equals(MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "supportsRtl"));
                    String debuggable2 = MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "debuggable");
                    isAppDebuggable = debuggable2 == null ? null : Boolean.valueOf("true".equals(debuggable2));
                    String hasCode = MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "hasCode");
                    appHasCode = hasCode == null || "true".equals(hasCode);
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() != 1) continue;
                        String childNodeName = child.getNodeName();
                        if ("activity".equals(childNodeName)) {
                            Element element2 = (Element)child;
                            ActivityAttributesSnapshot attributes = MergedManifestSnapshotFactory.createActivityAttributesSnapshot(element2, appId, namespace);
                            activityAttributesMapBuilder.put((Object)attributes.getName(), (Object)attributes);
                            activities.add(element2);
                            continue;
                        }
                        if ("activity-alias".equals(childNodeName)) {
                            activityAliases.add((Element)child);
                            continue;
                        }
                        if (!"service".equals(childNodeName)) continue;
                        services.add((Element)child);
                    }
                    continue;
                }
                if ("uses-sdk".equals(nodeName)) {
                    Element usesSdk = (Element)node;
                    minSdk = MergedManifestSnapshotFactory.getApiVersion(usesSdk, "minSdkVersion", AndroidVersion.DEFAULT);
                    targetSdk = MergedManifestSnapshotFactory.getApiVersion(usesSdk, "targetSdkVersion", minSdk);
                    continue;
                }
                if ("uses-permission".equals(nodeName) || "uses-permission-sdk-23".equals(nodeName) || "uses-permission-sdk-m".equals(nodeName)) {
                    element = (Element)node;
                    String name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (name2.isEmpty()) continue;
                    permissions.add(name2);
                    continue;
                }
                if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
                revocable.add(name);
            }
            AndroidVersion modelMinSdk = null;
            AndroidVersion modelTargetSdk = null;
            AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
            if (androidModel != null) {
                modelMinSdk = androidModel.getMinSdkVersion();
                modelTargetSdk = androidModel.getTargetSdkVersion();
            }
            ModulePermissions permissionHolder = new ModulePermissions(modelMinSdk == null ? minSdk : modelMinSdk, modelTargetSdk == null ? targetSdk : modelTargetSdk, (ImmutableSet<String>)ImmutableSet.copyOf((Collection)permissions), (ImmutableSet<String>)ImmutableSet.copyOf((Collection)revocable));
            Actions actions2 = mergedManifestInfo.getActions();
            ImmutableList<MergingReport.Record> loggingRecords = mergedManifestInfo.getLoggingRecords();
            return new MergedManifestSnapshot(facet.getModule(), packageName, appId, versionCode2, manifestTheme, (ImmutableMap<String, ActivityAttributesSnapshot>)activityAttributesMapBuilder.build(), mergedManifestInfo, minSdk, targetSdk, appIcon, appLabel, supportsRtl, isAppDebuggable, document, (ImmutableList<VirtualFile>)ImmutableList.copyOf(mergedManifestInfo.getFiles()), permissionHolder, appHasCode, (ImmutableList<Element>)ImmutableList.copyOf(activities), (ImmutableList<Element>)ImmutableList.copyOf(activityAliases), (ImmutableList<Element>)ImmutableList.copyOf(services), actions2, loggingRecords);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(MergedManifestManager.class).warn("Could not read Manifest data", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static ActivityAttributesSnapshot createActivityAttributesSnapshot(@NotNull Element activity, @Nullable String packageName, @NotNull ResourceNamespace namespace) {
        String name = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "name");
        if (name == null || name.isEmpty()) {
            throw new RuntimeException("Activity name cannot be empty.");
        }
        int index = name.indexOf(46);
        if (index <= 0 && packageName != null && !packageName.isEmpty()) {
            name = packageName + (index == -1 ? "." : "") + name;
        }
        ResourceValue icon2 = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.DRAWABLE, activity, "http://schemas.android.com/apk/res/android", "icon");
        ResourceValue label = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.STRING, activity, "http://schemas.android.com/apk/res/android", "label");
        String value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "parentActivityName");
        if (value2 == null || value2.isEmpty()) {
            for (Node child = activity.getFirstChild(); child != null; child = child.getNextSibling()) {
                String metaDataName;
                if (child.getNodeType() != 1 || !child.getNodeName().equals("meta-data") || !"android.support.PARENT_ACTIVITY".equals(metaDataName = MergedManifestSnapshotFactory.getAttributeValue((Element)child, "http://schemas.android.com/apk/res/android", "name")) || (value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "value")) == null || (index = value2.indexOf(46)) > 0 || packageName == null || packageName.isEmpty()) continue;
                value2 = packageName + (index == -1 ? "." : "") + value2;
                break;
            }
        }
        String parentActivity = StringUtil.isNotEmpty((String)value2) ? value2 : null;
        value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "theme");
        String theme = StringUtil.isNotEmpty((String)value2) ? value2 : null;
        value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "uiOptions");
        String uiOptions = StringUtil.isNotEmpty((String)value2) ? value2 : null;
        return new ActivityAttributesSnapshot(activity, icon2, label, name, parentActivity, theme, uiOptions);
    }

    static class ModulePermissions
    implements PermissionHolder {
        @VisibleForTesting
        static final ModulePermissions NOP_MODULE_PERMISSIONS = new ModulePermissions(AndroidVersion.DEFAULT, AndroidVersion.DEFAULT, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of());
        private final AndroidVersion myMinSdk;
        private final AndroidVersion myTargetSdk;
        @NotNull
        private final ImmutableSet<String> myPermissions;
        @NotNull
        private final ImmutableSet<String> myRevocable;

        ModulePermissions(@NotNull AndroidVersion minSdk, @NotNull AndroidVersion targetSdk, @NotNull ImmutableSet<String> permissions, @NotNull ImmutableSet<String> revocable) {
            this.myMinSdk = minSdk;
            this.myTargetSdk = targetSdk;
            this.myPermissions = permissions;
            this.myRevocable = revocable;
        }

        public boolean hasPermission(@NotNull String permission) {
            return this.myPermissions.contains((Object)permission);
        }

        public boolean isRevocable(@NotNull String permission) {
            return this.myRevocable.contains((Object)permission);
        }

        @NotNull
        public AndroidVersion getMinSdkVersion() {
            return this.myMinSdk;
        }

        @NotNull
        public AndroidVersion getTargetSdkVersion() {
            return this.myTargetSdk;
        }
    }

    private static class ManifestResourceValue
    extends ResourceValueImpl {
        @Nullable
        private final ResourceReference myReference;

        ManifestResourceValue(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull String name, @Nullable String value2, @Nullable ResourceReference reference2) {
            super(namespace, type, name, value2);
            this.myReference = reference2;
        }

        @Nullable
        public ResourceReference getReference() {
            return this.myReference;
        }
    }
}

