/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.editor;

import com.android.tools.idea.common.editor.DesignerEditorProvider;
import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerTypeRegistrar;
import com.android.tools.idea.naveditor.editor.NavEditor;
import com.android.tools.idea.naveditor.editor.NavToolbarActionGroups;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.dom.navigation.NavigationDomFileDescription;
import org.jetbrains.annotations.NotNull;

public class NavEditorProvider
extends DesignerEditorProvider {
    @NotNull
    private static final NavigationFileType SUPPORTED_FILE_TYPE = new NavigationFileType();

    public NavEditorProvider() {
        DesignerTypeRegistrar.INSTANCE.register(SUPPORTED_FILE_TYPE);
    }

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        return new NavEditor(file, project);
    }

    @Override
    @NotNull
    public String getEditorTypeId() {
        return "nav-designer";
    }

    @Override
    protected boolean acceptAndroidFacetXml(@NotNull XmlFile xmlFile) {
        return SUPPORTED_FILE_TYPE.isResourceTypeOf((PsiFile)xmlFile);
    }

    private static class NavigationFileType
    implements DesignerEditorFileType {
        private NavigationFileType() {
        }

        @Override
        public boolean isResourceTypeOf(@NotNull PsiFile file) {
            return file instanceof XmlFile && NavigationDomFileDescription.isNavFile((XmlFile)file);
        }

        @Override
        @NotNull
        public ToolbarActionGroups getToolbarActionGroups(@NotNull DesignSurface surface) {
            return new NavToolbarActionGroups(surface);
        }

        @Override
        public boolean isEditable() {
            return true;
        }
    }
}

