/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.editors;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.model.stdui.CommonBorderModel;
import com.android.tools.adtui.model.stdui.DefaultCommonBorderModel;
import com.android.tools.adtui.stdui.CommonBorder;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.BaseComponentEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditor
extends BaseComponentEditor {
    private static final int HORIZONTAL_SPACE_AFTER_LABEL = 4;
    private final JPanel myPanel = new AdtSecondaryPanel((LayoutManager)new BorderLayout());
    private final JLabel myLabel;
    private final Project myProject;
    private final EditorTextField myTextEditor;
    private NlProperty myProperty;
    private String myLastReadValue;
    private Object myLastWriteValue;

    public TextEditor(@NotNull Project project, final boolean drawBorder, @NotNull NlEditingListener listener2) {
        super(listener2);
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        this.myLabel = new JBLabel();
        this.myPanel.add((Component)this.myLabel, "Before");
        this.myPanel.setFocusable(false);
        if (drawBorder) {
            this.myLabel.setBorder((Border)JBUI.Borders.emptyRight((int)4));
        }
        this.myProject = project;
        this.myTextEditor = new EditorTextField("", this.myProject, (FileType)FileTypes.PLAIN_TEXT){

            public void addNotify() {
                super.addNotify();
                if (drawBorder) {
                    this.getEditor().setBorder((Border)new CommonBorder(1.0f, (CommonBorderModel)new DefaultCommonBorderModel(), (Insets)JBUI.insets((int)4, (int)3)));
                }
            }

            public void removeNotify() {
                super.removeNotify();
                this.removeAll();
            }
        };
        this.myTextEditor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)true);
        this.myPanel.add((Component)this.myTextEditor, "Center");
        this.myTextEditor.registerKeyboardAction(event -> this.stopEditing(this.getText()), KeyStroke.getKeyStroke(10, 0), 1);
        this.myTextEditor.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.myTextEditor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                TextEditor.this.myTextEditor.selectAll();
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                TextEditor.this.stopEditing(TextEditor.this.getText());
                TextEditor.this.myTextEditor.removeSelection();
            }
        });
        this.myProperty = EmptyProperty.INSTANCE;
    }

    @NotNull
    private String getText() {
        return this.myTextEditor.getDocument().getText();
    }

    @VisibleForTesting
    public void setText(@NotNull String value2) {
        this.myTextEditor.getDocument().setText((CharSequence)value2);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myTextEditor.setEnabled(enabled);
        if (!enabled) {
            this.myLastReadValue = "";
            this.myLastWriteValue = "";
            this.myTextEditor.setText("");
        }
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @Override
    public void setProperty(@NotNull NlProperty property2) {
        if (this.myProperty != property2) {
            this.myProperty = property2;
            this.myLastReadValue = null;
        }
        this.myPanel.add((Component)this.myLabel, "Before");
        String propValue = StringUtil.notNullize((String)this.myProperty.getValue());
        if (!propValue.equals(this.myLastReadValue)) {
            this.myLastReadValue = propValue;
            this.myLastWriteValue = propValue;
            this.myTextEditor.setText(propValue);
        }
        JBColor color = this.myProperty.isDefaultValue(this.myLastReadValue) ? DEFAULT_VALUE_TEXT_COLOR : CHANGED_VALUE_TEXT_COLOR;
        this.myTextEditor.setForeground((Color)color);
    }

    @Override
    public void requestFocus() {
        if (this.myTextEditor.getEditor() != null) {
            this.myTextEditor.requestFocus();
        }
        this.myTextEditor.selectAll();
        this.myTextEditor.scrollRectToVisible(this.myTextEditor.getBounds());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.getText();
    }

    @Override
    public void stopEditing(@Nullable Object newValue) {
        this.myTextEditor.setText((String)newValue);
        if (this.myTextEditor.hasFocus()) {
            this.myTextEditor.selectAll();
        }
        if (!Objects.equals(newValue, this.myLastWriteValue)) {
            this.myLastWriteValue = newValue;
            this.myLastReadValue = null;
            super.stopEditing(newValue);
        }
    }

    protected void cancel() {
        this.myTextEditor.setText(this.myProperty.getValue());
        this.myTextEditor.selectAll();
        this.cancelEditing();
    }
}

