/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDeeplinkDialog
extends DialogWrapper {
    @VisibleForTesting
    JTextField myUriField;
    @VisibleForTesting
    JCheckBox myAutoVerify;
    private JPanel myContentPanel;
    @Nullable
    private final NlComponent myExistingComponent;
    @NotNull
    private final NlComponent myParent;

    public AddDeeplinkDialog(@Nullable NlComponent existing2, @NotNull NlComponent parent) {
        super(false);
        this.$$$setupUI$$$();
        if (existing2 != null) {
            this.myUriField.setText(existing2.getAttribute("http://schemas.android.com/apk/res-auto", "uri"));
            this.myAutoVerify.setSelected(Boolean.parseBoolean(existing2.getAttribute("http://schemas.android.com/apk/res/android", "autoVerify")));
        }
        this.init();
        if (existing2 == null) {
            this.myOKAction.putValue("Name", "Add");
            this.setTitle("Add Deep Link");
        } else {
            this.myOKAction.putValue("Name", "Update");
            this.setTitle("Update Deep Link");
        }
        this.myExistingComponent = existing2;
        this.myParent = parent;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myUriField.getText().isEmpty()) {
            return new ValidationInfo("URI must be set!", (JComponent)this.myUriField);
        }
        try {
            new URI(this.myUriField.getText().replaceAll("\\{[^}]*}", "dummy"));
        }
        catch (URISyntaxException e) {
            return new ValidationInfo("Invalid URI!", (JComponent)this.myUriField);
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @VisibleForTesting
    String getUri() {
        return this.myUriField.getText();
    }

    @VisibleForTesting
    public boolean getAutoVerify() {
        return this.myAutoVerify.isSelected();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUriField;
    }

    public void save() {
        WriteCommandAction.runWriteCommandAction((Project)this.myParent.getModel().getProject(), () -> {
            NlComponent realComponent = this.myExistingComponent;
            if (realComponent == null) {
                realComponent = NlComponentHelperKt.createChild(this.myParent, "deepLink", false, null, null, null, null, InsertType.CREATE);
                if (realComponent == null) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myParent.getModel().getProject(), (String)"Failed to create Argument!", (String)"Error"));
                    return;
                }
                realComponent.ensureId();
            }
            NavComponentHelperKt.setUriAndLog(realComponent, this.getUri(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
            NavComponentHelperKt.setAutoVerifyAndLog(realComponent, this.getAutoVerify(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(15, 7, 0, 7), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("URI");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Auto Verify");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoVerify = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, new Dimension(20, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUriField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

