/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.naveditor.property.NavPropertiesManager;
import com.android.tools.idea.naveditor.property.inspector.NavigationInspectorComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NavPropertiesInspectorProvider
implements InspectorProvider<NavPropertiesManager> {
    private final Map<String, InspectorComponent<NavPropertiesManager>> myInspectors = new HashMap<String, InspectorComponent<NavPropertiesManager>>();
    private final Map<String, String> myPropertyNameUiNameMap;
    private final String myTitle;

    protected NavPropertiesInspectorProvider(@NotNull Map<String, String> uiNamePropertyNameMap, @Nullable String title) {
        this.myPropertyNameUiNameMap = uiNamePropertyNameMap;
        this.myTitle = title;
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager) {
        if (components.isEmpty()) {
            return false;
        }
        String tagName = components.get(0).getTagDeprecated().getName();
        if (properties.keySet().stream().noneMatch(name -> this.myPropertyNameUiNameMap.containsKey(name))) {
            return false;
        }
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        this.myInspectors.put(tagName, new NavigationInspectorComponent(properties, propertiesManager, this.myPropertyNameUiNameMap, this.myTitle));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent<NavPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager) {
        String tagName = components.get(0).getTagName();
        InspectorComponent<NavPropertiesManager> inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        return inspector;
    }

    @Override
    public void resetCache() {
        this.myInspectors.clear();
    }
}

