/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.property.NavPropertiesManager;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

class NavigationInspectorComponent
implements InspectorComponent<NavPropertiesManager> {
    private final List<NlComponentEditor> myEditors;
    private final Map<String, String> myPropertyNameUiNameMap;
    private final String myTitle;

    public NavigationInspectorComponent(@NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager, Map<String, String> propertyNameUiNameMap, String title) {
        this.myEditors = new ArrayList<NlComponentEditor>(propertyNameUiNameMap.size());
        this.myPropertyNameUiNameMap = propertyNameUiNameMap;
        this.myTitle = title;
        this.createEditors(properties, propertiesManager);
    }

    private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager) {
        for (String propertyName : this.myPropertyNameUiNameMap.keySet()) {
            NlProperty property2 = properties.get(propertyName);
            if (property2 == null || propertyName.equals("startDestination") && property2.getComponents().stream().anyMatch(component -> NavComponentHelperKt.isNavigation(component) && ((NavDesignSurface)propertiesManager.getDesignSurface()).getCurrentNavigation() != component)) continue;
            NlComponentEditor editor2 = propertiesManager.getPropertyEditors().create(property2);
            editor2.setProperty(property2);
            this.myEditors.add(editor2);
        }
    }

    @Override
    public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager) {
        this.myEditors.clear();
        this.createEditors(properties, propertiesManager);
    }

    @Override
    @NotNull
    public List<NlComponentEditor> getEditors() {
        return this.myEditors;
    }

    @Override
    public int getMaxNumberOfRows() {
        return this.myEditors.size() + (this.myTitle != null ? 1 : 0);
    }

    @Override
    public void attachToInspector(@NotNull InspectorPanel inspector) {
        this.refresh();
        if (this.myTitle != null) {
            inspector.addTitle(this.myTitle);
        }
        for (NlComponentEditor editor2 : this.myEditors) {
            String propertyName;
            NlProperty property2 = editor2.getProperty();
            JLabel existing2 = editor2.getLabel();
            String string = propertyName = existing2 != null ? existing2.getText() : this.myPropertyNameUiNameMap.get(property2.getName());
            if (propertyName == null) {
                propertyName = property2.getName();
            }
            JLabel label = inspector.addComponent(propertyName, property2.getTooltipText(), editor2.getComponent());
            editor2.setLabel(label);
        }
    }

    @Override
    public void refresh() {
        this.myEditors.forEach(NlComponentEditor::refresh);
    }
}

