/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.ConnectionDirection;
import com.android.tools.idea.naveditor.scene.CurvePoints;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt$WhenMappings;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0007\u001a\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"\u001a\u001e\u0010#\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0019\u001a\u001e\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0019\u001a\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0019H\u0002\u001a(\u0010-\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0019H\u0002\u001a\u001e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\"\u001a\u0018\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u0002012\u0006\u00107\u001a\u00020\u001bH\u0002\u001a\u0018\u00108\u001a\u00020\u001b2\u0006\u00106\u001a\u0002012\u0006\u00107\u001a\u00020\u001bH\u0002\u001a\u0016\u00109\u001a\u00020\u00192\u0006\u00102\u001a\u00020%2\u0006\u0010:\u001a\u00020%\u001a\u001e\u0010;\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0019\u001a\u000e\u0010<\u001a\u00020%2\u0006\u0010$\u001a\u00020%\u001a\u001e\u0010=\u001a\u00020%2\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\"\u001a\u0016\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"\u001a\u000e\u0010@\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%\u001a)\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001e0B2\u0006\u0010?\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"\u00a2\u0006\u0002\u0010D\u001a \u0010E\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u0005H\u0002\u001a(\u0010E\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\t\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\r\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0011\u0010\u000f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0012\u001a\u00020\u00138\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u001bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u001bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"ACTION_PADDING", "", "ACTION_STROKE", "Ljava/awt/BasicStroke;", "ACTION_STROKE_WIDTH", "", "CONTROL_POINT_THRESHOLD", "DASHED_ACTION_STROKE", "DASHED_STROKE_CYCLE", "POP_ICON_DISTANCE", "getPOP_ICON_DISTANCE", "()I", "POP_ICON_HORIZONTAL_PADDING", "POP_ICON_RADIUS", "getPOP_ICON_RADIUS", "POP_ICON_RANGE", "getPOP_ICON_RANGE", "POP_ICON_VERTICAL_PADDING", "SELF_ACTION_LENGTHS", "", "SELF_ACTION_RADII", "", "getSELF_ACTION_RADII", "()[F", "START_DIRECTION", "Lcom/android/tools/idea/naveditor/scene/ConnectionDirection;", "STEP_SIZE", "", "STEP_THRESHOLD", "getAnyPoint", "Ljava/awt/geom/Point2D$Float;", "action", "Lcom/android/tools/idea/common/scene/SceneComponent;", "context", "Lcom/android/tools/idea/common/scene/SceneContext;", "getArrowPoint", "rectangle", "Ljava/awt/geom/Rectangle2D$Float;", "direction", "getArrowRectangle", "view", "Lcom/android/tools/idea/common/surface/SceneView;", "p", "getCenterPoint", "getConnectionPoint", "getControlPoint", "p1", "p2", "getCurvePoints", "Lcom/android/tools/idea/naveditor/scene/CurvePoints;", "source", "dest", "sceneContext", "getCurveX", "points", "t", "getCurveY", "getDestinationDirection", "destination", "getEndPoint", "getHorizontalActionIconRect", "getRegularActionIconRect", "getSelfActionIconRect", "start", "getStartPoint", "selfActionPoints", "", "end", "(Ljava/awt/geom/Point2D$Float;Ljava/awt/geom/Point2D$Float;Lcom/android/tools/idea/common/scene/SceneContext;)[Ljava/awt/geom/Point2D$Float;", "shiftPoint", "shift", "shiftX", "shiftY", "intellij.android.naveditor"})
public final class NavActionHelperKt {
    private static final float ACTION_STROKE_WIDTH = JBUI.scale((float)3.0f);
    private static final float DASHED_STROKE_CYCLE = JBUI.scale((float)5.0f);
    @JvmField
    @NotNull
    public static final int[] SELF_ACTION_LENGTHS = new int[]{JBUI.scale((int)28), JBUI.scale((int)26), JBUI.scale((int)60), JBUI.scale((int)8)};
    @NotNull
    private static final float[] SELF_ACTION_RADII = new float[]{JBUI.scale((float)10.0f), JBUI.scale((float)10.0f), JBUI.scale((float)5.0f)};
    @JvmField
    @NotNull
    public static final BasicStroke ACTION_STROKE = new BasicStroke(ACTION_STROKE_WIDTH, 0, 1);
    @JvmField
    @NotNull
    public static final BasicStroke DASHED_ACTION_STROKE = new BasicStroke(ACTION_STROKE_WIDTH, 0, 1, DASHED_STROKE_CYCLE, new float[]{DASHED_STROKE_CYCLE}, DASHED_STROKE_CYCLE);
    private static final ConnectionDirection START_DIRECTION = ConnectionDirection.RIGHT;
    private static final int CONTROL_POINT_THRESHOLD = JBUI.scale((int)120);
    private static final int ACTION_PADDING = JBUI.scale((int)8);
    private static final int POP_ICON_RADIUS = JBUI.scale((int)7);
    private static final int POP_ICON_DISTANCE = JBUI.scale((int)7);
    private static final int POP_ICON_RANGE = JBUI.scale((int)50);
    private static final float POP_ICON_HORIZONTAL_PADDING = JBUI.scale((float)2.0f);
    private static final float POP_ICON_VERTICAL_PADDING = JBUI.scale((float)5.0f);
    private static final double STEP_SIZE = 0.001;
    private static final double STEP_THRESHOLD = 0.4;

    @NotNull
    public static final float[] getSELF_ACTION_RADII() {
        return SELF_ACTION_RADII;
    }

    public static final int getPOP_ICON_RADIUS() {
        return POP_ICON_RADIUS;
    }

    public static final int getPOP_ICON_DISTANCE() {
        return POP_ICON_DISTANCE;
    }

    public static final int getPOP_ICON_RANGE() {
        return POP_ICON_RANGE;
    }

    @NotNull
    public static final Point2D.Float[] selfActionPoints(@NotNull Point2D.Float start, @NotNull Point2D.Float end, @NotNull SceneContext context) {
        Point2D.Float p1 = new Point2D.Float(start.x + (float)context.getSwingDimension(SELF_ACTION_LENGTHS[0]), start.y);
        Point2D.Float p2 = new Point2D.Float(p1.x, end.y + (float)context.getSwingDimension(SELF_ACTION_LENGTHS[3]));
        Point2D.Float p3 = new Point2D.Float(end.x, p2.y);
        return new Point2D.Float[]{start, p1, p2, p3, end};
    }

    @NotNull
    public static final ConnectionDirection getDestinationDirection(@NotNull Rectangle2D.Float source, @NotNull Rectangle2D.Float destination) {
        boolean higher;
        Point2D.Float start = NavActionHelperKt.getStartPoint(source);
        Point2D.Float end = NavActionHelperKt.getCenterPoint(destination);
        float slope = destination.width == 0.0f ? 1.0f : destination.height / destination.width;
        float rise = (start.x - end.x) * slope;
        boolean bl = higher = start.y < end.y;
        if (higher && start.y < end.y + rise) {
            return ConnectionDirection.TOP;
        }
        return !higher && start.y > end.y - rise ? ConnectionDirection.BOTTOM : ConnectionDirection.LEFT;
    }

    @NotNull
    public static final Point2D.Float getStartPoint(@NotNull Rectangle2D.Float rectangle) {
        return NavActionHelperKt.getConnectionPoint(rectangle, START_DIRECTION);
    }

    @NotNull
    public static final Rectangle2D.Float getArrowRectangle(@NotNull SceneView view, @NotNull Point2D.Float p, @NotNull ConnectionDirection direction) {
        Rectangle2D.Float rectangle = new Rectangle2D.Float();
        float parallel = Coordinates.getSwingDimension(view, NavSceneManager.ACTION_ARROW_PARALLEL);
        float perpendicular = Coordinates.getSwingDimension(view, NavSceneManager.ACTION_ARROW_PERPENDICULAR);
        float deltaX = direction.getDeltaX();
        float deltaY = direction.getDeltaY();
        rectangle.x = p.x + (deltaX == 0.0f ? -perpendicular : parallel * (deltaX - 1.0f)) / (float)2;
        rectangle.y = p.y + (deltaY == 0.0f ? -perpendicular : parallel * (deltaY - 1.0f)) / (float)2;
        rectangle.width = Math.abs(deltaX * parallel) + Math.abs(deltaY * perpendicular);
        rectangle.height = Math.abs(deltaX * perpendicular) + Math.abs(deltaY * parallel);
        return rectangle;
    }

    private static final Point2D.Float getConnectionPoint(Rectangle2D.Float rectangle, ConnectionDirection direction) {
        return NavActionHelperKt.shiftPoint(NavActionHelperKt.getCenterPoint(rectangle), direction, rectangle.width / (float)2, rectangle.height / (float)2);
    }

    @NotNull
    public static final CurvePoints getCurvePoints(@NotNull Rectangle2D.Float source, @NotNull Rectangle2D.Float dest, @NotNull SceneContext sceneContext) {
        ConnectionDirection destDirection = NavActionHelperKt.getDestinationDirection(source, dest);
        Point2D.Float startPoint = NavActionHelperKt.getStartPoint(source);
        Point2D.Float endPoint = NavActionHelperKt.getEndPoint(sceneContext, dest, destDirection);
        return new CurvePoints(startPoint, NavActionHelperKt.getControlPoint(sceneContext, startPoint, endPoint, START_DIRECTION), NavActionHelperKt.getControlPoint(sceneContext, endPoint, startPoint, destDirection), endPoint, destDirection);
    }

    private static final Point2D.Float getControlPoint(SceneContext context, Point2D.Float p1, Point2D.Float p2, ConnectionDirection direction) {
        float shift = (float)Math.min(Math.hypot(p1.x - p2.x, p1.y - p2.y) / (double)2, (double)context.getSwingDimension(CONTROL_POINT_THRESHOLD));
        return NavActionHelperKt.shiftPoint(p1, direction, shift);
    }

    @NotNull
    public static final Point2D.Float getEndPoint(@NotNull SceneContext context, @NotNull Rectangle2D.Float rectangle, @NotNull ConnectionDirection direction) {
        return NavActionHelperKt.shiftPoint(NavActionHelperKt.getArrowPoint(context, rectangle, direction), direction, (float)context.getSwingDimensionDip(NavSceneManager.ACTION_ARROW_PARALLEL) - 1.0f);
    }

    @Nullable
    public static final Point2D.Float getAnyPoint(@NotNull SceneComponent action2, @NotNull SceneContext context) {
        Scene scene = action2.getScene();
        Object object = scene.getRoot();
        if (object == null || (object = ((SceneComponent)object).getNlComponent()) == null) {
            return null;
        }
        Object rootNlComponent = object;
        NlComponent actionNlComponent = action2.getNlComponent();
        NlComponent nlComponent = NavComponentHelperKt.getEffectiveSource(actionNlComponent, (NlComponent)rootNlComponent);
        if (nlComponent == null) {
            return null;
        }
        NlComponent sourceNlComponent = nlComponent;
        SceneComponent sceneComponent = scene.getSceneComponent(sourceNlComponent);
        if (sceneComponent == null) {
            return null;
        }
        SceneComponent sourceSceneComponent = sceneComponent;
        Rectangle2D.Float sourceRect = Coordinates.getSwingRectDip(context, sourceSceneComponent.fillDrawRect2D(0L, null));
        switch (NavActionHelperKt$WhenMappings.$EnumSwitchMapping$0[NavComponentHelperKt.getActionType(actionNlComponent, (NlComponent)rootNlComponent).ordinal()]) {
            case 1: {
                Point2D.Float[] points = NavActionHelperKt.selfActionPoints(NavActionHelperKt.getStartPoint(sourceRect), NavActionHelperKt.getEndPoint(context, sourceRect, ConnectionDirection.BOTTOM), context);
                return new Point2D.Float(points[1].x, (points[1].y + points[2].y) / (float)2);
            }
            case 2: 
            case 3: {
                NlComponent nlComponent2 = NavComponentHelperKt.getEffectiveDestination(actionNlComponent);
                if (nlComponent2 == null) {
                    return null;
                }
                NlComponent targetNlComponent = nlComponent2;
                SceneComponent sceneComponent2 = scene.getSceneComponent(targetNlComponent);
                if (sceneComponent2 == null) {
                    return null;
                }
                SceneComponent destinationSceneComponent = sceneComponent2;
                Rectangle2D.Float destRect = Coordinates.getSwingRectDip(context, destinationSceneComponent.fillDrawRect2D(0L, null));
                CurvePoints curvePoints = NavActionHelperKt.getCurvePoints(sourceRect, destRect, context);
                return new Point2D.Float((float)NavActionHelperKt.getCurveX(curvePoints, 0.5), (float)NavActionHelperKt.getCurveY(curvePoints, 0.5));
            }
            case 4: 
            case 5: {
                return NavActionHelperKt.getCenterPoint(Coordinates.getSwingRectDip(context, action2.fillDrawRect2D(0L, null)));
            }
        }
        return null;
    }

    @NotNull
    public static final Point2D.Float getArrowPoint(@NotNull SceneContext context, @NotNull Rectangle2D.Float rectangle, @NotNull ConnectionDirection direction) {
        int shiftY = ACTION_PADDING;
        if (direction == ConnectionDirection.TOP) {
            shiftY += (int)JBUI.scale((float)NavDrawHelperKt.HEADER_HEIGHT);
        }
        return NavActionHelperKt.shiftPoint(NavActionHelperKt.getConnectionPoint(rectangle, direction), direction, context.getSwingDimension(shiftY));
    }

    @NotNull
    public static final Rectangle2D.Float getRegularActionIconRect(@NotNull Rectangle2D.Float source, @NotNull Rectangle2D.Float dest, @NotNull SceneContext sceneContext) {
        Point2D.Float startPoint = NavActionHelperKt.getStartPoint(source);
        CurvePoints points = NavActionHelperKt.getCurvePoints(source, dest, sceneContext);
        double t = 0.0;
        double previousX = 0.0;
        double previousY = 0.0;
        double currentX = NavActionHelperKt.getCurveX(points, t);
        double currentY = NavActionHelperKt.getCurveY(points, t);
        int range = sceneContext.getSwingDimension(POP_ICON_RANGE);
        int distance = sceneContext.getSwingDimension(POP_ICON_RADIUS + POP_ICON_DISTANCE);
        while (t < 1.0 && Math.hypot(currentX - (double)startPoint.x, currentY - (double)startPoint.y) < (double)range && (currentX - (double)startPoint.x < (double)distance || t < 0.4)) {
            previousX = currentX;
            previousY = currentY;
            currentX = NavActionHelperKt.getCurveX(points, t += 0.001);
            currentY = NavActionHelperKt.getCurveY(points, t);
        }
        double dx = currentX - previousX;
        double dy = currentY - previousY;
        double ds = Math.hypot(dx, dy);
        double deltaX = dy * (double)distance / ds;
        double deltaY = -dx * (double)distance / ds;
        if (dx < 0.0 && dy < 0.0) {
            deltaX *= (double)-1;
            deltaY *= (double)-1;
        }
        float radius = sceneContext.getSwingDimension(POP_ICON_RADIUS);
        return new Rectangle2D.Float((float)(currentX + deltaX) - radius, (float)(currentY + deltaY) - radius, (float)2 * radius, (float)2 * radius);
    }

    @NotNull
    public static final Rectangle2D.Float getSelfActionIconRect(@NotNull Point2D.Float start, @NotNull SceneContext context) {
        float distance = context.getSwingDimension(POP_ICON_DISTANCE);
        float offsetX = (float)context.getSwingDimension(SELF_ACTION_LENGTHS[0]) + distance;
        float x = start.x + offsetX;
        double range = context.getSwingDimension(POP_ICON_RANGE);
        float y = start.y + (float)Math.sqrt(Math.max(range * range - (double)(offsetX * offsetX), 0.0));
        float radius = context.getSwingDimension(POP_ICON_RADIUS);
        return new Rectangle2D.Float(x, y, (float)2 * radius, (float)2 * radius);
    }

    @NotNull
    public static final Rectangle2D.Float getHorizontalActionIconRect(@NotNull Rectangle2D.Float rectangle) {
        Rectangle2D.Float iconRect = new Rectangle2D.Float();
        float scale = rectangle.height / NavSceneManager.ACTION_ARROW_PERPENDICULAR;
        iconRect.x = rectangle.x + POP_ICON_HORIZONTAL_PADDING * scale;
        iconRect.height = iconRect.width = (float)(2 * POP_ICON_RADIUS) * scale;
        iconRect.y = rectangle.y + (rectangle.height / (float)2 - iconRect.height - POP_ICON_VERTICAL_PADDING * scale);
        return iconRect;
    }

    private static final Point2D.Float getCenterPoint(Rectangle2D.Float rectangle) {
        return new Point2D.Float((float)rectangle.getCenterX(), (float)rectangle.getCenterY());
    }

    private static final Point2D.Float shiftPoint(Point2D.Float p, ConnectionDirection direction, float shift) {
        return NavActionHelperKt.shiftPoint(p, direction, shift, shift);
    }

    private static final Point2D.Float shiftPoint(Point2D.Float p, ConnectionDirection direction, float shiftX, float shiftY) {
        return new Point2D.Float(p.x + shiftX * (float)direction.getDeltaX(), p.y + shiftY * (float)direction.getDeltaY());
    }

    private static final double getCurveX(CurvePoints points, double t) {
        return Math.pow(1.0 - t, 3.0) * (double)points.p1.x + (double)3 * Math.pow(1.0 - t, 2.0) * t * (double)points.p2.x + (double)3 * (1.0 - t) * Math.pow(t, 2.0) * (double)points.p3.x + Math.pow(t, 3.0) * (double)points.p4.x;
    }

    private static final double getCurveY(CurvePoints points, double t) {
        return Math.pow(1.0 - t, 3.0) * (double)points.p1.y + (double)3 * Math.pow(1.0 - t, 2.0) * t * (double)points.p2.y + (double)3 * (1.0 - t) * Math.pow(t, 2.0) * (double)points.p3.y + Math.pow(t, 3.0) * (double)points.p4.y;
    }
}

