/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavDestinationHitProvider;
import com.android.tools.idea.naveditor.scene.NavHorizontalActionHitProvider;
import com.android.tools.idea.naveditor.scene.decorator.NavSceneDecoratorFactory;
import com.android.tools.idea.naveditor.scene.layout.ElkLayeredLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.ManualLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NavSceneLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NewDestinationLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.targets.NavActionTargetProvider;
import com.android.tools.idea.naveditor.scene.targets.NavScreenTargetProvider;
import com.android.tools.idea.naveditor.scene.targets.NavigationTargetProvider;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.naveditor.surface.NavView;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavSceneManager
extends SceneManager {
    private static final int SCREEN_LONG = JBUI.scale((int)256);
    public static final int SUBNAV_WIDTH = JBUI.scale((int)140);
    public static final int SUBNAV_HEIGHT = JBUI.scale((int)38);
    private static final int PAN_LIMIT = JBUI.scale((int)150);
    private static final int BOUNDING_BOX_PADDING = JBUI.scale((int)100);
    public static final float ACTION_ARROW_PARALLEL = JBUI.scale((float)10.0f);
    public static final float ACTION_ARROW_PERPENDICULAR;
    private static final float ACTION_HEIGHT;
    private static final int ACTION_VERTICAL_PADDING;
    private static final int POP_ICON_VERTICAL_PADDING;
    private static final int ACTION_LINE_LENGTH;
    private static final float ACTION_WIDTH;
    private static final int ACTION_HORIZONTAL_PADDING;
    private final NavScreenTargetProvider myScreenTargetProvider;
    private final NavigationTargetProvider myNavigationTargetProvider;
    private final NavActionTargetProvider myNavActionTargetProvider;
    private final HitProvider myNavDestinationHitProvider = new NavDestinationHitProvider();
    private final HitProvider myHorizontalActionHitProvider = new NavHorizontalActionHitProvider();
    private final List<NavSceneLayoutAlgorithm> myLayoutAlgorithms;
    private final NavSceneLayoutAlgorithm mySavingLayoutAlgorithm;
    private SceneDecoratorFactory myDecoratorFactory;

    public NavSceneManager(@NotNull NlModel model2, @NotNull NavDesignSurface surface, @NotNull RenderSettings settings) {
        super(model2, surface, settings);
        this.createSceneView();
        this.myLayoutAlgorithms = ImmutableList.of((Object)new NewDestinationLayoutAlgorithm(), (Object)new ManualLayoutAlgorithm(model2.getModule(), this), (Object)new ElkLayeredLayoutAlgorithm());
        this.mySavingLayoutAlgorithm = this.myLayoutAlgorithms.stream().filter(algorithm -> algorithm.canSave()).findFirst().orElse(null);
        this.myScreenTargetProvider = new NavScreenTargetProvider();
        this.myNavigationTargetProvider = new NavigationTargetProvider(surface);
        this.myNavActionTargetProvider = new NavActionTargetProvider();
        NavSceneManager.updateHierarchy(this.getModel(), null);
        this.getModel().addListener(new ModelChangeListener());
        this.getDesignSurface().getSelectionModel().addListener((unused, selection) -> this.getScene().needsRebuildList());
    }

    public NavSceneManager(@NotNull NlModel model2, @NotNull NavDesignSurface surface) {
        this(model2, surface, RenderSettings.getProjectSettings(model2.getProject()));
    }

    @Override
    @NotNull
    protected NavDesignSurface getDesignSurface() {
        return (NavDesignSurface)super.getDesignSurface();
    }

    @Override
    @NotNull
    protected SceneView doCreateSceneView() {
        NavDesignSurface surface = this.getDesignSurface();
        NavView navView = new NavView(surface, (SceneManager)this);
        surface.getLayeredPane().setPreferredSize(navView.getPreferredSize());
        return navView;
    }

    @Override
    protected void updateFromComponent(@NotNull SceneComponent sceneComponent) {
        super.updateFromComponent(sceneComponent);
        NlComponent nlComponent = sceneComponent.getNlComponent();
        switch (NavComponentHelperKt.getActionType(nlComponent, this.getRoot())) {
            case GLOBAL: 
            case EXIT: {
                sceneComponent.setSize((int)ACTION_WIDTH, (int)ACTION_HEIGHT);
                return;
            }
        }
        NavigationSchema.DestinationType type = NavComponentHelperKt.getDestinationType(nlComponent);
        if (type != null) {
            sceneComponent.setTargetProvider(sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation() ? this.myNavigationTargetProvider : this.myScreenTargetProvider);
            sceneComponent.updateTargets();
            switch (type) {
                case NAVIGATION: {
                    if (sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation()) {
                        sceneComponent.setSize(-1, -1);
                        break;
                    }
                    sceneComponent.setSize(SUBNAV_WIDTH, SUBNAV_HEIGHT);
                    break;
                }
                case FRAGMENT: 
                case ACTIVITY: 
                case OTHER: {
                    State state = this.getModel().getConfiguration().getDeviceState();
                    assert (state != null);
                    Screen screen = state.getHardware().getScreen();
                    int x = SCREEN_LONG;
                    int y = SCREEN_LONG;
                    double ratio = (double)screen.getXDimension() / (double)screen.getYDimension();
                    if (ratio > 1.0) {
                        y = (int)((double)y / ratio);
                    } else {
                        x = (int)((double)x * ratio);
                    }
                    if (ratio < 1.1 && ratio > 0.9) {
                        x = (int)((double)x * 0.5);
                        y = (int)((double)y * 0.5);
                    }
                    if (state.getOrientation() == ScreenOrientation.LANDSCAPE == ratio < 1.0) {
                        int tmp = x;
                        x = y;
                        y = tmp;
                    }
                    sceneComponent.setSize(x, y);
                    break;
                }
            }
        } else if (NavComponentHelperKt.isAction(sceneComponent.getNlComponent())) {
            sceneComponent.setTargetProvider(this.myNavActionTargetProvider);
            sceneComponent.updateTargets();
        }
    }

    @Override
    public void update() {
        Rectangle rootBounds = null;
        if (this.getScene().getRoot() != null) {
            rootBounds = this.getScene().getRoot().fillDrawRect(0L, null);
        }
        super.update();
        this.updateRootBounds(rootBounds);
    }

    @Override
    protected void postUpdateFromComponent(@NotNull SceneComponent sceneComponent) {
        NlComponent nlComponent = sceneComponent.getNlComponent();
        if (NavComponentHelperKt.isNavigation(nlComponent) && nlComponent == this.getDesignSurface().getCurrentNavigation()) {
            this.layoutAll(sceneComponent);
        }
    }

    private void updateRootBounds(@Nullable Rectangle prevRootBounds) {
        Rectangle rootBounds;
        SceneComponent root = this.getScene().getRoot();
        if (root == null) {
            return;
        }
        NavDesignSurface surface = this.getDesignSurface();
        Dimension extentSize = surface.getExtentSize();
        int extentWidth = Coordinates.getAndroidDimension(surface, extentSize.width);
        int extentHeight = Coordinates.getAndroidDimension(surface, extentSize.height);
        if (this.isEmpty()) {
            rootBounds = new Rectangle(0, 0, extentWidth, extentHeight);
        } else {
            int panLimit = Coordinates.getAndroidDimension(surface, PAN_LIMIT);
            rootBounds = NavSceneManager.getBoundingBox(root);
            rootBounds.grow(extentWidth - panLimit, extentHeight - panLimit);
        }
        root.setPosition(rootBounds.x, rootBounds.y);
        root.setSize(rootBounds.width, rootBounds.height);
        surface.updateScrolledAreaSize();
        SceneView view = surface.getCurrentSceneView();
        if (view != null) {
            int deltaX = Coordinates.getSwingDimension(view, root.getDrawX() - (prevRootBounds == null ? 0 : prevRootBounds.x));
            int deltaY = Coordinates.getSwingDimension(view, root.getDrawY() - (prevRootBounds == null ? 0 : prevRootBounds.y));
            Point point = surface.getScrollPosition();
            surface.setScrollPosition(point.x - deltaX, point.y - deltaY);
        }
    }

    @Override
    @NotNull
    protected NlComponent getRoot() {
        return this.getDesignSurface().getCurrentNavigation();
    }

    @Override
    @NotNull
    protected List<SceneComponent> createHierarchy(@NotNull NlComponent component) {
        List<SceneComponent> exits;
        boolean shouldCreateHierarchy = false;
        if (NavComponentHelperKt.isAction(component)) {
            shouldCreateHierarchy = true;
        } else if (NavComponentHelperKt.isDestination(component)) {
            shouldCreateHierarchy = this.shouldCreateDestinationHierarchy(component);
        }
        if (!shouldCreateHierarchy) {
            return ImmutableList.of();
        }
        List<SceneComponent> hierarchy = super.createHierarchy(component);
        if (component == this.getRoot()) {
            for (SceneComponent child : hierarchy) {
                this.moveGlobalActions(child);
                NavSceneManager.moveRegularActions(child);
            }
        } else if (NavComponentHelperKt.isNavigation(component) && !(exits = this.findAndCreateExitActionComponents(component)).isEmpty()) {
            return ImmutableList.builder().addAll(hierarchy).addAll(exits).build();
        }
        return hierarchy;
    }

    private List<SceneComponent> findAndCreateExitActionComponents(NlComponent component) {
        return component.flatten().filter(c -> {
            if (!NavComponentHelperKt.isAction(c)) {
                return false;
            }
            NlComponent destination = NavComponentHelperKt.getActionDestination(c);
            return destination != null && destination.getParent() == this.getRoot();
        }).map(c -> {
            SceneComponent sceneComponent = this.getScene().getSceneComponent((NlComponent)c);
            if (sceneComponent == null) {
                sceneComponent = new SceneComponent(this.getScene(), (NlComponent)c, this.getHitProvider((NlComponent)c));
            }
            return sceneComponent;
        }).collect(Collectors.toList());
    }

    private boolean shouldCreateDestinationHierarchy(@NotNull NlComponent component) {
        return component == this.getRoot() || component.getParent() == this.getRoot();
    }

    private void moveGlobalActions(@NotNull SceneComponent root) {
        HashMap<String, SceneComponent> destinationMap = new HashMap<String, SceneComponent>();
        for (SceneComponent component : root.getChildren()) {
            NlComponent child = component.getNlComponent();
            if (!NavComponentHelperKt.isDestination(child)) continue;
            destinationMap.put(child.getId(), component);
        }
        ArrayList<SceneComponent> globalActions = new ArrayList<SceneComponent>();
        NlComponent rootNlComponent = root.getNlComponent();
        for (SceneComponent component : root.getChildren()) {
            NlComponent child = component.getNlComponent();
            if (!NavComponentHelperKt.isAction(child) || child.getParent() != rootNlComponent) continue;
            globalActions.add(component);
        }
        for (SceneComponent globalAction : globalActions) {
            String destination = NavComponentHelperKt.getActionDestinationId(globalAction.getNlComponent());
            SceneComponent parent = (SceneComponent)destinationMap.get(destination);
            if (parent == null) {
                this.getScene().removeComponent(globalAction);
                continue;
            }
            parent.addChild(globalAction);
        }
    }

    private static void moveRegularActions(@NotNull SceneComponent root) {
        for (SceneComponent destinationSceneComponent : root.getChildren()) {
            NlComponent destinationNlComponent = destinationSceneComponent.getNlComponent();
            if (!NavComponentHelperKt.isDestination(destinationNlComponent)) continue;
            for (SceneComponent actionSceneComponent : destinationSceneComponent.getChildren()) {
                NlComponent actionNlComponent = actionSceneComponent.getNlComponent();
                if (NavComponentHelperKt.getActionType(actionNlComponent, root.getNlComponent()) != ActionType.REGULAR) continue;
                actionSceneComponent.removeFromParent();
                root.addChild(actionSceneComponent);
            }
        }
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component) {
        return new TemporarySceneComponent(this.getScene(), component);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestRender() {
        boolean wasEmpty = this.getScene().getRoot() == null || this.getScene().getRoot().getChildCount() == 0;
        this.update();
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            root.updateTargets();
            this.layoutAll(root);
        }
        if (wasEmpty) {
            this.getDesignSurface().zoomToFit();
        }
        return CompletableFuture.completedFuture(null);
    }

    private void layoutAll(@NotNull SceneComponent root) {
        List<SceneComponent> destinations = new ArrayList<SceneComponent>();
        for (SceneComponent child : root.getChildren()) {
            if (!NavComponentHelperKt.isDestination(child.getNlComponent())) continue;
            destinations.add(child);
        }
        for (NavSceneLayoutAlgorithm algorithm : this.myLayoutAlgorithms) {
            List<SceneComponent> remaining = algorithm.layout(destinations);
            destinations.removeAll(remaining);
            if (!algorithm.canSave()) {
                this.save(destinations);
            }
            if (remaining.isEmpty()) break;
            destinations = remaining;
        }
        HashSet<String> connectedActionSources = new HashSet<String>();
        HashSet<String> connectedActionDestinations = new HashSet<String>();
        NavSceneManager.getConnectedActions(root.getNlComponent(), connectedActionSources, connectedActionDestinations);
        for (SceneComponent component : root.getChildren()) {
            NlComponent nlComponent = component.getNlComponent();
            if (!NavComponentHelperKt.isDestination(nlComponent)) continue;
            ArrayList<SceneComponent> globalActions = new ArrayList<SceneComponent>();
            ArrayList<SceneComponent> exitActions = new ArrayList<SceneComponent>();
            for (SceneComponent child : component.getChildren()) {
                switch (NavComponentHelperKt.getActionType(child.getNlComponent(), this.getRoot())) {
                    case GLOBAL: {
                        globalActions.add(child);
                        break;
                    }
                    case EXIT: {
                        exitActions.add(child);
                        break;
                    }
                }
            }
            String id = nlComponent.getId();
            NavSceneManager.layoutGlobalActions(component, globalActions, connectedActionDestinations.contains(id));
            NavSceneManager.layoutExitActions(component, exitActions, connectedActionSources.contains(id));
        }
    }

    public void save(@NotNull List<SceneComponent> components) {
        if (this.mySavingLayoutAlgorithm != null) {
            components.forEach(this.mySavingLayoutAlgorithm::save);
        }
    }

    @Nullable
    public Object getPositionData(@NotNull SceneComponent component) {
        if (this.mySavingLayoutAlgorithm != null) {
            return this.mySavingLayoutAlgorithm.getPositionData(component);
        }
        return null;
    }

    public void restorePositionData(@NotNull List<String> path, @NotNull Object positionData) {
        if (this.mySavingLayoutAlgorithm != null) {
            this.mySavingLayoutAlgorithm.restorePositionData(path, positionData);
        }
    }

    private static void getConnectedActions(@NotNull NlComponent root, @NotNull HashSet<String> connectedActionSources, @NotNull HashSet<String> connectedActionDestinations) {
        HashSet<String> children = new HashSet<String>();
        for (NlComponent child : root.getChildren()) {
            children.add(child.getId());
        }
        for (NlComponent component : root.getChildren()) {
            if (!NavComponentHelperKt.isDestination(component)) continue;
            component.flatten().filter(NavComponentHelperKt::isAction).forEach(action2 -> {
                String destinationId = NavComponentHelperKt.getEffectiveDestinationId(action2);
                if (children.contains(destinationId)) {
                    connectedActionSources.add(component.getId());
                    if (!NavComponentHelperKt.isSelfAction(action2)) {
                        connectedActionDestinations.add(destinationId);
                    }
                }
            });
        }
    }

    private static void layoutGlobalActions(@NotNull SceneComponent destination, @NotNull ArrayList<SceneComponent> globalActions, Boolean skip) {
        NavSceneManager.layoutActions(destination, globalActions, skip, (int)((float)destination.getDrawX() - ACTION_WIDTH - (float)ACTION_HORIZONTAL_PADDING));
    }

    private static void layoutExitActions(@NotNull SceneComponent source, @NotNull ArrayList<SceneComponent> exitActions, Boolean skip) {
        NavSceneManager.layoutActions(source, exitActions, skip, source.getDrawX() + source.getDrawWidth() + ACTION_HORIZONTAL_PADDING);
    }

    private static void layoutActions(SceneComponent component, ArrayList<SceneComponent> actions2, Boolean skip, int x) {
        int count = actions2.size();
        if (count == 0) {
            return;
        }
        int popIconCount = 0;
        for (int i2 = 0; i2 < (count + 1) / 2; ++i2) {
            if (NavComponentHelperKt.getPopUpTo(actions2.get(i2).getNlComponent()) == null) continue;
            ++popIconCount;
        }
        if (skip.booleanValue()) {
            actions2.add((count + 1) / 2, null);
            ++count;
        }
        int y = component.getDrawY() + component.getDrawHeight() / 2 - (int)ACTION_HEIGHT / 2 - count / 2 * (int)(ACTION_HEIGHT + (float)ACTION_VERTICAL_PADDING) - popIconCount * POP_ICON_VERTICAL_PADDING;
        for (SceneComponent action2 : actions2) {
            if (action2 != null) {
                if (NavComponentHelperKt.getPopUpTo(action2.getNlComponent()) != null) {
                    y += POP_ICON_VERTICAL_PADDING;
                }
                action2.setPosition(x, y);
            }
            y = (int)((float)y + (ACTION_HEIGHT + (float)ACTION_VERTICAL_PADDING));
        }
    }

    @Override
    public void layout(boolean animate) {
        Rectangle bounds = null;
        if (this.getScene().getRoot() != null) {
            bounds = this.getScene().getRoot().fillDrawRect(0L, null);
        }
        this.updateRootBounds(bounds);
        this.getDesignSurface().updateScrolledAreaSize();
        this.getScene().needsRebuildList();
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        if (this.myDecoratorFactory == null) {
            this.myDecoratorFactory = new NavSceneDecoratorFactory();
        }
        return this.myDecoratorFactory;
    }

    @Override
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        return ImmutableMap.of();
    }

    @Override
    public Map<Object, String> getDefaultStyles() {
        return ImmutableMap.of();
    }

    public static void updateHierarchy(@NotNull NlModel model2, @Nullable NlModel newModel) {
        Object roots = ImmutableList.of();
        XmlTag newRoot = AndroidPsiUtils.getRootTagSafely(model2.getFile());
        if (newModel != null) {
            newRoot = AndroidPsiUtils.getRootTagSafely(newModel.getFile());
            roots = NavSceneManager.buildTree((XmlTag[])newModel.getComponents().stream().map(NlComponent::getTagDeprecated).toArray(XmlTag[]::new));
        }
        if (newRoot != null) {
            model2.syncWithPsi(newRoot, (List<NlModel.TagSnapshotTreeNode>)roots);
        }
    }

    public boolean isEmpty() {
        return this.getDesignSurface().getCurrentNavigation().getChildren().stream().noneMatch(c -> NavComponentHelperKt.isDestination(c));
    }

    private static List<NlModel.TagSnapshotTreeNode> buildTree(XmlTag[] roots) {
        ArrayList<NlModel.TagSnapshotTreeNode> result2 = new ArrayList<NlModel.TagSnapshotTreeNode>();
        for (final XmlTag root : roots) {
            NlModel.TagSnapshotTreeNode node = new NlModel.TagSnapshotTreeNode(){

                @Override
                public TagSnapshot getTagSnapshot() {
                    return TagSnapshot.createTagSnapshot(root, null);
                }

                @Override
                @NotNull
                public List<NlModel.TagSnapshotTreeNode> getChildren() {
                    return NavSceneManager.buildTree(root.getSubTags());
                }
            };
            result2.add(node);
        }
        return result2;
    }

    @NotNull
    public static Rectangle getBoundingBox(@NotNull SceneComponent root) {
        return NavSceneManager.getBoundingBox(root.getChildren());
    }

    @NotNull
    public static Rectangle getBoundingBox(@NotNull List<SceneComponent> components) {
        Rectangle boundingBox = new Rectangle(0, 0, -1, -1);
        Rectangle childRect = new Rectangle();
        components.stream().filter(c -> NavComponentHelperKt.isDestination(c.getNlComponent())).forEach(child -> {
            child.fillDrawRect(0L, childRect);
            if (boundingBox.width < 0) {
                boundingBox.setBounds(childRect);
            } else {
                boundingBox.add(childRect);
            }
        });
        boundingBox.grow(BOUNDING_BOX_PADDING, BOUNDING_BOX_PADDING);
        return boundingBox;
    }

    @Override
    @NotNull
    public HitProvider getHitProvider(@NotNull NlComponent component) {
        if (NavComponentHelperKt.getSupportsActions(component)) {
            return this.myNavDestinationHitProvider;
        }
        if (NavComponentHelperKt.getPopUpTo(component) != null) {
            return this.myHorizontalActionHitProvider;
        }
        return super.getHitProvider(component);
    }

    public void performUndoablePositionAction(@NotNull NlComponent component) {
        SceneComponent sceneComponent = this.getScene().getSceneComponent(component);
        if (sceneComponent == null) {
            return;
        }
        final Object positionData = this.getPositionData(sceneComponent);
        final List<String> path = NavComponentHelperKt.getIdPath(component);
        UndoManager.getInstance((Project)this.getDesignSurface().getProject()).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{this.getModel().getFile().getVirtualFile()}){

            public void undo() {
                if (positionData == null) {
                    return;
                }
                NavSceneManager.this.restorePositionData(path, positionData);
            }

            public void redo() {
            }
        });
    }

    static {
        ACTION_HEIGHT = ACTION_ARROW_PERPENDICULAR = JBUI.scale((float)12.0f);
        ACTION_VERTICAL_PADDING = JBUI.scale((int)6);
        POP_ICON_VERTICAL_PADDING = JBUI.scale((int)10);
        ACTION_LINE_LENGTH = JBUI.scale((int)14);
        ACTION_WIDTH = ACTION_ARROW_PARALLEL + (float)ACTION_LINE_LENGTH;
        ACTION_HORIZONTAL_PADDING = JBUI.scale((int)8);
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model2) {
        }

        @Override
        public void modelChanged(@NotNull NlModel model2) {
            NavSceneManager.updateHierarchy(model2, model2);
            NavSceneManager.this.getDesignSurface().refreshRoot();
            NavSceneManager.this.requestRender();
            model2.notifyListenersModelUpdateComplete();
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
            boolean previous = NavSceneManager.this.getScene().isAnimated();
            UIUtil.invokeLaterIfNeeded(() -> {
                NavSceneManager.this.getScene().setAnimated(animate);
                NavSceneManager.this.update();
                NavSceneManager.this.getScene().setAnimated(previous);
            });
        }

        @Override
        public void modelActivated(@NotNull NlModel model2) {
            NavSceneManager.updateHierarchy(model2, model2);
            NavSceneManager.this.requestRender();
        }

        @Override
        public void modelDeactivated(@NotNull NlModel model2) {
        }
    }
}

