/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ArrowDirection;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawArrow;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.scene.ConnectionDirection;
import com.android.tools.idea.naveditor.scene.CurvePoints;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.draw.DrawIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class DrawAction
extends DrawCommandBase {
    private static final GeneralPath PATH = new GeneralPath();
    private final ActionType myActionType;
    private final Rectangle2D.Float mySource = new Rectangle2D.Float();
    private final Rectangle2D.Float myDest = new Rectangle2D.Float();
    private final Color myColor;

    public DrawAction(@NotNull String s) {
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }

    @Override
    public int getLevel() {
        return 2;
    }

    @Override
    public String serialize() {
        return DrawCommandSerializationHelperKt.buildString(this.getClass().getSimpleName(), new Object[]{this.myActionType, DrawCommandSerializationHelperKt.rect2DToString(this.mySource), DrawCommandSerializationHelperKt.rect2DToString(this.myDest), DrawCommandSerializationHelperKt.colorToString(this.myColor)});
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        NavDrawHelperKt.setRenderingHints(g);
        DrawAction.draw(g, this.myColor, this.myActionType, this.mySource, this.myDest, sceneContext);
    }

    public DrawAction(@NotNull ActionType actionType, Rectangle2D.Float source, Rectangle2D.Float dest, @NotNull Color color) {
        this.mySource.setRect(source);
        this.myDest.setRect(dest);
        this.myActionType = actionType;
        this.myColor = color;
    }

    private DrawAction(@NotNull String[] s) {
        this(ActionType.valueOf(s[0]), DrawCommandSerializationHelperKt.stringToRect2D(s[1]), DrawCommandSerializationHelperKt.stringToRect2D(s[2]), DrawCommandSerializationHelperKt.stringToColor(s[3]));
    }

    public static void buildDisplayList(@NotNull DisplayList list, @NotNull SceneView sceneView, @NotNull ActionType connectionType, boolean isPopAction, Rectangle2D.Float source, Rectangle2D.Float dest, @NotNull Color color) {
        SceneContext sceneContext = SceneContext.get(sceneView);
        list.add(new DrawAction(connectionType, source, dest, color));
        ConnectionDirection direction = NavActionHelperKt.getDestinationDirection(source, dest);
        Point2D.Float arrowPoint = NavActionHelperKt.getArrowPoint(sceneContext, dest, direction);
        ArrowDirection arrowDirection = DrawAction.getArrowDirection(direction);
        Rectangle2D.Float arrowRectangle = NavActionHelperKt.getArrowRectangle(sceneView, arrowPoint, direction);
        list.add(new DrawArrow(2, arrowDirection, arrowRectangle, color));
        if (isPopAction) {
            Rectangle2D.Float iconRectangle = NavActionHelperKt.getRegularActionIconRect(source, dest, sceneContext);
            list.add(new DrawIcon(iconRectangle, DrawIcon.IconType.POP_ACTION, color));
        }
    }

    private static void draw(@NotNull Graphics2D g, @NotNull Color color, @NotNull ActionType connectionType, Rectangle2D.Float source, Rectangle2D.Float dest, @NotNull SceneContext sceneContext) {
        PATH.reset();
        CurvePoints points = NavActionHelperKt.getCurvePoints(source, dest, sceneContext);
        PATH.moveTo(points.p1.x, points.p1.y);
        PATH.curveTo(points.p2.x, points.p2.y, points.p3.x, points.p3.y, points.p4.x, points.p4.y);
        BasicStroke actionStroke = connectionType == ActionType.EXIT_DESTINATION ? NavActionHelperKt.DASHED_ACTION_STROKE : NavActionHelperKt.ACTION_STROKE;
        g.setStroke(actionStroke);
        g.setColor(color);
        g.draw(PATH);
    }

    @NotNull
    private static ArrowDirection getArrowDirection(@NotNull ConnectionDirection direction) {
        switch (direction) {
            case LEFT: {
                return ArrowDirection.RIGHT;
            }
            case RIGHT: {
                return ArrowDirection.LEFT;
            }
            case TOP: {
                return ArrowDirection.DOWN;
            }
            case BOTTOM: {
                return ArrowDirection.UP;
            }
        }
        throw new IllegalArgumentException();
    }
}

