/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.draw.ArrowDirection;
import com.android.tools.idea.common.scene.draw.CompositeDrawCommand;
import com.android.tools.idea.common.scene.draw.DrawArrow;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import com.android.tools.idea.common.scene.draw.DrawLine;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.scene.draw.DrawIcon;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\t\u0010\u0014\u001a\u00020\tH\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u000bH\u00c2\u0003J\t\u0010\u0016\u001a\u00020\rH\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u000fH\u00c2\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\b\u0010\u001c\u001a\u00020\tH\u0016J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\t\u0010\u001f\u001a\u00020\u0004H\u00d6\u0001R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/naveditor/scene/draw/DrawHorizontalAction;", "Lcom/android/tools/idea/common/scene/draw/CompositeDrawCommand;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "level", "", "rectangle", "Ljava/awt/geom/Rectangle2D$Float;", "color", "Ljava/awt/Color;", "isPopAction", "", "(ILjava/awt/geom/Rectangle2D$Float;Ljava/awt/Color;Z)V", "buildCommands", "", "Lcom/android/tools/idea/common/scene/draw/DrawCommand;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "getLevel", "hashCode", "serialize", "toString", "intellij.android.naveditor"})
public final class DrawHorizontalAction
extends CompositeDrawCommand {
    private final int level;
    private final Rectangle2D.Float rectangle;
    private final Color color;
    private final boolean isPopAction;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String serialize() {
        return DrawCommandSerializationHelperKt.buildString(this.getClass().getSimpleName(), this.level, DrawCommandSerializationHelperKt.rect2DToString(this.rectangle), DrawCommandSerializationHelperKt.colorToString(this.color), this.isPopAction);
    }

    @Override
    @NotNull
    protected List<DrawCommand> buildCommands() {
        float scale = this.rectangle.height / NavSceneManager.ACTION_ARROW_PERPENDICULAR;
        float arrowWidth = NavSceneManager.ACTION_ARROW_PARALLEL * scale;
        float lineLength = Math.max(0.0f, this.rectangle.width - arrowWidth);
        Point2D.Float p1 = new Point2D.Float(this.rectangle.x, (float)this.rectangle.getCenterY());
        Point2D.Float p2 = new Point2D.Float(p1.x + lineLength, p1.y);
        DrawLine drawLine = new DrawLine(0, p1, p2, this.color, NavActionHelperKt.ACTION_STROKE);
        Rectangle2D.Float arrowRect = new Rectangle2D.Float(p2.x, this.rectangle.y, arrowWidth, this.rectangle.height);
        DrawArrow drawArrow = new DrawArrow(1, ArrowDirection.RIGHT, arrowRect, this.color);
        List list = CollectionsKt.mutableListOf((Object[])new DrawCommandBase[]{drawLine, drawArrow});
        if (this.isPopAction) {
            Rectangle2D.Float iconRect = NavActionHelperKt.getHorizontalActionIconRect(this.rectangle);
            DrawIcon drawIcon = new DrawIcon(iconRect, DrawIcon.IconType.POP_ACTION, this.color);
            list.add(drawIcon);
        }
        return list;
    }

    public DrawHorizontalAction(int level, @NotNull Rectangle2D.Float rectangle, @NotNull Color color, boolean isPopAction) {
        this.level = level;
        this.rectangle = rectangle;
        this.color = color;
        this.isPopAction = isPopAction;
    }

    private DrawHorizontalAction(String[] sp) {
        String string = sp[0];
        DrawHorizontalAction drawHorizontalAction = this;
        boolean bl = false;
        int n = Integer.parseInt(string);
        string = sp[3];
        Color color = DrawCommandSerializationHelperKt.stringToColor(sp[2]);
        Rectangle2D.Float float_ = DrawCommandSerializationHelperKt.stringToRect2D(sp[1]);
        bl = false;
        boolean bl2 = Boolean.parseBoolean(string);
        drawHorizontalAction(n, float_, color, bl2);
    }

    public DrawHorizontalAction(@NotNull String s) {
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }

    private final int component1() {
        return this.level;
    }

    private final Rectangle2D.Float component2() {
        return this.rectangle;
    }

    private final Color component3() {
        return this.color;
    }

    private final boolean component4() {
        return this.isPopAction;
    }

    @NotNull
    public final DrawHorizontalAction copy(int level, @NotNull Rectangle2D.Float rectangle, @NotNull Color color, boolean isPopAction) {
        return new DrawHorizontalAction(level, rectangle, color, isPopAction);
    }

    @NotNull
    public static /* synthetic */ DrawHorizontalAction copy$default(DrawHorizontalAction drawHorizontalAction, int n, Rectangle2D.Float float_, Color color, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = drawHorizontalAction.level;
        }
        if ((n2 & 2) != 0) {
            float_ = drawHorizontalAction.rectangle;
        }
        if ((n2 & 4) != 0) {
            color = drawHorizontalAction.color;
        }
        if ((n2 & 8) != 0) {
            bl = drawHorizontalAction.isPopAction;
        }
        return drawHorizontalAction.copy(n, float_, color, bl);
    }

    @NotNull
    public String toString() {
        return "DrawHorizontalAction(level=" + this.level + ", rectangle=" + this.rectangle + ", color=" + this.color + ", isPopAction=" + this.isPopAction + ")";
    }

    public int hashCode() {
        Rectangle2D.Float float_ = this.rectangle;
        Color color = this.color;
        int n = ((Integer.hashCode(this.level) * 31 + (float_ != null ? ((Object)float_).hashCode() : 0)) * 31 + (color != null ? ((Object)color).hashCode() : 0)) * 31;
        int n2 = this.isPopAction ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawHorizontalAction)) break block3;
                DrawHorizontalAction drawHorizontalAction = (DrawHorizontalAction)object;
                if (!(this.level == drawHorizontalAction.level) || !Intrinsics.areEqual((Object)this.rectangle, (Object)drawHorizontalAction.rectangle) || !Intrinsics.areEqual((Object)this.color, (Object)drawHorizontalAction.color) || !(this.isPopAction == drawHorizontalAction.isPopAction)) break block3;
            }
            return true;
        }
        return false;
    }
}

