/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import com.android.tools.idea.common.util.ImageUtilKt;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.draw.DrawIcon$WhenMappings;
import com.google.common.annotations.VisibleForTesting;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001:\u0001&B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B#\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0013\u001a\u00020\tH\u00c2\u0003J\t\u0010\u0014\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u00c2\u0003J)\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0003\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u0004H\u0016J\t\u0010%\u001a\u00020\u0004H\u00d6\u0001R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/naveditor/scene/draw/DrawIcon;", "Lcom/android/tools/idea/common/scene/draw/DrawCommandBase;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "rectangle", "Ljava/awt/geom/Rectangle2D$Float;", "iconType", "Lcom/android/tools/idea/naveditor/scene/draw/DrawIcon$IconType;", "color", "Ljava/awt/Color;", "(Ljava/awt/geom/Rectangle2D$Float;Lcom/android/tools/idea/naveditor/scene/draw/DrawIcon$IconType;Ljava/awt/Color;)V", "getIconType", "()Lcom/android/tools/idea/naveditor/scene/draw/DrawIcon$IconType;", "image", "Ljava/awt/Image;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getLevel", "", "hashCode", "onPaint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "toString", "IconType", "intellij.android.naveditor"})
public final class DrawIcon
extends DrawCommandBase {
    private final Image image;
    private final Rectangle2D.Float rectangle;
    @NotNull
    private final IconType iconType;
    private final Color color;

    @Override
    public int getLevel() {
        return 4;
    }

    @Override
    @NotNull
    public String serialize() {
        return DrawCommandSerializationHelperKt.buildString(this.getClass().getSimpleName(), new Object[]{DrawCommandSerializationHelperKt.rect2DToString(this.rectangle), this.iconType, DrawCommandSerializationHelperKt.colorOrNullToString(this.color)});
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        NavDrawHelperKt.setRenderingHints(g);
        g.drawImage(this.image, (int)this.rectangle.x, (int)this.rectangle.y, null);
    }

    @NotNull
    public final IconType getIconType() {
        return this.iconType;
    }

    public DrawIcon(@NotNull Rectangle2D.Float rectangle, @VisibleForTesting @NotNull IconType iconType, @Nullable Color color) {
        Icon icon2;
        this.rectangle = rectangle;
        this.iconType = iconType;
        this.color = color;
        switch (DrawIcon$WhenMappings.$EnumSwitchMapping$0[this.iconType.ordinal()]) {
            case 1: {
                icon2 = StudioIcons.NavEditor.Surface.START_DESTINATION;
                break;
            }
            case 2: {
                icon2 = StudioIcons.NavEditor.Surface.DEEPLINK;
                break;
            }
            case 3: {
                icon2 = StudioIcons.NavEditor.Surface.POP_ACTION;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Icon icon3 = icon2;
        if (this.color != null) {
            icon3 = ColoredIconGenerator.INSTANCE.generateColoredIcon(icon3, this.color.getRGB());
        }
        this.image = ImageUtilKt.iconToImage(icon3).getScaledInstance((int)this.rectangle.width, (int)this.rectangle.height, 4);
    }

    public /* synthetic */ DrawIcon(Rectangle2D.Float float_, IconType iconType, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            color = null;
        }
        this(float_, iconType, color);
    }

    private DrawIcon(String[] sp) {
        this(DrawCommandSerializationHelperKt.stringToRect2D(sp[0]), IconType.valueOf(sp[1]), DrawCommandSerializationHelperKt.stringToColorOrNull(sp[2]));
    }

    public DrawIcon(@NotNull String s) {
        this(DrawCommandSerializationHelperKt.parse(s, 3));
    }

    private final Rectangle2D.Float component1() {
        return this.rectangle;
    }

    @NotNull
    public final IconType component2() {
        return this.iconType;
    }

    private final Color component3() {
        return this.color;
    }

    @NotNull
    public final DrawIcon copy(@NotNull Rectangle2D.Float rectangle, @VisibleForTesting @NotNull IconType iconType, @Nullable Color color) {
        return new DrawIcon(rectangle, iconType, color);
    }

    @NotNull
    public static /* synthetic */ DrawIcon copy$default(DrawIcon drawIcon, Rectangle2D.Float float_, IconType iconType, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            float_ = drawIcon.rectangle;
        }
        if ((n & 2) != 0) {
            iconType = drawIcon.iconType;
        }
        if ((n & 4) != 0) {
            color = drawIcon.color;
        }
        return drawIcon.copy(float_, iconType, color);
    }

    @NotNull
    public String toString() {
        return "DrawIcon(rectangle=" + this.rectangle + ", iconType=" + (Object)((Object)this.iconType) + ", color=" + this.color + ")";
    }

    public int hashCode() {
        Rectangle2D.Float float_ = this.rectangle;
        IconType iconType = this.iconType;
        Color color = this.color;
        return ((float_ != null ? ((Object)float_).hashCode() : 0) * 31 + (iconType != null ? ((Object)((Object)iconType)).hashCode() : 0)) * 31 + (color != null ? ((Object)color).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawIcon)) break block3;
                DrawIcon drawIcon = (DrawIcon)object;
                if (!Intrinsics.areEqual((Object)this.rectangle, (Object)drawIcon.rectangle) || !Intrinsics.areEqual((Object)((Object)this.iconType), (Object)((Object)drawIcon.iconType)) || !Intrinsics.areEqual((Object)this.color, (Object)drawIcon.color)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/naveditor/scene/draw/DrawIcon$IconType;", "", "(Ljava/lang/String;I)V", "START_DESTINATION", "DEEPLINK", "POP_ACTION", "intellij.android.naveditor"})
    public static final class IconType
    extends Enum<IconType> {
        public static final /* enum */ IconType START_DESTINATION;
        public static final /* enum */ IconType DEEPLINK;
        public static final /* enum */ IconType POP_ACTION;
        private static final /* synthetic */ IconType[] $VALUES;

        static {
            IconType[] iconTypeArray = new IconType[3];
            IconType[] iconTypeArray2 = iconTypeArray;
            iconTypeArray[0] = START_DESTINATION = new IconType();
            iconTypeArray[1] = DEEPLINK = new IconType();
            iconTypeArray[2] = POP_ACTION = new IconType();
            $VALUES = iconTypeArray;
        }

        public static IconType[] values() {
            return (IconType[])$VALUES.clone();
        }

        public static IconType valueOf(String string) {
            return Enum.valueOf(IconType.class, string);
        }
    }
}

