/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import com.android.tools.idea.naveditor.scene.NavColors;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.RefinableImage;
import com.android.tools.idea.naveditor.scene.draw.DrawNavScreenKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B\u0017\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u001a\u001a\u00020\u0004H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/naveditor/scene/draw/DrawNavScreen;", "Lcom/android/tools/idea/common/scene/draw/DrawCommandBase;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "rectangle", "Ljava/awt/geom/Rectangle2D$Float;", "image", "Lcom/android/tools/idea/naveditor/scene/RefinableImage;", "(Ljava/awt/geom/Rectangle2D$Float;Lcom/android/tools/idea/naveditor/scene/RefinableImage;)V", "getRectangle", "()Ljava/awt/geom/Rectangle2D$Float;", "drawText", "", "text1", "text2", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "getLevel", "", "onPaint", "serialize", "intellij.android.naveditor"})
public final class DrawNavScreen
extends DrawCommandBase {
    @NotNull
    private final Rectangle2D.Float rectangle;
    private final RefinableImage image;

    @Override
    public int getLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String serialize() {
        return DrawCommandSerializationHelperKt.buildString(this.getClass().getSimpleName(), DrawCommandSerializationHelperKt.rect2DToString(this.rectangle));
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        NavDrawHelperKt.setRenderingHints(g);
        g.clip(this.rectangle);
        RefinableImage lastCompleted2 = this.image.getLastCompleted();
        BufferedImage image = lastCompleted2.getImage();
        if (image != null) {
            AffineTransform transform2 = new AffineTransform();
            transform2.translate(this.rectangle.x, this.rectangle.y);
            UIUtil.drawImage((Graphics)g, (Image)image, (int)((int)this.rectangle.x), (int)((int)this.rectangle.y), null);
        } else if (lastCompleted2.getRefined() == null) {
            this.drawText("Preview", "Unavailable", g, sceneContext);
        } else {
            this.drawText("Loading...", null, g, sceneContext);
        }
        if (lastCompleted2.getRefined() != null) {
            lastCompleted2.getRefined().thenRun(new Runnable(sceneContext){
                final /* synthetic */ SceneContext $sceneContext;

                public final void run() {
                    this.$sceneContext.repaint();
                }
                {
                    this.$sceneContext = sceneContext;
                }
            });
        }
    }

    private final void drawText(String text1, String text2, Graphics2D g, SceneContext sceneContext) {
        g.setColor((Color)NavColors.INSTANCE.getPLACEHOLDER_BACKGROUND());
        g.fill(this.rectangle);
        g.setColor((Color)NavColors.INSTANCE.getPLACEHOLDER_TEXT());
        g.setFont(new Font("Default", 0, sceneContext.getSwingDimension(DrawNavScreenKt.access$getFONT_SIZE$p())));
        float x = this.rectangle.x + (this.rectangle.width - (float)g.getFontMetrics().stringWidth(text1)) / (float)2;
        int padding = sceneContext.getSwingDimension(DrawNavScreenKt.access$getTEXT_PADDING$p());
        float y = this.rectangle.y + (this.rectangle.height - (float)padding) / (float)2;
        g.drawString(text1, x, y);
        if (text2 != null) {
            x = this.rectangle.x + (this.rectangle.width - (float)g.getFontMetrics().stringWidth(text2)) / (float)2;
            g.drawString(text2, x, y += (float)(g.getFontMetrics().getAscent() + padding));
        }
    }

    @NotNull
    public final Rectangle2D.Float getRectangle() {
        return this.rectangle;
    }

    public DrawNavScreen(@VisibleForTesting @NotNull Rectangle2D.Float rectangle, @NotNull RefinableImage image) {
        this.rectangle = rectangle;
        this.image = image;
    }

    private DrawNavScreen(String[] sp) {
        this(DrawCommandSerializationHelperKt.stringToRect2D(sp[0]), new RefinableImage(null, null, 3, null));
    }

    public DrawNavScreen(@NotNull String s) {
        this(DrawCommandSerializationHelperKt.parse(s, 1));
    }
}

