/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.draw.CompositeDrawCommand;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import com.android.tools.idea.common.scene.draw.DrawFilledRectangle;
import com.android.tools.idea.common.scene.draw.DrawLine;
import com.android.tools.idea.naveditor.scene.NavColors;
import com.android.tools.idea.naveditor.scene.decorator.NavBaseDecoratorKt;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\t\u0010\u0010\u001a\u00020\tH\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u000bH\u00c2\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\b\u0010\u0017\u001a\u00020\tH\u0016J\t\u0010\u0018\u001a\u00020\tH\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/naveditor/scene/draw/DrawPlaceholder;", "Lcom/android/tools/idea/common/scene/draw/CompositeDrawCommand;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "level", "", "rectangle", "Ljava/awt/geom/Rectangle2D$Float;", "(ILjava/awt/geom/Rectangle2D$Float;)V", "buildCommands", "", "Lcom/android/tools/idea/common/scene/draw/DrawCommand;", "component1", "component2", "copy", "equals", "", "other", "", "getLevel", "hashCode", "serialize", "toString", "intellij.android.naveditor"})
public final class DrawPlaceholder
extends CompositeDrawCommand {
    private final int level;
    private final Rectangle2D.Float rectangle;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String serialize() {
        return DrawCommandSerializationHelperKt.buildString(this.getClass().getSimpleName(), this.level, DrawCommandSerializationHelperKt.rect2DToString(this.rectangle));
    }

    @Override
    @NotNull
    protected List<DrawCommand> buildCommands() {
        DrawFilledRectangle rect = new DrawFilledRectangle(0, this.rectangle, (Color)NavColors.INSTANCE.getPLACEHOLDER_BACKGROUND());
        JBColor color = NavColors.INSTANCE.getPLACEHOLDER_BORDER();
        BasicStroke stroke = new BasicStroke(NavBaseDecoratorKt.getREGULAR_FRAME_THICKNESS());
        Point2D.Float p1 = new Point2D.Float(this.rectangle.x, this.rectangle.y);
        Point2D.Float p2 = new Point2D.Float(p1.x, p1.y + this.rectangle.height);
        Point2D.Float p3 = new Point2D.Float(p1.x + this.rectangle.width, p1.y);
        Point2D.Float p4 = new Point2D.Float(p3.x, p2.y);
        DrawLine line1 = new DrawLine(1, p1, p4, (Color)color, stroke);
        DrawLine line2 = new DrawLine(2, p2, p3, (Color)color, stroke);
        return CollectionsKt.listOf((Object[])new DrawCommandBase[]{rect, line1, line2});
    }

    public DrawPlaceholder(int level, @NotNull Rectangle2D.Float rectangle) {
        this.level = level;
        this.rectangle = rectangle;
    }

    private DrawPlaceholder(String[] sp) {
        String string = sp[0];
        DrawPlaceholder drawPlaceholder = this;
        boolean bl = false;
        int n = Integer.parseInt(string);
        drawPlaceholder(n, DrawCommandSerializationHelperKt.stringToRect2D(sp[1]));
    }

    public DrawPlaceholder(@NotNull String s) {
        this(DrawCommandSerializationHelperKt.parse(s, 2));
    }

    private final int component1() {
        return this.level;
    }

    private final Rectangle2D.Float component2() {
        return this.rectangle;
    }

    @NotNull
    public final DrawPlaceholder copy(int level, @NotNull Rectangle2D.Float rectangle) {
        return new DrawPlaceholder(level, rectangle);
    }

    @NotNull
    public static /* synthetic */ DrawPlaceholder copy$default(DrawPlaceholder drawPlaceholder, int n, Rectangle2D.Float float_, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = drawPlaceholder.level;
        }
        if ((n2 & 2) != 0) {
            float_ = drawPlaceholder.rectangle;
        }
        return drawPlaceholder.copy(n, float_);
    }

    @NotNull
    public String toString() {
        return "DrawPlaceholder(level=" + this.level + ", rectangle=" + this.rectangle + ")";
    }

    public int hashCode() {
        Rectangle2D.Float float_ = this.rectangle;
        return Integer.hashCode(this.level) * 31 + (float_ != null ? ((Object)float_).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawPlaceholder)) break block3;
                DrawPlaceholder drawPlaceholder = (DrawPlaceholder)object;
                if (!(this.level == drawPlaceholder.level) || !Intrinsics.areEqual((Object)this.rectangle, (Object)drawPlaceholder.rectangle)) break block3;
            }
            return true;
        }
        return false;
    }
}

