/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavColors;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandle;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandleDrag;
import com.android.tools.idea.naveditor.scene.targets.NavBaseTarget;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.Point2D;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionHandleTarget
extends NavBaseTarget {
    private static final int DURATION = 200;
    private static String DRAG_CREATE_IN_PROGRESS = "DRAG_CREATE_IN_PROGRESS";
    private HandleState myHandleState = this.calculateState();
    private boolean myIsDragging = false;

    public ActionHandleTarget(@NotNull SceneComponent component) {
        super(component);
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int x = r;
        if (NavComponentHelperKt.isFragment(this.getComponent().getNlComponent())) {
            x += NavDrawHelperKt.ACTION_HANDLE_OFFSET;
        }
        this.layoutCircle(x, t + (b - t) / 2, (int)this.myHandleState.myOuterRadius);
        return false;
    }

    @Override
    public void mouseDown(int x, int y) {
        Scene scene = this.myComponent.getScene();
        scene.getDesignSurface().getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)this.getComponent().getNlComponent()));
        this.myIsDragging = true;
        scene.needsRebuildList();
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        parent.getNlComponent().putClientProperty(DRAG_CREATE_IN_PROGRESS, true);
        this.getComponent().setDragging(true);
        scene.repaint();
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        NlComponent action2;
        this.myIsDragging = false;
        Scene scene = this.myComponent.getScene();
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        parent.getNlComponent().removeClientProperty(DRAG_CREATE_IN_PROGRESS);
        this.getComponent().setDragging(false);
        SceneComponent closestComponent = scene.findComponent(SceneContext.get(this.getComponent().getScene().getSceneManager().getSceneView()), x, y);
        if (closestComponent != null && closestComponent != this.getComponent().getScene().getRoot() && StringUtil.isNotEmpty((String)closestComponent.getId()) && (action2 = this.createAction(closestComponent)) != null) {
            NavUsageTracker.Companion.getInstance(action2.getModel()).createEvent(NavEditorEvent.NavEditorEventType.CREATE_ACTION).withActionInfo(action2).withSource(NavEditorEvent.Source.DESIGN_SURFACE).log();
            this.getComponent().getScene().getDesignSurface().getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)action2));
        }
        scene.needsRebuildList();
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Nullable
    private NlComponent createAction(@NotNull SceneComponent destination) {
        if (this.mIsOver) {
            return null;
        }
        NlComponent destinationNlComponent = destination.getNlComponent();
        if (!NavComponentHelperKt.isDestination(destinationNlComponent)) {
            return null;
        }
        NlComponent myNlComponent = this.getComponent().getNlComponent();
        return (NlComponent)WriteCommandAction.runWriteCommandAction((Project)myNlComponent.getModel().getProject(), () -> NavComponentHelperKt.createAction(myNlComponent, destinationNlComponent.getId()));
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        JBColor innerColor;
        HandleState newState = this.calculateState();
        if (newState == HandleState.INVISIBLE && this.myHandleState == HandleState.INVISIBLE) {
            return;
        }
        SceneView view = this.myComponent.getScene().getDesignSurface().getCurrentSceneView();
        if (view == null) {
            return;
        }
        float centerX = Coordinates.getSwingXDip(view, this.getCenterX());
        float centerY = Coordinates.getSwingYDip(view, this.getCenterY());
        Point2D.Float center = new Point2D.Float(centerX, centerY);
        float initialOuterRadius = Coordinates.getSwingDimension(view, this.myHandleState.myOuterRadius);
        float finalOuterRadius = Coordinates.getSwingDimension(view, newState.myOuterRadius);
        float initialInnerRadius = Coordinates.getSwingDimension(view, this.myHandleState.myInnerRadius);
        float finalInnerRadius = Coordinates.getSwingDimension(view, newState.myInnerRadius);
        int duration = (int)Math.abs(200.0f * (this.myHandleState.myOuterRadius - newState.myOuterRadius) / NavDrawHelperKt.OUTER_RADIUS_LARGE);
        JBColor outerColor = StudioColorsKt.getPrimaryPanelBackground();
        JBColor jBColor = innerColor = this.getComponent().isSelected() ? NavColors.SELECTED : NavColors.HIGHLIGHTED_FRAME;
        if (this.myIsDragging) {
            list.add(new DrawActionHandleDrag(8, center, initialOuterRadius, finalOuterRadius, finalInnerRadius, duration));
        } else {
            list.add(new DrawActionHandle(7, center, initialOuterRadius, finalOuterRadius, initialInnerRadius, finalInnerRadius, duration, (Color)innerColor, (Color)outerColor));
        }
        this.myHandleState = newState;
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        picker.addCircle(this, 0, this.getSwingCenterX(transform2), this.getSwingCenterY(transform2), transform2.getSwingDimension((int)NavDrawHelperKt.OUTER_RADIUS_LARGE));
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    private HandleState calculateState() {
        if (this.myIsDragging) {
            return HandleState.SMALL;
        }
        if (this.myComponent.getScene().getDesignSurface().getInteractionManager().isInteractionInProgress()) {
            return HandleState.INVISIBLE;
        }
        if (this.mIsOver) {
            return HandleState.LARGE;
        }
        if (this.getComponent().getDrawState() == SceneComponent.DrawState.HOVER) {
            return HandleState.SMALL;
        }
        if (this.getComponent().isSelected() && this.myComponent.getScene().getSelection().size() == 1) {
            return HandleState.SMALL;
        }
        return HandleState.INVISIBLE;
    }

    public static boolean isDragCreateInProgress(@NotNull NlComponent component) {
        NlComponent parent = component.getParent();
        return parent != null && parent.getClientProperty(DRAG_CREATE_IN_PROGRESS) != null;
    }

    private static enum HandleState {
        INVISIBLE(0.0f, 0.0f),
        SMALL(NavDrawHelperKt.INNER_RADIUS_SMALL, NavDrawHelperKt.OUTER_RADIUS_SMALL),
        LARGE(NavDrawHelperKt.INNER_RADIUS_LARGE, NavDrawHelperKt.OUTER_RADIUS_LARGE);

        private final float myInnerRadius;
        private final float myOuterRadius;

        private HandleState(float innerRadius, float outerRadius) {
            this.myInnerRadius = innerRadius;
            this.myOuterRadius = outerRadius;
        }
    }
}

