/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.ConnectionDirection;
import com.android.tools.idea.naveditor.scene.CurvePoints;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt;
import com.google.common.collect.ImmutableList;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionTarget
extends BaseTarget {
    private static final Rectangle2D.Float SOURCE_RECT = new Rectangle2D.Float();
    private static final Rectangle2D.Float DEST_RECT = new Rectangle2D.Float();
    private final SceneComponent mySourceComponent;
    private final SceneComponent myDestComponent;
    private final ActionType myActionType;

    public ActionTarget(@NotNull SceneComponent component, @NotNull SceneComponent source, @NotNull SceneComponent destination) {
        this.setComponent(component);
        this.mySourceComponent = source;
        this.myDestComponent = destination;
        this.myActionType = NavComponentHelperKt.getActionType(component.getNlComponent(), component.getScene().getRoot().getNlComponent());
    }

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    @Override
    @Nullable
    public List<SceneComponent> newSelection() {
        return ImmutableList.of((Object)this.myComponent);
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int l, int t, int r, int b) {
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        Rectangle2D.Float source = Coordinates.getSwingRectDip(transform2, this.mySourceComponent.fillDrawRect2D(0L, SOURCE_RECT));
        boolean isPopAction = NavComponentHelperKt.getPopUpTo(this.myComponent.getNlComponent()) != null;
        Rectangle2D.Float iconRect = null;
        if (this.myActionType == ActionType.SELF) {
            Point2D.Float[] points = ActionTarget.getSelfActionPoints(source, transform2);
            for (int i2 = 1; i2 < points.length; ++i2) {
                picker.addLine(this, 0, (int)points[i2 - 1].x, (int)points[i2 - 1].y, (int)points[i2].x, (int)points[i2].y, 5);
            }
            if (isPopAction) {
                iconRect = NavActionHelperKt.getSelfActionIconRect(points[0], transform2);
            }
        } else {
            Rectangle2D.Float dest = Coordinates.getSwingRectDip(transform2, this.myDestComponent.fillDrawRect2D(0L, DEST_RECT));
            CurvePoints points = NavActionHelperKt.getCurvePoints(source, dest, transform2);
            picker.addCurveTo(this, 0, (int)points.p1.x, (int)points.p1.y, (int)points.p2.x, (int)points.p2.y, (int)points.p3.x, (int)points.p3.y, (int)points.p4.x, (int)points.p4.y, 10);
            if (isPopAction) {
                iconRect = NavActionHelperKt.getRegularActionIconRect(source, dest, transform2);
            }
        }
        if (iconRect != null) {
            picker.addRect(this, 0, (int)iconRect.x, (int)iconRect.y, (int)(iconRect.x + iconRect.width), (int)(iconRect.y + iconRect.height));
        }
    }

    @NotNull
    private static Point2D.Float[] getSelfActionPoints(@NotNull Rectangle2D.Float rect, @NotNull SceneContext sceneContext) {
        Point2D.Float start = NavActionHelperKt.getStartPoint(rect);
        Point2D.Float end = ActionTarget.getSelfActionEndPoint(rect, sceneContext);
        return NavActionHelperKt.selfActionPoints(start, end, sceneContext);
    }

    @NotNull
    private static Point2D.Float getSelfActionEndPoint(@NotNull Rectangle2D.Float rect, @NotNull SceneContext sceneContext) {
        Point2D.Float end = NavActionHelperKt.getEndPoint(sceneContext, rect, ConnectionDirection.BOTTOM);
        end.x += rect.width / 2.0f + (float)sceneContext.getSwingDimension(NavActionHelperKt.SELF_ACTION_LENGTHS[0] - NavActionHelperKt.SELF_ACTION_LENGTHS[2]);
        return end;
    }

    @Override
    public String getToolTipText() {
        return this.getComponent().getId();
    }
}

