/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.LegacyDragTarget;
import com.android.tools.idea.common.scene.target.MultiComponentTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.google.common.collect.ImmutableList;
import java.awt.Cursor;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ScreenDragTarget
extends DragBaseTarget
implements MultiComponentTarget,
LegacyDragTarget {
    private final Point[] myChildOffsets;

    public ScreenDragTarget(@NotNull SceneComponent component) {
        this.setComponent(component);
        this.myChildOffsets = new Point[component.getChildren().size()];
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
    }

    @Override
    public void mouseDown(int x, int y) {
        super.mouseDown(x, y);
        for (int i2 = 0; i2 < this.getComponent().getChildren().size(); ++i2) {
            SceneComponent child = this.getComponent().getChild(i2);
            this.myChildOffsets[i2] = new Point(x - child.getDrawX(), y - child.getDrawY());
        }
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTarget) {
        SceneComponent parent = this.myComponent.getParent();
        if (parent == null) {
            return;
        }
        this.myComponent.setDragging(true);
        int dx = x - this.myOffsetX;
        int dy = y - this.myOffsetY;
        if (dx < parent.getDrawX() || dx + this.myComponent.getDrawWidth() > parent.getDrawX() + parent.getDrawWidth()) {
            return;
        }
        if (dy < parent.getDrawY() || dy + this.myComponent.getDrawHeight() > parent.getDrawY() + parent.getDrawHeight()) {
            return;
        }
        this.myComponent.setPosition(dx, dy);
        this.myChangedComponent = true;
        for (int i2 = 0; i2 < this.myChildOffsets.length; ++i2) {
            int newX = x - this.myChildOffsets[i2].x;
            int newY = y - this.myChildOffsets[i2].y;
            this.getComponent().getChild(i2).setPosition(newX, newY);
        }
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (!this.myComponent.isDragging()) {
            return;
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            if (Math.abs(x - this.myFirstMouseX) <= 1 && Math.abs(y - this.myFirstMouseY) <= 1) {
                return;
            }
            ((NavSceneManager)this.myComponent.getScene().getSceneManager()).save((List<SceneComponent>)ImmutableList.of((Object)this.myComponent));
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().needsLayout(1);
        }
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }
}

